/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.io.IOException;
import java.io.InputStream;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class PullSourceStreamInputStream
extends InputStream {
    private final PullSourceStream pss;
    private final Seekable seekable;
    private long markPosition = -1L;

    public PullSourceStreamInputStream(PullSourceStream pullSourceStream) {
        this.pss = pullSourceStream;
        this.seekable = pullSourceStream instanceof Seekable ? (Seekable)((Object)pullSourceStream) : null;
    }

    public synchronized void mark(int n) {
        if (!this.markSupported()) {
            super.mark(n);
        }
        this.markPosition = this.seekable.tell();
    }

    public boolean markSupported() {
        return this.seekable != null;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.pss.read(byArray, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.pss.read(byArray, n, n2);
        return n3;
    }

    public synchronized void reset() throws IOException {
        if (!this.markSupported()) {
            super.reset();
        }
        if (this.markPosition < 0L) {
            throw new IOException("mark must be called before reset");
        }
        this.seekable.seek(this.markPosition);
    }

    public long skip(long l) throws IOException {
        if (this.seekable == null) {
            return super.skip(l);
        }
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.seekable.tell();
        long l3 = this.seekable.seek(l2 + l);
        return l3 - l2;
    }
}

