/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.util.logging.Logger;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.protocol.ContentDescriptor;
import net.sf.fmj.media.AbstractPlugIn;
import net.sf.fmj.utility.LoggerSingleton;

public abstract class AbstractMultiplexer
extends AbstractPlugIn
implements Multiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    protected ContentDescriptor outputContentDescriptor;
    protected Format[] inputFormats;
    protected int numTracks;

    public ContentDescriptor setContentDescriptor(ContentDescriptor contentDescriptor) {
        this.outputContentDescriptor = contentDescriptor;
        return contentDescriptor;
    }

    public Format setInputFormat(Format format, int n) {
        if (n >= this.numTracks) {
            logger.warning("Rejecting input format for track number out of range: " + n + ": " + format);
            return null;
        }
        boolean bl = false;
        for (Format format2 : this.getSupportedInputFormats()) {
            if (!format2.matches(format)) continue;
            bl = true;
        }
        if (!bl) {
            logger.fine("Rejecting unsupported input format for track " + n + ": " + format);
            return null;
        }
        logger.finer("setInputFormat " + format + " " + n);
        if (this.inputFormats != null) {
            this.inputFormats[n] = format;
        }
        return format;
    }

    public int setNumTracks(int n) {
        logger.finer("setNumTracks " + n);
        this.inputFormats = new Format[n];
        this.numTracks = n;
        return n;
    }
}

