/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ffmpeg_java;

import com.lti.utils.collections.Queue;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import net.sf.ffmpeg_java.AVCodecLibrary;
import net.sf.ffmpeg_java.AVFormatLibrary;
import net.sf.ffmpeg_java.AVUtilLibrary;
import net.sf.ffmpeg_java.FFMPEGLibrary;
import net.sf.ffmpeg_java.custom_protocol.CallbackURLProtocolHandler;
import net.sf.ffmpeg_java.custom_protocol.CallbackURLProtocolMgr;
import net.sf.ffmpeg_java.util.ImageConverter;
import net.sf.ffmpeg_java.util.ImageConverterSingleton;
import net.sf.fmj.ffmpeg_java.ListFormats;
import net.sf.fmj.ffmpeg_java.PullDataSourceCallbackURLProtocolHandler;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;

public class FFMPEGParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean PROCEED_IF_NO_AUDIO_CODEC = true;
    private final AVFormatLibrary AVFORMAT;
    private final AVCodecLibrary AVCODEC;
    private final AVUtilLibrary AVUTIL;
    private final ImageConverter imageConverter;
    private AVFormatLibrary.AVFormatContext formatCtx;
    private ContentDescriptor[] supportedInputContentDescriptors = null;
    static final String FIRST_FFMPEG_DEMUX_NAME = "aac";
    private static final Object AV_SYNC_OBJ = new Boolean(true);
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;
    private Queue[] packetQueues;
    static final String[] AAC_MIMETYPE = new String[]{"audio/X-HX-AAC-ADTS"};
    static final String[] DV_MIMETYPE = new String[]{"video/x-dv"};
    static final String[] H264_MIMETYPE = new String[]{"video/mp4"};
    static final String[] M4V_MIMETYPE = new String[]{"video/mp4v-es"};
    static final String[] ALAW_MIMETYPE = new String[]{"audio/x-alaw"};
    static final String[] MULAW_MIMETYPE = new String[]{"audio/x-mulaw"};
    static final String[] ASF_MIMETYPES = new String[]{"video/x-ms-wmv", "video/x-ms-wma"};
    static final String[] FLIC_MIMETYPES = new String[]{"video/fli", "video/flc", "video/x-fli", "video/x-flc"};
    static final String[] MATROSKA_MIMETYPES = new String[]{"video/x-matroska", "audio/x-matroska"};
    static final String[] MJPEG_MIMETYPE = new String[]{"video/x-motion-jpeg"};
    static final String[] MOV_MP4_M4A_3GP_3G2_MJ2_MIMETYPES = new String[]{"video/quicktime", "video/mp4", "video/3gpp", "video/mj2"};
    static final String[] MUSEPACK_MIMETYPE = new String[]{"audio/x-musepack"};
    static final String[] MPEGTSRAW_MIMETYPE = new String[]{"video/x-mpegts"};
    static final String[] MPEG1VIDEO_MIMETYPE = new String[]{"video/mpeg"};
    static final String[] MPEG2VIDEO_MIMETYPES = new String[]{"video/mpv", "video/mp2p"};
    static final String[] MTV_MIMETYPE = new String[]{"video/x-amv"};
    static final String[] MXF_MIMETYPE = new String[]{"application/mxf"};
    static final String[] NUV_MIMETYPE = new String[]{"video/x-nuv"};
    static final String[] NSV_MIMETYPE = new String[]{"application/x-nsv-vp3-mp3"};
    static final String[] OGG_MIMETYPE = new String[]{"audio/ogg"};
    static final String[] SHN_MIMETYPE = new String[]{"application/x-shorten"};
    static final String[] TTA_MIMETYPE = new String[]{"audio/x-tta"};
    static final String[] WAVPACK_MIMETYPE = new String[]{"audio/x-wavpack"};
    static final String[] NOT_SUPPORTED_FORMAT = new String[0];
    static final String[] FOURXM_MIMETYPE = new String[]{"video/x-4xm"};
    static final String[] APC_MIMETYPE = new String[]{"audio/x-apc"};
    static final String[] AVS_MIMETYPE = new String[]{"video/x-avs"};
    static final String[] BETHSOFTVID_MIMETYPE = new String[]{"video/x-bethsoft-vid"};
    static final String[] C93_MIMETYPE = new String[]{"video/x-c93"};
    static final String[] CPK_MIMETYPE = new String[]{"video/x-film-cpk"};
    static final String[] DXA_MIMETYPE = new String[]{"video/x-dxa"};
    static final String[] DSICIN_MIMETYPE = new String[]{"video/x-dsicin"};
    static final String[] DTS_MIMETYPE = new String[]{"audio/x-raw-dts"};
    static final String[] EA_MIMETYPE = new String[]{"video/x-ea"};
    static final String[] GXF_MIMETYPE = new String[]{"video/x-gxf"};
    static final String[] IDCIN_MIMETYPE = new String[]{"video/x-idcin"};
    static final String[] INGENIENT_MIMETYPE = new String[]{"video/x-ingenient"};
    static final String[] MM_MIMETYPE = new String[]{"video/x-mm"};
    static final String[] MVE_MIMETYPE = new String[]{"video/x-mve"};
    static final String[] PSXSTR_MIMETYPE = new String[]{"audio/x-psxstr"};
    static final String[] RAWVIDEO_MIMETYPE = new String[]{"video/x-raw-yuv"};
    static final String[] ROQ_MIMETYPE = new String[]{"video/x-roq"};
    static final String[] SMK_MIMETYPE = new String[]{"video/x-smk"};
    static final String[] SOL_MIMETYPE = new String[]{"audio/x-sol"};
    static final String[] THP_MIMETYPE = new String[]{"video/x-thp"};
    static final String[] SEQ_MIMETYPE = new String[]{"video/x-seq"};
    static final String[] TXD_MIMETYPE = new String[]{"video/x-txd"};
    static final String[] VC1_MIMETYPE = new String[]{"video/x-raw-vc1"};
    static final String[] VMD_MIMETYPE = new String[]{"video/x-vmd"};
    static final String[] WC3MOVIE_MIMETYPE = new String[]{"video/x-wc3-movie"};
    static final String[] WSAUD_MIMETYPE = new String[]{"video/x-wsaud"};
    static final String[] WSVQA_MIMETYPE = new String[]{"video/x-wsvqa"};

    public static AudioFormat convertCodecAudioFormat(AVCodecLibrary.AVCodecContext aVCodecContext) {
        AudioFormat audioFormat = null;
        switch (aVCodecContext.codec_id) {
            case 86020: {
                audioFormat = new AudioFormat("dolbyac3", aVCodecContext.sample_rate, 16, aVCodecContext.channels, ListFormats.isBigEndian() ? 1 : 0, 1);
                break;
            }
            default: {
                audioFormat = new AudioFormat("LINEAR", aVCodecContext.sample_rate, 16, aVCodecContext.channels, ListFormats.isBigEndian() ? 1 : 0, 1);
            }
        }
        return audioFormat;
    }

    static double getFPS(AVFormatLibrary.AVStream aVStream, AVCodecLibrary.AVCodecContext aVCodecContext) {
        FFMPEGLibrary.AVRational aVRational = FFMPEGParser.getTimeBase(aVStream, aVCodecContext);
        return (double)aVRational.den / (double)aVRational.num;
    }

    static FFMPEGLibrary.AVRational getTimeBase(AVFormatLibrary.AVStream aVStream, AVCodecLibrary.AVCodecContext aVCodecContext) {
        if (aVStream.r_frame_rate.num != 0 && aVStream.r_frame_rate.den != 0) {
            FFMPEGLibrary.AVRational aVRational = new FFMPEGLibrary.AVRational();
            aVRational.num = aVStream.r_frame_rate.den;
            aVRational.den = aVStream.r_frame_rate.num;
            return aVRational;
        }
        if (aVStream.time_base.num != 0 && aVStream.time_base.den != 0) {
            return aVStream.time_base;
        }
        return aVCodecContext.time_base;
    }

    static long getTimestamp(AVCodecLibrary.AVFrame aVFrame, AVFormatLibrary.AVStream aVStream, AVCodecLibrary.AVCodecContext aVCodecContext, long l, long l2) {
        double d = l2 != Long.MIN_VALUE ? (double)l2 : (aVFrame.opaque != null && (long)aVFrame.opaque.getInt(0L) != Long.MIN_VALUE ? (double)aVFrame.opaque.getInt(0L) : 0.0);
        return (long)((d *= (double)aVStream.time_base.num / (double)aVStream.time_base.den) * 1.0E9);
    }

    public FFMPEGParser() {
        try {
            this.AVFORMAT = AVFormatLibrary.INSTANCE;
            this.AVCODEC = AVCodecLibrary.INSTANCE;
            this.AVUTIL = AVUtilLibrary.INSTANCE;
            this.imageConverter = ImageConverterSingleton.instance();
            this.AVFORMAT.av_register_all();
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Unable to initialize ffmpeg libraries: " + throwable);
            throw new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = AV_SYNC_OBJ;
        synchronized (object) {
            if (this.tracks != null) {
                for (int i = 0; i < this.tracks.length; ++i) {
                    if (this.tracks[i] == null) continue;
                    this.tracks[i].deallocate();
                    this.tracks[i] = null;
                }
                this.tracks = null;
            }
            if (this.formatCtx != null) {
                this.AVFORMAT.av_close_input_file(this.formatCtx);
                this.formatCtx = null;
            }
        }
        super.close();
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        if (this.supportedInputContentDescriptors == null) {
            this.queryInputContentDescriptors();
        }
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public boolean isPositionable() {
        return true;
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AVFormatLibrary.AVPacket nextPacket(int n) {
        Object object = AV_SYNC_OBJ;
        synchronized (object) {
            AVFormatLibrary.AVPacket aVPacket;
            if (!this.packetQueues[n].isEmpty()) {
                return (AVFormatLibrary.AVPacket)this.packetQueues[n].dequeue();
            }
            while (this.AVFORMAT.av_read_frame(this.formatCtx, aVPacket = new AVFormatLibrary.AVPacket()) >= 0) {
                if (aVPacket.stream_index == n) {
                    return aVPacket;
                }
                this.packetQueues[aVPacket.stream_index].enqueue(aVPacket);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceUnavailableException {
        Object object = AV_SYNC_OBJ;
        synchronized (object) {
            int n;
            String string;
            String string2;
            String string3;
            try {
                this.AVCODEC.avcodec_init();
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "" + throwable, throwable);
                throw new ResourceUnavailableException("avcodec_init or av_register_all failed");
            }
            if (this.AVCODEC.avcodec_version() != 3355137) {
                logger.warning("ffmpeg-java and ffmpeg versions do not match: avcodec_version=" + this.AVCODEC.avcodec_version() + " LIBAVCODEC_VERSION_INT=" + 3355137);
            }
            if ((string3 = this.source.getLocator().getProtocol()).equals("file") || string3.equals("http")) {
                string2 = string3.equals("file") ? URLUtils.extractValidPathFromFileUrl(this.source.getLocator().toExternalForm()) : this.source.getLocator().toExternalForm();
            } else {
                CallbackURLProtocolMgr.register((AVFormatLibrary)this.AVFORMAT);
                string2 = string = CallbackURLProtocolMgr.addCallbackURLProtocolHandler((CallbackURLProtocolHandler)new PullDataSourceCallbackURLProtocolHandler(this.source));
            }
            string = new PointerByReference();
            int n2 = this.AVFORMAT.av_open_input_file((PointerByReference)string, string2, null, 0, null);
            if (n2 != 0) {
                throw new ResourceUnavailableException("av_open_input_file failed: " + n2);
            }
            this.formatCtx = new AVFormatLibrary.AVFormatContext(string.getValue());
            if (this.AVFORMAT.av_find_stream_info(this.formatCtx) < 0) {
                throw new ResourceUnavailableException("Couldn't find stream information");
            }
            this.AVFORMAT.dump_format(this.formatCtx, 0, string2, 0);
            VideoTrack videoTrack = null;
            AudioTrack audioTrack = null;
            for (n = 0; n < this.formatCtx.nb_streams; ++n) {
                AVFormatLibrary.AVStream aVStream = new AVFormatLibrary.AVStream(this.formatCtx.getStreams()[n]);
                AVCodecLibrary.AVCodecContext aVCodecContext = new AVCodecLibrary.AVCodecContext(aVStream.codec);
                if (aVCodecContext.codec_id == 0) {
                    logger.info("Codec id is zero (no codec) - skipping stream " + n);
                    continue;
                }
                if (aVCodecContext.codec_type == 0 && videoTrack == null) {
                    videoTrack = new VideoTrack(n, aVStream, aVCodecContext);
                    continue;
                }
                if (aVCodecContext.codec_type != 1 || audioTrack != null) continue;
                try {
                    audioTrack = new AudioTrack(n, aVStream, aVCodecContext);
                    continue;
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    logger.log(Level.WARNING, "Skipping audio track: " + resourceUnavailableException, resourceUnavailableException);
                }
            }
            if (audioTrack == null && videoTrack == null) {
                throw new ResourceUnavailableException("No audio or video track found");
            }
            this.tracks = audioTrack != null && videoTrack != null ? new PullSourceStreamTrack[]{videoTrack, audioTrack} : (audioTrack != null ? new PullSourceStreamTrack[]{audioTrack} : new PullSourceStreamTrack[]{videoTrack});
            this.packetQueues = new Queue[this.formatCtx.nb_streams];
            for (n = 0; n < this.packetQueues.length; ++n) {
                this.packetQueues[n] = new Queue();
            }
        }
        super.open();
    }

    protected void queryInputContentDescriptors() {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        hashMap.put("4xm", FOURXM_MIMETYPE);
        hashMap.put(FIRST_FFMPEG_DEMUX_NAME, AAC_MIMETYPE);
        hashMap.put("alaw", ALAW_MIMETYPE);
        hashMap.put("apc", APC_MIMETYPE);
        hashMap.put("asf", ASF_MIMETYPES);
        hashMap.put("avs", AVS_MIMETYPE);
        hashMap.put("bethsoftvid", BETHSOFTVID_MIMETYPE);
        hashMap.put("c93", C93_MIMETYPE);
        hashMap.put("daud", NOT_SUPPORTED_FORMAT);
        hashMap.put("dsicin", DSICIN_MIMETYPE);
        hashMap.put("dts", DTS_MIMETYPE);
        hashMap.put("dv", DV_MIMETYPE);
        hashMap.put("dxa", DXA_MIMETYPE);
        hashMap.put("ea", EA_MIMETYPE);
        hashMap.put("ffm", NOT_SUPPORTED_FORMAT);
        hashMap.put("film_cpk", CPK_MIMETYPE);
        hashMap.put("flic", FLIC_MIMETYPES);
        hashMap.put("gxf", GXF_MIMETYPE);
        hashMap.put("h264", H264_MIMETYPE);
        hashMap.put("idcin", IDCIN_MIMETYPE);
        hashMap.put("image2", NOT_SUPPORTED_FORMAT);
        hashMap.put("image2pipe", NOT_SUPPORTED_FORMAT);
        hashMap.put("ingenient", INGENIENT_MIMETYPE);
        hashMap.put("ipmovie", MVE_MIMETYPE);
        hashMap.put("m4v", M4V_MIMETYPE);
        hashMap.put("matroska", MATROSKA_MIMETYPES);
        hashMap.put("mjpeg", MJPEG_MIMETYPE);
        hashMap.put("mm", MM_MIMETYPE);
        hashMap.put("mov,mp4,m4a,3gp,3g2,mj2", MOV_MP4_M4A_3GP_3G2_MJ2_MIMETYPES);
        hashMap.put("mpc", MUSEPACK_MIMETYPE);
        hashMap.put("mpegvideo", MPEG1VIDEO_MIMETYPE);
        hashMap.put("mpeg", MPEG2VIDEO_MIMETYPES);
        hashMap.put("mpegtsraw", MPEGTSRAW_MIMETYPE);
        hashMap.put("MTV", MTV_MIMETYPE);
        hashMap.put("mulaw", MULAW_MIMETYPE);
        hashMap.put("mxf", MXF_MIMETYPE);
        hashMap.put("nsv", NSV_MIMETYPE);
        hashMap.put("nuv", NUV_MIMETYPE);
        hashMap.put("ogg", OGG_MIMETYPE);
        hashMap.put("psxstr", PSXSTR_MIMETYPE);
        hashMap.put("rawvideo", RAWVIDEO_MIMETYPE);
        hashMap.put("RoQ", ROQ_MIMETYPE);
        hashMap.put("redir", NOT_SUPPORTED_FORMAT);
        hashMap.put("rtsp", NOT_SUPPORTED_FORMAT);
        hashMap.put("s16be", NOT_SUPPORTED_FORMAT);
        hashMap.put("s16le", NOT_SUPPORTED_FORMAT);
        hashMap.put("s8", NOT_SUPPORTED_FORMAT);
        hashMap.put("sdp", NOT_SUPPORTED_FORMAT);
        hashMap.put("shn", SHN_MIMETYPE);
        hashMap.put("smk", SMK_MIMETYPE);
        hashMap.put("sol", SOL_MIMETYPE);
        hashMap.put("thp", THP_MIMETYPE);
        hashMap.put("tiertexseq", SEQ_MIMETYPE);
        hashMap.put("tta", TTA_MIMETYPE);
        hashMap.put("txd", TXD_MIMETYPE);
        hashMap.put("u16be", NOT_SUPPORTED_FORMAT);
        hashMap.put("u16le", NOT_SUPPORTED_FORMAT);
        hashMap.put("u8", NOT_SUPPORTED_FORMAT);
        hashMap.put("vc1", VC1_MIMETYPE);
        hashMap.put("vmd", VMD_MIMETYPE);
        hashMap.put("wc3movie", WC3MOVIE_MIMETYPE);
        hashMap.put("wsaud", WSAUD_MIMETYPE);
        hashMap.put("wsvqa", WSVQA_MIMETYPE);
        hashMap.put("wv", WAVPACK_MIMETYPE);
        hashMap.put("yuv4mpegpipe", NOT_SUPPORTED_FORMAT);
        HashMap<String, ContentDescriptor> hashMap2 = new HashMap<String, ContentDescriptor>();
        int n = 1;
        AVFormatLibrary.AVInputFormat aVInputFormat = this.AVFORMAT.av_find_input_format(FIRST_FFMPEG_DEMUX_NAME);
        while (aVInputFormat != null) {
            String[] stringArray;
            String string = null;
            AVFormatLibrary.AVOutputFormat aVOutputFormat = this.AVFORMAT.guess_format(aVInputFormat.name, null, null);
            if (aVOutputFormat != null && aVOutputFormat.mime_type != null && aVOutputFormat.mime_type.length() > 0) {
                string = aVOutputFormat.mime_type;
                hashMap2.put(string, new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName(string)));
                logger.log(Level.FINEST, n + ". " + aVInputFormat.long_name + " : " + string);
            }
            if ((stringArray = (String[])hashMap.get(aVInputFormat.name)) != null) {
                if (stringArray == NOT_SUPPORTED_FORMAT) {
                    logger.log(Level.FINE, "Ignoring input format: " + aVInputFormat.name + " (" + aVInputFormat.long_name + ")");
                } else {
                    for (int i = 0; i < stringArray.length; ++i) {
                        string = stringArray[i];
                        hashMap2.put(string, new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName(string)));
                        logger.log(Level.FINEST, n + ". " + aVInputFormat.long_name + " : " + stringArray[i]);
                    }
                }
            }
            if (string == null && stringArray == null) {
                string = "ffmpeg/" + aVInputFormat.name;
                hashMap2.put(string, new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName(string)));
            }
            ++n;
            if (aVInputFormat.next != null) {
                aVInputFormat = new AVFormatLibrary.AVInputFormat(aVInputFormat.next);
                continue;
            }
            aVInputFormat = null;
        }
        this.supportedInputContentDescriptors = hashMap2.values().toArray(new ContentDescriptor[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time setPosition(Time time, int n) {
        Object object = AV_SYNC_OBJ;
        synchronized (object) {
            int n2 = this.AVFORMAT.av_seek_frame(this.formatCtx, -1, time.getNanoseconds() / 1000L, 0);
            if (n2 < 0) {
                logger.severe("av_seek_frame failed with code " + n2);
            }
            return time;
        }
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (!(dataSource instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)dataSource;
    }

    public void start() throws IOException {
    }

    private class VideoTrack
    extends PullSourceStreamTrack {
        private final int videoStreamIndex;
        private AVFormatLibrary.AVStream stream;
        private AVCodecLibrary.AVCodecContext codecCtx;
        private AVCodecLibrary.AVCodec codec;
        private AVCodecLibrary.AVFrame srcFrame;
        private AVCodecLibrary.AVFrame dstFrame;
        private VideoFormat format;
        private Pointer buffer;
        private int dstPixFmt;
        private long frameNo;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VideoTrack(int n, AVFormatLibrary.AVStream aVStream, AVCodecLibrary.AVCodecContext aVCodecContext) throws ResourceUnavailableException {
            this.videoStreamIndex = n;
            this.stream = aVStream;
            this.codecCtx = aVCodecContext;
            Object object = AV_SYNC_OBJ;
            synchronized (object) {
                this.codec = FFMPEGParser.this.AVCODEC.avcodec_find_decoder(aVCodecContext.codec_id);
                if (this.codec == null) {
                    throw new ResourceUnavailableException("Codec not found for codec_id " + aVCodecContext.codec_id + " (0x" + Integer.toHexString(aVCodecContext.codec_id) + ")");
                }
                if (FFMPEGParser.this.AVCODEC.avcodec_open(aVCodecContext, this.codec) < 0) {
                    throw new ResourceUnavailableException("Could not open codec");
                }
                this.srcFrame = FFMPEGParser.this.AVCODEC.avcodec_alloc_frame();
                if (this.srcFrame == null) {
                    throw new ResourceUnavailableException("Could not allocate frame");
                }
                this.dstFrame = FFMPEGParser.this.AVCODEC.avcodec_alloc_frame();
                if (this.dstFrame == null) {
                    throw new ResourceUnavailableException("Could not allocate frame");
                }
                float f = (float)FFMPEGParser.getFPS(aVStream, aVCodecContext);
                this.dstPixFmt = ListFormats.getPreferedPixelFormat();
                this.format = ListFormats.convertCodecPixelFormat(this.dstPixFmt, aVCodecContext.width, aVCodecContext.height, f);
                if (this.format == null) {
                    this.dstPixFmt = 6;
                    this.format = ListFormats.convertCodecPixelFormat(this.dstPixFmt, aVCodecContext.width, aVCodecContext.height, f);
                }
                int n2 = FFMPEGParser.this.AVCODEC.avpicture_get_size(this.dstPixFmt, aVCodecContext.width, aVCodecContext.height);
                this.buffer = FFMPEGParser.this.AVUTIL.av_malloc(n2);
                FFMPEGParser.this.AVCODEC.avpicture_fill(this.dstFrame, this.buffer, this.dstPixFmt, aVCodecContext.width, aVCodecContext.height);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deallocate() {
            Object object = AV_SYNC_OBJ;
            synchronized (object) {
                if (this.codecCtx != null) {
                    FFMPEGParser.this.AVCODEC.avcodec_close(this.codecCtx);
                    this.codecCtx = null;
                }
                if (this.dstFrame != null) {
                    FFMPEGParser.this.AVUTIL.av_free(this.dstFrame.getPointer());
                    this.dstFrame = null;
                }
                if (this.srcFrame != null) {
                    FFMPEGParser.this.AVUTIL.av_free(this.srcFrame.getPointer());
                    this.srcFrame = null;
                }
                if (this.buffer != null) {
                    FFMPEGParser.this.AVUTIL.av_free(this.buffer);
                    this.buffer = null;
                }
            }
        }

        public Time getDuration() {
            if (((FFMPEGParser)FFMPEGParser.this).formatCtx.duration <= 0L) {
                return Duration.DURATION_UNKNOWN;
            }
            return new Time(((FFMPEGParser)FFMPEGParser.this).formatCtx.duration * 1000L);
        }

        public Format getFormat() {
            return this.format;
        }

        public Time mapFrameToTime(int n) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time time) {
            return Integer.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            long l = -1L;
            AVFormatLibrary.AVPacket aVPacket = FFMPEGParser.this.nextPacket(this.videoStreamIndex);
            if (aVPacket != null) {
                Object object = AV_SYNC_OBJ;
                synchronized (object) {
                    IntByReference intByReference = new IntByReference();
                    FFMPEGParser.this.AVCODEC.avcodec_decode_video(this.codecCtx, this.srcFrame, intByReference, aVPacket.data, aVPacket.size);
                    if (l == -1L || aVPacket.dts < l) {
                        l = aVPacket.dts;
                    }
                    if (intByReference.getValue() != 0) {
                        Object[] objectArray;
                        int n = FFMPEGParser.this.imageConverter.img_convert(this.dstFrame, this.dstPixFmt, this.srcFrame, this.codecCtx.pix_fmt, this.codecCtx.width, this.codecCtx.height);
                        if (n < 0) {
                            throw new RuntimeException("img_convert failed: " + n);
                        }
                        int n2 = this.codecCtx.height * this.dstFrame.linesize[0];
                        Class<?> clazz = this.format.getDataType();
                        if (Format.intArray.equals(clazz)) {
                            objectArray = this.dstFrame.data0.getIntArray(0L, n2 /= 4);
                        } else if (Format.shortArray.equals(clazz)) {
                            objectArray = this.dstFrame.data0.getShortArray(0L, n2 /= 2);
                        } else if (Format.byteArray.equals(clazz)) {
                            objectArray = this.dstFrame.data0.getByteArray(0L, n2);
                        } else {
                            throw new RuntimeException("Can't handle datatype of format:" + clazz);
                        }
                        buffer.setData(objectArray);
                        buffer.setLength(n2);
                        buffer.setOffset(0);
                        buffer.setEOM(false);
                        buffer.setDiscard(false);
                        buffer.setTimeStamp(FFMPEGParser.getTimestamp(this.srcFrame, this.stream, this.codecCtx, this.frameNo++, l));
                        l = -1L;
                    } else {
                        buffer.setLength(0);
                        buffer.setDiscard(true);
                    }
                    if (aVPacket.destruct != null) {
                        aVPacket.destruct.callback(aVPacket);
                    }
                }
            } else {
                buffer.setLength(0);
                buffer.setEOM(true);
                return;
            }
        }
    }

    private abstract class PullSourceStreamTrack
    extends AbstractTrack {
        private PullSourceStreamTrack() {
        }

        public abstract void deallocate();
    }

    private class AudioTrack
    extends PullSourceStreamTrack {
        private final int audioStreamIndex;
        private AVCodecLibrary.AVCodecContext codecCtx;
        private final AVCodecLibrary.AVCodec codec;
        private Pointer buffer;
        private int bufferSize;
        private final AudioFormat format;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AudioTrack(int n, AVFormatLibrary.AVStream aVStream, AVCodecLibrary.AVCodecContext aVCodecContext) throws ResourceUnavailableException {
            this.audioStreamIndex = n;
            this.codecCtx = aVCodecContext;
            Object object = AV_SYNC_OBJ;
            synchronized (object) {
                this.codec = FFMPEGParser.this.AVCODEC.avcodec_find_decoder(aVCodecContext.codec_id);
                if (this.codec == null) {
                    throw new ResourceUnavailableException("Codec not found for codec_id " + aVCodecContext.codec_id + " (0x" + Integer.toHexString(aVCodecContext.codec_id) + ")");
                }
                if (FFMPEGParser.this.AVCODEC.avcodec_open(aVCodecContext, this.codec) < 0) {
                    throw new ResourceUnavailableException("Could not open codec");
                }
                this.bufferSize = 192000;
                this.buffer = FFMPEGParser.this.AVUTIL.av_malloc(this.bufferSize);
                this.format = FFMPEGParser.convertCodecAudioFormat(aVCodecContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deallocate() {
            Object object = AV_SYNC_OBJ;
            synchronized (object) {
                if (this.codecCtx != null) {
                    FFMPEGParser.this.AVCODEC.avcodec_close(this.codecCtx);
                    this.codecCtx = null;
                }
                if (this.buffer != null) {
                    FFMPEGParser.this.AVUTIL.av_free(this.buffer);
                    this.buffer = null;
                }
            }
        }

        public Time getDuration() {
            if (((FFMPEGParser)FFMPEGParser.this).formatCtx.duration <= 0L) {
                return Duration.DURATION_UNKNOWN;
            }
            return new Time(((FFMPEGParser)FFMPEGParser.this).formatCtx.duration * 1000L);
        }

        public Format getFormat() {
            return this.format;
        }

        public Time mapFrameToTime(int n) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time time) {
            return Integer.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            AVFormatLibrary.AVPacket aVPacket = FFMPEGParser.this.nextPacket(this.audioStreamIndex);
            if (aVPacket != null) {
                Object object = AV_SYNC_OBJ;
                synchronized (object) {
                    IntByReference intByReference = new IntByReference();
                    intByReference.setValue(this.bufferSize);
                    FFMPEGParser.this.AVCODEC.avcodec_decode_audio2(this.codecCtx, this.buffer, intByReference, aVPacket.data, aVPacket.size);
                    if (intByReference.getValue() < 0) {
                        throw new RuntimeException("Failed to read audio frame");
                    }
                    if (intByReference.getValue() > 0) {
                        if (intByReference.getValue() > this.bufferSize) {
                            FFMPEGParser.this.AVUTIL.av_free(this.buffer);
                            this.bufferSize = intByReference.getValue();
                            this.buffer = FFMPEGParser.this.AVUTIL.av_malloc(this.bufferSize);
                        }
                        byte[] byArray = this.buffer.getByteArray(0L, intByReference.getValue());
                        buffer.setData(byArray);
                        buffer.setLength(byArray.length);
                        buffer.setOffset(0);
                        buffer.setEOM(false);
                        buffer.setDiscard(false);
                        buffer.setTimeStamp(System.currentTimeMillis());
                    } else {
                        buffer.setLength(0);
                        buffer.setDiscard(true);
                    }
                    if (aVPacket.destruct != null) {
                        aVPacket.destruct.callback(aVPacket);
                    }
                }
            } else {
                buffer.setLength(0);
                buffer.setEOM(true);
                return;
            }
        }
    }
}

