/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.codegen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CGUtils {
    private static final int MAX_BYTE_PLUS1 = 256;
    private static final int RADIX_16 = 16;

    public static String byteArrayToHexString(byte[] byArray) {
        return CGUtils.byteArrayToHexString(byArray, byArray.length);
    }

    public static String byteArrayToHexString(byte[] byArray, int n) {
        return CGUtils.byteArrayToHexString(byArray, n, 0);
    }

    public static String byteArrayToHexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            String string = Integer.toHexString(CGUtils.uByteToInt(byArray[n2 + i]));
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String dump(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 32;
        while (n < n2) {
            int n4;
            int n5 = 0;
            if (n + n3 > n2) {
                n3 = n2 - n;
                n5 = 32 - n3;
            }
            stringBuffer.append(CGUtils.byteArrayToHexString(byArray, n3, n));
            for (n4 = 0; n4 < n5; ++n4) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(" | ");
            for (n4 = 0; n4 < n3; ++n4) {
                byte by = byArray[n + n4];
                if (by >= 32 && by <= 126) {
                    stringBuffer.append((char)by);
                    continue;
                }
                stringBuffer.append('.');
            }
            stringBuffer.append('\n');
            n += n3;
        }
        return stringBuffer.toString();
    }

    public static byte hexStringToByte(String string) {
        return (byte)Integer.parseInt(string, 16);
    }

    public static byte[] hexStringToByteArray(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = CGUtils.hexStringToByte(string.substring(i * 2, i * 2 + 2));
        }
        return byArray;
    }

    public static String replaceSpecialJavaStringChars(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append("\\\"");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("\\'");
                continue;
            }
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            if (c == '\r') {
                stringBuffer.append("\\r");
                continue;
            }
            if (c == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            if (c == '\t') {
                stringBuffer.append("\\t");
                continue;
            }
            if (c == '\f') {
                stringBuffer.append("\\f");
                continue;
            }
            if (c == '\b') {
                stringBuffer.append("\\b");
                continue;
            }
            if (c == '\u0000') {
                stringBuffer.append("\\000");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String toHexLiteral(int n) {
        return "0x" + Integer.toHexString(n);
    }

    public static String toLiteral(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("new byte[] {");
        for (int i = 0; i < byArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("(byte)" + byArray[i]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String toLiteral(double d) {
        return "" + d;
    }

    public static String toLiteral(float f) {
        return "" + f + "f";
    }

    public static String toLiteral(int n) {
        return "" + n;
    }

    public static String toLiteral(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("new int[] {");
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append("" + n);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String toLiteral(long l) {
        return "" + l + "L";
    }

    public static String toLiteral(String string) {
        if (string == null) {
            return "null";
        }
        return "\"" + CGUtils.replaceSpecialJavaStringChars(string) + "\"";
    }

    static String toName(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return "int";
        }
        if (clazz == Boolean.TYPE) {
            return "boolean";
        }
        if (clazz == Short.TYPE) {
            return "short";
        }
        if (clazz == Byte.TYPE) {
            return "byte";
        }
        if (clazz == Character.TYPE) {
            return "char";
        }
        if (clazz == Float.TYPE) {
            return "float";
        }
        if (clazz == Double.TYPE) {
            return "double";
        }
        if (clazz == Long.TYPE) {
            return "long";
        }
        if (clazz == byte[].class) {
            return "byte[]";
        }
        if (clazz == int[].class) {
            return "int[]";
        }
        if (clazz == short[].class) {
            return "short[]";
        }
        if (clazz == double[].class) {
            return "double[]";
        }
        if (clazz == float[].class) {
            return "float[]";
        }
        if (clazz == long[].class) {
            return "long[]";
        }
        if (clazz == boolean[].class) {
            return "boolean[]";
        }
        if (clazz == char[].class) {
            return "char[]";
        }
        if (clazz.isArray()) {
            return "" + CGUtils.toName(clazz.getComponentType()) + "[]";
        }
        return "" + clazz.getName() + "";
    }

    public static String toNameDotClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return CGUtils.toName(clazz) + ".class";
    }

    public static int uByteToInt(byte by) {
        if (by >= 0) {
            return by;
        }
        return 256 + by;
    }
}

