/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.media.codec.audio.speex;

import com.ibm.media.codec.audio.AudioCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.xiph.speex.SpeexEncoder;

public class JavaEncoder
extends AudioCodec {
    private Format lastFormat = null;
    private static int FRAME_SIZE = 320;
    private SpeexEncoder encoder = null;

    public JavaEncoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("speex/rtp")};
        this.PLUGIN_NAME = "pcm to speex converter";
    }

    public void close() {
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("speex/rtp", audioFormat.getSampleRate(), 8, audioFormat.getChannels(), audioFormat.getEndian(), audioFormat.getSigned())};
        return this.supportedOutputFormats;
    }

    private void initConverter(AudioFormat audioFormat) {
        this.lastFormat = audioFormat;
        this.encoder = new SpeexEncoder();
        this.encoder.init(0, 4, (int)audioFormat.getSampleRate(), 1);
    }

    public void open() throws ResourceUnavailableException {
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        Format format = buffer.getFormat();
        if (this.lastFormat != format) {
            this.initConverter((AudioFormat)format);
        }
        int n = buffer.getLength();
        byte[] byArray = (byte[])buffer.getData();
        int n2 = buffer.getOffset();
        if (n == 0) {
            return 4;
        }
        if (n - n2 >= FRAME_SIZE) {
            this.encoder.processData(byArray, n2, FRAME_SIZE);
            byte[] byArray2 = new byte[this.encoder.getProcessedDataByteSize()];
            this.encoder.getProcessedData(byArray2, 0);
            byte[] byArray3 = this.validateByteArraySize(buffer2, byArray2.length);
            System.arraycopy(byArray2, 0, byArray3, buffer2.getOffset(), byArray2.length);
            this.updateOutput(buffer2, this.outputFormat, byArray3.length, 0);
            if (n - n2 > FRAME_SIZE) {
                buffer.setOffset(n2 + FRAME_SIZE);
                return 2;
            }
            return 0;
        }
        return 4;
    }
}

