/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.codegen.FormatTraceUtils;
import net.sf.fmj.utility.FormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedColorFormat
extends VideoFormat {
    protected int lineStride;
    protected byte[] redValues;
    protected byte[] greenValues;
    protected byte[] blueValues;
    protected int mapSize;
    private static String ENCODING = "irgb";

    public IndexedColorFormat(Dimension dimension, int n, Class<?> clazz, float f, int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(ENCODING, dimension, n, clazz, f);
        this.lineStride = n2;
        this.mapSize = n3;
        this.redValues = byArray;
        this.greenValues = byArray2;
        this.blueValues = byArray3;
    }

    @Override
    public Object clone() {
        return new IndexedColorFormat(FormatUtils.clone(this.size), this.maxDataLength, this.dataType, this.frameRate, this.lineStride, this.mapSize, this.redValues, this.greenValues, this.blueValues);
    }

    @Override
    protected void copy(Format format) {
        super.copy(format);
        IndexedColorFormat indexedColorFormat = (IndexedColorFormat)format;
        this.lineStride = indexedColorFormat.lineStride;
        this.mapSize = indexedColorFormat.mapSize;
        this.redValues = indexedColorFormat.redValues;
        this.greenValues = indexedColorFormat.greenValues;
        this.blueValues = indexedColorFormat.blueValues;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof IndexedColorFormat)) {
            return false;
        }
        IndexedColorFormat indexedColorFormat = (IndexedColorFormat)object;
        return this.lineStride == indexedColorFormat.lineStride && this.mapSize == indexedColorFormat.mapSize && this.redValues == indexedColorFormat.redValues && this.greenValues == indexedColorFormat.greenValues && this.blueValues == indexedColorFormat.blueValues;
    }

    public byte[] getBlueValues() {
        return this.blueValues;
    }

    public byte[] getGreenValues() {
        return this.greenValues;
    }

    public int getLineStride() {
        return this.lineStride;
    }

    public int getMapSize() {
        return this.mapSize;
    }

    public byte[] getRedValues() {
        return this.redValues;
    }

    @Override
    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format instanceof IndexedColorFormat) {
            IndexedColorFormat indexedColorFormat = (IndexedColorFormat)format2;
            IndexedColorFormat indexedColorFormat2 = (IndexedColorFormat)format;
            if (this.getClass().isAssignableFrom(format.getClass())) {
                if (FormatUtils.specified(this.lineStride)) {
                    indexedColorFormat.lineStride = this.lineStride;
                }
                if (FormatUtils.specified(this.mapSize)) {
                    indexedColorFormat.mapSize = this.mapSize;
                }
                if (FormatUtils.specified(this.redValues)) {
                    indexedColorFormat.redValues = this.redValues;
                }
                if (FormatUtils.specified(this.greenValues)) {
                    indexedColorFormat.greenValues = this.greenValues;
                }
                if (FormatUtils.specified(this.blueValues)) {
                    indexedColorFormat.blueValues = this.blueValues;
                }
            } else if (format.getClass().isAssignableFrom(this.getClass())) {
                if (!FormatUtils.specified(indexedColorFormat.lineStride)) {
                    indexedColorFormat.lineStride = indexedColorFormat2.lineStride;
                }
                if (!FormatUtils.specified(indexedColorFormat.mapSize)) {
                    indexedColorFormat.mapSize = indexedColorFormat2.mapSize;
                }
                if (!FormatUtils.specified(indexedColorFormat.redValues)) {
                    indexedColorFormat.redValues = indexedColorFormat2.redValues;
                }
                if (!FormatUtils.specified(indexedColorFormat.greenValues)) {
                    indexedColorFormat.greenValues = indexedColorFormat2.greenValues;
                }
                if (!FormatUtils.specified(indexedColorFormat.blueValues)) {
                    indexedColorFormat.blueValues = indexedColorFormat2.blueValues;
                }
            }
        }
        FormatTraceUtils.traceIntersects(this, format, format2);
        return format2;
    }

    @Override
    public boolean matches(Format format) {
        if (!super.matches(format)) {
            FormatTraceUtils.traceMatches(this, format, false);
            return false;
        }
        if (!(format instanceof IndexedColorFormat)) {
            FormatTraceUtils.traceMatches(this, format, true);
            return true;
        }
        IndexedColorFormat indexedColorFormat = (IndexedColorFormat)format;
        boolean bl = FormatUtils.matches(indexedColorFormat.lineStride, this.lineStride) && FormatUtils.matches(indexedColorFormat.mapSize, this.mapSize) && FormatUtils.matches(indexedColorFormat.redValues, this.redValues) && FormatUtils.matches(indexedColorFormat.greenValues, this.greenValues) && FormatUtils.matches(indexedColorFormat.blueValues, this.blueValues);
        FormatTraceUtils.traceMatches(this, format, bl);
        return bl;
    }

    @Override
    public Format relax() {
        IndexedColorFormat indexedColorFormat = (IndexedColorFormat)super.relax();
        indexedColorFormat.lineStride = -1;
        return indexedColorFormat;
    }
}

