/*
 * Decompiled with CFR 0.152.
 */
package com.t4l.jmf;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.media.format.RGBFormat;

public class RGBConverter {
    public static void flipVertical(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        for (int i = 0; i < n2 / 2; ++i) {
            int n3 = n2 - 1 - i;
            int n4 = i * n;
            int n5 = n3 * n;
            System.arraycopy(nArray, n4, nArray2, 0, n);
            System.arraycopy(nArray, n5, nArray3, 0, n);
            System.arraycopy(nArray2, 0, nArray, n5, n);
            System.arraycopy(nArray3, 0, nArray, n4, n);
        }
    }

    private static int getShift(int n) {
        int n2 = n;
        int n3 = 0;
        while (n2 != 255) {
            if (n2 < 255) {
                throw new IllegalArgumentException("Unsupported mask: " + Integer.toString(n, 16));
            }
            ++n3;
            n2 /= 2;
        }
        return n3;
    }

    public static void populateArray(BufferedImage bufferedImage, int[] nArray, RGBFormat rGBFormat) {
        int n = bufferedImage.getType();
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (rGBFormat == null) {
            throw new NullPointerException();
        }
        int n4 = rGBFormat.getLineStride();
        if (nArray.length < n4 * n3) {
            throw new IllegalArgumentException("Illegal array size: " + nArray.length + "<" + n4 * n3);
        }
        if (n == 2 || n == 3 || n == 1) {
            bufferedImage.getRaster().getDataElements(0, 0, n2, n3, nArray);
        } else {
            bufferedImage.getRGB(0, 0, n2, n3, nArray, 0, n2);
        }
        int n5 = rGBFormat.getRedMask();
        int n6 = rGBFormat.getGreenMask();
        int n7 = rGBFormat.getBlueMask();
        if (n5 != 0xFF0000 || n6 != 65280 || n7 != 255 || rGBFormat.getLineStride() != n2 || rGBFormat.getPixelStride() != 1) {
            int n8 = RGBConverter.getShift(n5);
            int n9 = RGBConverter.getShift(n6);
            int n10 = RGBConverter.getShift(n7);
            int n11 = rGBFormat.getPixelStride();
            for (int i = n3 - 1; i >= 0; --i) {
                for (int j = n2 - 1; j >= 0; --j) {
                    int n12 = i * n2 + j;
                    int n13 = nArray[n12] >> 16 & 0xFF;
                    int n14 = nArray[n12] >> 8 & 0xFF;
                    int n15 = nArray[n12] >> 0 & 0xFF;
                    n12 = i * n4 + j * n11;
                    nArray[n12] = (n13 << n8) + (n14 << n9) + (n15 << n10);
                }
            }
        }
        if (rGBFormat.getFlipped() == 1) {
            RGBConverter.flipVertical(nArray, n2, n3);
        }
    }

    public static void populateImage(int[] nArray, int n, BufferedImage bufferedImage, RGBFormat rGBFormat) {
        int n2 = bufferedImage.getType();
        int n3 = n2 == 2 || n2 == 3 ? 2 : 1;
        RGBConverter.processData(nArray, n, rGBFormat, n3);
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        if (n2 == 2 || n2 == 1) {
            bufferedImage.getRaster().setDataElements(0, 0, n4, n5, nArray);
        } else {
            bufferedImage.setRGB(0, 0, n4, n5, nArray, 0, n4);
        }
    }

    private static void processData(int[] nArray, int n, RGBFormat rGBFormat, int n2) {
        Dimension dimension = rGBFormat.getSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = rGBFormat.getRedMask();
        int n6 = rGBFormat.getGreenMask();
        int n7 = rGBFormat.getBlueMask();
        int n8 = RGBConverter.getShift(n5);
        int n9 = RGBConverter.getShift(n6);
        int n10 = RGBConverter.getShift(n7);
        int n11 = rGBFormat.getLineStride() - n3;
        if (n == 0 && rGBFormat.getPixelStride() == 1 && n11 == 0 && n5 == 0xFF0000 && n6 == 65280 && n7 == 255) {
            if (n2 == 1) {
                return;
            }
            int n12 = n3 * n4;
            for (int i = 0; i < n12; ++i) {
                nArray[i] = (nArray[i] & 0xFFFFFF) + -16777216;
            }
            return;
        }
        int n13 = 0;
        if (n2 == 2) {
            for (int i = 0; i < n4; ++i) {
                int n14 = i * n3;
                for (int j = 0; j < n3; ++j) {
                    int n15 = nArray[n13 + n];
                    int n16 = n15 >> n8 & 0xFF;
                    int n17 = n15 >> n9 & 0xFF;
                    int n18 = n15 >> n10 & 0xFF;
                    nArray[n14 + j] = n15 = -16777216 + (n16 << 16) + (n17 << 8) + n18;
                    ++n13;
                }
                n13 += n11;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                int n19 = i * n3;
                for (int j = 0; j < n3; ++j) {
                    int n20 = nArray[n13 + n];
                    int n21 = n20 >> n8 & 0xFF;
                    int n22 = n20 >> n9 & 0xFF;
                    int n23 = n20 >> n10 & 0xFF;
                    nArray[n19 + j] = n20 = (n21 << 16) + (n22 << 8) + n23;
                    ++n13;
                }
                n13 += n11;
            }
        }
        if (rGBFormat.getFlipped() == 1) {
            RGBConverter.flipVertical(nArray, n3, n4);
        }
    }
}

