/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.dns;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.java.sip.communicator.impl.dns.DnsUtilActivator;
import net.java.sip.communicator.service.dns.CustomResolver;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Message;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.Type;

public class ParallelResolverImpl
implements CustomResolver,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(ParallelResolverImpl.class);
    private static volatile boolean redundantMode = false;
    private static long currentDnsPatience = 1500L;
    public static int currentDnsRedemption = 3;
    private static int redemptionStatus = 0;
    private static final Object redemptionLock = new Object();
    private Resolver defaultResolver;
    private ExtendedResolver backupResolver;
    private ExecutorService backupQueriesPool;
    private final Set<String> configNames = new HashSet<String>(5){
        {
            this.add("net.java.sip.communicator.util.dns.BACKUP_RESOLVER_ENABLED");
            this.add("net.java.sip.communicator.util.dns.BACKUP_RESOLVER");
            this.add("net.java.sip.communicator.util.dns.BACKUP_RESOLVER_FALLBACK_IP");
            this.add("net.java.sip.communicator.util.dns.BACKUP_RESOLVER_PORT");
            this.add("net.java.sip.communicator.util.dns.DNS_PATIENCE");
            this.add("net.java.sip.communicator.util.dns.DNS_REDEMPTION");
        }
    };

    ParallelResolverImpl() {
        this.backupQueriesPool = Executors.newCachedThreadPool();
        DnsUtilActivator.getConfigurationService().addPropertyChangeListener((PropertyChangeListener)this);
        this.initProperties();
        this.reset();
    }

    private void initProperties() {
        String rslvrAddrStr = DnsUtilActivator.getConfigurationService().getString("net.java.sip.communicator.util.dns.BACKUP_RESOLVER", "backup-resolver.jitsi.net");
        String customResolverIP = DnsUtilActivator.getConfigurationService().getString("net.java.sip.communicator.util.dns.BACKUP_RESOLVER_FALLBACK_IP", DnsUtilActivator.getResources().getSettingsString("net.java.sip.communicator.util.dns.BACKUP_RESOLVER_FALLBACK_IP"));
        InetAddress resolverAddress = null;
        try {
            resolverAddress = NetworkUtils.getInetAddress((String)rslvrAddrStr);
        }
        catch (UnknownHostException exc) {
            logger.warn((Object)("Seems like the primary DNS is down, trying fallback to " + customResolverIP));
        }
        if (resolverAddress == null) {
            try {
                resolverAddress = NetworkUtils.getInetAddress((String)customResolverIP);
            }
            catch (UnknownHostException e) {
                logger.error((Object)e);
            }
        }
        int resolverPort = DnsUtilActivator.getConfigurationService().getInt("net.java.sip.communicator.util.dns.BACKUP_RESOLVER_PORT", 53);
        InetSocketAddress resolverSockAddr = new InetSocketAddress(resolverAddress, resolverPort);
        this.setBackupServers(new InetSocketAddress[]{resolverSockAddr});
        currentDnsPatience = DnsUtilActivator.getConfigurationService().getLong("net.java.sip.communicator.util.dns.DNS_PATIENCE", 1500L);
        currentDnsRedemption = DnsUtilActivator.getConfigurationService().getInt("net.java.sip.communicator.util.dns.DNS_REDEMPTION", 3);
    }

    private void setBackupServers(InetSocketAddress[] backupServers) {
        try {
            this.backupResolver = new ExtendedResolver((Resolver[])new SimpleResolver[0]);
            for (InetSocketAddress backupServer : backupServers) {
                SimpleResolver sr = new SimpleResolver();
                sr.setAddress(backupServer);
                this.backupResolver.addResolver((Resolver)sr);
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("The impossible just happened: we could not initialize our backup DNS resolver");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message send(Message query) throws IOException {
        Object object;
        ParallelResolution resolution = new ParallelResolution(query);
        resolution.sendFirstQuery();
        if (!redundantMode) {
            if (resolution.waitForResponse(currentDnsPatience)) {
                return resolution.returnResponseOrThrowUp();
            }
            object = redemptionLock;
            synchronized (object) {
                redundantMode = true;
                redemptionStatus = currentDnsRedemption;
                logger.info((Object)("Primary DNS seems laggy: no response for " + query.getQuestion().getName() + "/" + Type.string((int)query.getQuestion().getType()) + " after " + currentDnsPatience + "ms. " + "Enabling redundant mode."));
            }
        }
        resolution.sendBackupQueries();
        resolution.waitForResponse(0L);
        object = redemptionLock;
        synchronized (object) {
            if (!resolution.primaryResolverRespondedFirst) {
                redemptionStatus = currentDnsRedemption;
            } else if (--redemptionStatus <= 0) {
                redundantMode = false;
                logger.info((Object)"Primary DNS seems back in biz. Disabling redundant mode.");
            }
        }
        return resolution.returnResponseOrThrowUp();
    }

    public Object sendAsync(Message query, ResolverListener listener) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setPort(int port) {
        this.defaultResolver.setPort(port);
    }

    public void setTCP(boolean flag) {
        this.defaultResolver.setTCP(flag);
    }

    public void setIgnoreTruncation(boolean flag) {
        this.defaultResolver.setIgnoreTruncation(flag);
    }

    public void setEDNS(int level) {
        this.defaultResolver.setEDNS(level);
    }

    public void setEDNS(int level, int payloadSize, int flags, List options) {
        this.defaultResolver.setEDNS(level, payloadSize, flags, options);
    }

    public void setTSIGKey(TSIG key) {
        this.defaultResolver.setTSIGKey(key);
    }

    public void setTimeout(int secs, int msecs) {
        this.defaultResolver.setTimeout(secs, msecs);
    }

    public void setTimeout(int secs) {
        this.defaultResolver.setTimeout(secs);
    }

    public final void reset() {
        Lookup.refreshDefault();
        try {
            Lookup.setDefaultResolver((Resolver)this);
            ExtendedResolver temp = new ExtendedResolver();
            temp.setTimeout(10);
            this.defaultResolver = temp;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to initialize resolver");
        }
    }

    private boolean isResponseSatisfactory(Message response) {
        int questionType;
        if (response == null) {
            return false;
        }
        Record[] answerRR = response.getSectionArray(1);
        Record[] authorityRR = response.getSectionArray(2);
        Record[] additionalRR = response.getSectionArray(3);
        if (answerRR != null && answerRR.length > 0 || authorityRR != null && authorityRR.length > 0 || additionalRR != null && additionalRR.length > 0) {
            return true;
        }
        int rcode = response.getRcode();
        if (rcode == 3) {
            return false;
        }
        Record question = response.getQuestion();
        int n = questionType = question == null ? 0 : question.getType();
        return rcode == 0 && question != null && (questionType == 28 || questionType == 35);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.configNames.contains(evt.getPropertyName())) {
            return;
        }
        this.initProperties();
    }

    private class ParallelResolution
    implements Runnable {
        private final Message query;
        private volatile Message response;
        private Throwable exception;
        private volatile boolean done = false;
        private volatile boolean primaryResolverRespondedFirst = true;

        public ParallelResolution(Message query) {
            this.query = query;
        }

        public void sendFirstQuery() {
            ParallelResolverImpl.this.backupQueriesPool.execute(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Message localResponse = null;
            try {
                localResponse = ParallelResolverImpl.this.defaultResolver.send(this.query);
            }
            catch (SocketTimeoutException exc) {
                logger.info((Object)"Default DNS resolver timed out.");
                this.exception = exc;
            }
            catch (Throwable exc) {
                logger.info((Object)"Default DNS resolver failed", exc);
                this.exception = exc;
            }
            if (this.done) {
                return;
            }
            ParallelResolution parallelResolution = this;
            synchronized (parallelResolution) {
                if (localResponse != null && ParallelResolverImpl.this.isResponseSatisfactory(localResponse)) {
                    this.response = localResponse;
                    this.done = true;
                }
                this.notify();
            }
        }

        public void sendBackupQueries() {
            ParallelResolverImpl.this.backupQueriesPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (ParallelResolution.this.done) {
                        return;
                    }
                    Message localResponse = null;
                    try {
                        logger.info((Object)("Sending query for " + ParallelResolution.this.query.getQuestion().getName() + "/" + Type.string((int)ParallelResolution.this.query.getQuestion().getType()) + " to backup resolvers"));
                        localResponse = ParallelResolverImpl.this.backupResolver.send(ParallelResolution.this.query);
                    }
                    catch (Throwable exc) {
                        logger.info((Object)("Exception occurred during backup DNS resolving" + exc));
                        ParallelResolution.this.exception = exc;
                    }
                    if (ParallelResolution.this.done) {
                        return;
                    }
                    ParallelResolution parallelResolution = ParallelResolution.this;
                    synchronized (parallelResolution) {
                        if (ParallelResolution.this.response == null) {
                            ParallelResolution.this.response = localResponse;
                            ParallelResolution.this.primaryResolverRespondedFirst = false;
                        }
                        ParallelResolution.this.done = true;
                        ParallelResolution.this.notify();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForResponse(long waitFor) {
            ParallelResolution parallelResolution = this;
            synchronized (parallelResolution) {
                if (this.done) {
                    return this.done;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                return this.done;
            }
        }

        public Message returnResponseOrThrowUp() throws IOException, RuntimeException, IllegalArgumentException {
            if (!this.done) {
                this.waitForResponse(0L);
            }
            if (this.response != null) {
                return this.response;
            }
            if (this.exception instanceof SocketTimeoutException) {
                logger.warn((Object)"DNS resolver timed out");
                throw (IOException)this.exception;
            }
            if (this.exception instanceof IOException) {
                logger.warn((Object)"IO exception while using DNS resolver", this.exception);
                throw (IOException)this.exception;
            }
            if (this.exception instanceof RuntimeException) {
                logger.warn((Object)"RunTimeException while using DNS resolver", this.exception);
                throw (RuntimeException)this.exception;
            }
            if (this.exception instanceof Error) {
                logger.warn((Object)"Error while using DNS resolver", this.exception);
                throw (Error)this.exception;
            }
            logger.warn((Object)"Received a bad response from primary DNS resolver", this.exception);
            throw new IllegalStateException("ExtendedResolver failure");
        }
    }
}

