/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.util.HashMap;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusInterfaceName;
import org.freedesktop.dbus.DBusMemberName;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBusMatchRule {
    private String type;
    private String iface;
    private String member;
    private String object;
    private String source;
    private static HashMap<String, Class<? extends DBusSignal>> signalTypeMap = new HashMap();

    static Class<? extends DBusSignal> getCachedSignalType(String string) {
        return signalTypeMap.get(string);
    }

    public DBusMatchRule(String string, String string2, String string3) {
        this.type = string;
        this.iface = string2;
        this.member = string3;
    }

    public DBusMatchRule(DBusExecutionException dBusExecutionException) throws DBusException {
        this(dBusExecutionException.getClass());
        this.member = null;
        this.type = "error";
    }

    public DBusMatchRule(Message message) {
        this.iface = message.getInterface();
        this.member = message.getName();
        if (message instanceof DBusSignal) {
            this.type = "signal";
        } else if (message instanceof Error) {
            this.type = "error";
            this.member = null;
        } else if (message instanceof MethodCall) {
            this.type = "method_call";
        } else if (message instanceof MethodReturn) {
            this.type = "method_reply";
        }
    }

    public DBusMatchRule(Class<? extends DBusInterface> clazz, String string) throws DBusException {
        this(clazz);
        this.member = string;
        this.type = "method_call";
    }

    public DBusMatchRule(Class<? extends Object> clazz, String string, String string2) throws DBusException {
        this(clazz);
        this.source = string;
        this.object = string2;
    }

    public DBusMatchRule(Class<? extends Object> clazz) throws DBusException {
        if (DBusInterface.class.isAssignableFrom(clazz)) {
            this.iface = null != clazz.getAnnotation(DBusInterfaceName.class) ? clazz.getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.dollar_pattern.matcher(clazz.getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException(Gettext._("DBusInterfaces must be defined in a package."));
            }
            this.member = null;
            this.type = null;
        } else if (DBusSignal.class.isAssignableFrom(clazz)) {
            if (null == clazz.getEnclosingClass()) {
                throw new DBusException(Gettext._("Signals must be declared as a member of a class implementing DBusInterface which is the member of a package."));
            }
            this.iface = null != clazz.getEnclosingClass().getAnnotation(DBusInterfaceName.class) ? clazz.getEnclosingClass().getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.dollar_pattern.matcher(clazz.getEnclosingClass().getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException(Gettext._("DBusInterfaces must be defined in a package."));
            }
            this.member = clazz.isAnnotationPresent(DBusMemberName.class) ? clazz.getAnnotation(DBusMemberName.class).value() : clazz.getSimpleName();
            signalTypeMap.put(this.iface + '$' + this.member, clazz);
            this.type = "signal";
        } else if (Error.class.isAssignableFrom(clazz)) {
            this.iface = null != clazz.getAnnotation(DBusInterfaceName.class) ? clazz.getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.dollar_pattern.matcher(clazz.getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException(Gettext._("DBusInterfaces must be defined in a package."));
            }
            this.member = null;
            this.type = "error";
        } else if (DBusExecutionException.class.isAssignableFrom(clazz)) {
            this.iface = null != clazz.getClass().getAnnotation(DBusInterfaceName.class) ? clazz.getClass().getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.dollar_pattern.matcher(clazz.getClass().getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException(Gettext._("DBusInterfaces must be defined in a package."));
            }
            this.member = null;
            this.type = "error";
        } else {
            throw new DBusException(Gettext._("Invalid type for match rule: ") + clazz);
        }
    }

    public String toString() {
        String string = null;
        if (null != this.type) {
            String string2 = string = null == string ? "type='" + this.type + "'" : string + ",type='" + this.type + "'";
        }
        if (null != this.member) {
            String string3 = string = null == string ? "member='" + this.member + "'" : string + ",member='" + this.member + "'";
        }
        if (null != this.iface) {
            String string4 = string = null == string ? "interface='" + this.iface + "'" : string + ",interface='" + this.iface + "'";
        }
        if (null != this.source) {
            String string5 = string = null == string ? "sender='" + this.source + "'" : string + ",sender='" + this.source + "'";
        }
        if (null != this.object) {
            string = null == string ? "path='" + this.object + "'" : string + ",path='" + this.object + "'";
        }
        return string;
    }

    public String getType() {
        return this.type;
    }

    public String getInterface() {
        return this.iface;
    }

    public String getMember() {
        return this.member;
    }

    public String getSource() {
        return this.source;
    }

    public String getObject() {
        return this.object;
    }
}

