/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONDynaClass;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class JSONDynaBean
implements DynaBean,
Serializable {
    private static final long serialVersionUID = -3152084265262514977L;
    protected JSONDynaClass dynaClass;
    protected Map dynaValues = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public boolean contains(String name, String key) {
        Object value = this.dynaValues.get(name);
        if (value == null) {
            throw new NullPointerException("Unmapped property name: " + name + " key: " + key);
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Non-Mapped property name: " + name + " key: " + key);
        }
        return ((Map)value).containsKey(key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONDynaBean)) {
            return false;
        }
        JSONDynaBean other = (JSONDynaBean)obj;
        EqualsBuilder builder = new EqualsBuilder().append((Object)this.dynaClass, (Object)other.dynaClass);
        DynaProperty[] props = this.dynaClass.getDynaProperties();
        for (int i = 0; i < props.length; ++i) {
            DynaProperty prop = props[i];
            builder.append(this.dynaValues.get(prop.getName()), this.dynaValues.get(prop.getName()));
        }
        return builder.isEquals();
    }

    public Object get(String name) {
        Object value = this.dynaValues.get(name);
        if (value != null) {
            return value;
        }
        Class type = this.getDynaProperty(name).getType();
        if (type == null) {
            throw new NullPointerException("Unspecified property type for " + name);
        }
        if (!type.isPrimitive()) {
            return value;
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type == Byte.TYPE) {
            return new Byte(0);
        }
        if (type == Character.TYPE) {
            return new Character('\u0000');
        }
        if (type == Short.TYPE) {
            return new Short(0);
        }
        if (type == Integer.TYPE) {
            return new Integer(0);
        }
        if (type == Long.TYPE) {
            return new Long(0L);
        }
        if (type == Float.TYPE) {
            return new Float(0.0);
        }
        if (type == Double.TYPE) {
            return new Double(0.0);
        }
        return null;
    }

    public Object get(String name, int index) {
        Object value = this.dynaValues.get(name);
        if (value == null) {
            throw new NullPointerException("Unindexed property name: " + name + " index: " + index);
        }
        if (!(value instanceof List) || !value.getClass().isArray()) {
            throw new IllegalArgumentException("Non-Indexed property name: " + name + " index: " + index);
        }
        if (value.getClass().isArray()) {
            value = Array.get(value, index);
        } else if (value instanceof List) {
            value = ((List)value).get(index);
        }
        return value;
    }

    public Object get(String name, String key) {
        Object value = this.dynaValues.get(name);
        if (value == null) {
            throw new NullPointerException("Unmapped property name: " + name + " key: " + key);
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Non-Mapped property name: " + name + " key: " + key);
        }
        return ((Map)value).get(key);
    }

    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder().append((Object)this.dynaClass);
        DynaProperty[] props = this.dynaClass.getDynaProperties();
        for (int i = 0; i < props.length; ++i) {
            DynaProperty prop = props[i];
            builder.append(this.dynaValues.get(prop.getName()));
        }
        return builder.toHashCode();
    }

    public void remove(String name, String key) {
        Object value = this.dynaValues.get(name);
        if (value == null) {
            throw new NullPointerException("Unmapped property name: " + name + " key: " + key);
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Non-Mapped property name: " + name + " key: " + key);
        }
        ((Map)value).remove(key);
    }

    public void set(String name, int index, Object value) {
        Object prop = this.dynaValues.get(name);
        if (prop == null) {
            throw new NullPointerException("Unindexed property name: " + name + " index: " + index);
        }
        if (!(prop instanceof List) || !prop.getClass().isArray()) {
            throw new IllegalArgumentException("Non-Indexed property name: " + name + " index: " + index);
        }
        if (prop.getClass().isArray()) {
            Array.set(prop, index, value);
        } else if (value instanceof List) {
            ((List)prop).set(index, value);
        }
    }

    public void set(String name, Object value) {
        DynaProperty property = this.getDynaProperty(name);
        if (property.getType() == null) {
            throw new NullPointerException("Unspecified property type for " + name);
        }
        if (value == null) {
            if (property.getType().isPrimitive()) {
                throw new NullPointerException("Property type for " + name + " is primitive");
            }
        } else if (!this.isDynaAssignable(property.getType(), value.getClass())) {
            try {
                value = ConvertUtils.convert((String)String.valueOf(value), value.getClass());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unassignable property type for " + name);
            }
        }
        this.dynaValues.put(name, value);
    }

    public void set(String name, String key, Object value) {
        Object prop = this.dynaValues.get(name);
        if (prop == null) {
            throw new IllegalArgumentException("Unmapped property name: " + name + " key: " + key);
        }
        if (!(prop instanceof Map)) {
            throw new IllegalArgumentException("Non-Mapped property name: " + name + " key: " + key);
        }
        ((Map)prop).put(key, value);
    }

    public void setDynamicFormClass(JSONDynaClass dynaClass) {
        if (this.dynaClass == null) {
            this.dynaClass = dynaClass;
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append((Object)this.dynaValues).toString();
    }

    protected DynaProperty getDynaProperty(String name) {
        DynaProperty property = this.getDynaClass().getDynaProperty(name);
        if (property == null) {
            throw new IllegalArgumentException("Unspecified property for " + name);
        }
        return property;
    }

    protected boolean isDynaAssignable(Class dest, Class src) {
        boolean assignable = dest.isAssignableFrom(src);
        boolean bl = dest == Boolean.TYPE && src == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JSONDynaBean.class$("java.lang.Boolean")) : class$java$lang$Boolean) ? true : (assignable = assignable);
        boolean bl2 = dest == Byte.TYPE && src == (class$java$lang$Byte == null ? (class$java$lang$Byte = JSONDynaBean.class$("java.lang.Byte")) : class$java$lang$Byte) ? true : (assignable = assignable);
        boolean bl3 = dest == Character.TYPE && src == (class$java$lang$Character == null ? (class$java$lang$Character = JSONDynaBean.class$("java.lang.Character")) : class$java$lang$Character) ? true : (assignable = assignable);
        boolean bl4 = dest == Short.TYPE && src == (class$java$lang$Short == null ? (class$java$lang$Short = JSONDynaBean.class$("java.lang.Short")) : class$java$lang$Short) ? true : (assignable = assignable);
        boolean bl5 = dest == Integer.TYPE && src == (class$java$lang$Integer == null ? (class$java$lang$Integer = JSONDynaBean.class$("java.lang.Integer")) : class$java$lang$Integer) ? true : (assignable = assignable);
        boolean bl6 = dest == Long.TYPE && src == (class$java$lang$Long == null ? (class$java$lang$Long = JSONDynaBean.class$("java.lang.Long")) : class$java$lang$Long) ? true : (assignable = assignable);
        boolean bl7 = dest == Float.TYPE && src == (class$java$lang$Float == null ? (class$java$lang$Float = JSONDynaBean.class$("java.lang.Float")) : class$java$lang$Float) ? true : (assignable = assignable);
        boolean bl8 = dest == Double.TYPE && src == (class$java$lang$Double == null ? (class$java$lang$Double = JSONDynaBean.class$("java.lang.Double")) : class$java$lang$Double) ? true : (assignable = assignable);
        if (src == Double.TYPE || (class$java$lang$Double == null ? (class$java$lang$Double = JSONDynaBean.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(src)) {
            boolean bl9 = assignable = this.isByte(dest) || this.isShort(dest) || this.isInteger(dest) || this.isLong(dest) || this.isFloat(dest) ? true : assignable;
        }
        if (src == Float.TYPE || (class$java$lang$Float == null ? (class$java$lang$Float = JSONDynaBean.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(src)) {
            boolean bl10 = assignable = this.isByte(dest) || this.isShort(dest) || this.isInteger(dest) || this.isLong(dest) ? true : assignable;
        }
        if (src == Long.TYPE || (class$java$lang$Long == null ? (class$java$lang$Long = JSONDynaBean.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(src)) {
            boolean bl11 = assignable = this.isByte(dest) || this.isShort(dest) || this.isInteger(dest) ? true : assignable;
        }
        if (src == Integer.TYPE || (class$java$lang$Integer == null ? (class$java$lang$Integer = JSONDynaBean.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(src)) {
            boolean bl12 = assignable = this.isByte(dest) || this.isShort(dest) ? true : assignable;
        }
        if (src == Short.TYPE || (class$java$lang$Short == null ? (class$java$lang$Short = JSONDynaBean.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(src)) {
            assignable = this.isByte(dest) ? true : assignable;
        }
        return assignable;
    }

    private boolean isByte(Class clazz) {
        return (class$java$lang$Byte == null ? (class$java$lang$Byte = JSONDynaBean.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(clazz) || clazz == Byte.TYPE;
    }

    private boolean isFloat(Class clazz) {
        return (class$java$lang$Float == null ? (class$java$lang$Float = JSONDynaBean.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(clazz) || clazz == Float.TYPE;
    }

    private boolean isInteger(Class clazz) {
        return (class$java$lang$Integer == null ? (class$java$lang$Integer = JSONDynaBean.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz) || clazz == Integer.TYPE;
    }

    private boolean isLong(Class clazz) {
        return (class$java$lang$Long == null ? (class$java$lang$Long = JSONDynaBean.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(clazz) || clazz == Long.TYPE;
    }

    private boolean isShort(Class clazz) {
        return (class$java$lang$Short == null ? (class$java$lang$Short = JSONDynaBean.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(clazz) || clazz == Short.TYPE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

