/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamRequest;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class IBBTransferNegotiator
extends StreamNegotiator {
    private Connection connection;
    private InBandBytestreamManager manager;

    protected IBBTransferNegotiator(Connection connection) {
        this.connection = connection;
        this.manager = InBandBytestreamManager.getByteStreamManager(connection);
    }

    @Override
    public OutputStream createOutgoingStream(String streamID, String initiator, String target) throws XMPPException {
        InBandBytestreamSession session = this.manager.establishSession(target, streamID);
        session.setCloseBothStreamsEnabled(true);
        return session.getOutputStream();
    }

    @Override
    public InputStream createIncomingStream(StreamInitiation initiation) throws XMPPException {
        this.manager.ignoreBytestreamRequestOnce(initiation.getSessionID());
        Packet streamInitiation = this.initiateIncomingStream(this.connection, initiation);
        return this.negotiateIncomingStream(streamInitiation);
    }

    @Override
    public PacketFilter getInitiationPacketFilter(String from, String streamID) {
        this.manager.ignoreBytestreamRequestOnce(streamID);
        return new AndFilter(new PacketFilter[]{new FromContainsFilter(from), new IBBOpenSidFilter(streamID)});
    }

    @Override
    public String[] getNamespaces() {
        return new String[]{"http://jabber.org/protocol/ibb"};
    }

    @Override
    InputStream negotiateIncomingStream(Packet streamInitiation) throws XMPPException {
        ByteStreamRequest request = new ByteStreamRequest(this.manager, (Open)streamInitiation);
        InBandBytestreamSession session = request.accept();
        session.setCloseBothStreamsEnabled(true);
        return session.getInputStream();
    }

    @Override
    public void cleanup() {
    }

    private static class ByteStreamRequest
    extends InBandBytestreamRequest {
        private ByteStreamRequest(InBandBytestreamManager manager, Open byteStreamRequest) {
            super(manager, byteStreamRequest);
        }
    }

    private static class IBBOpenSidFilter
    extends PacketTypeFilter {
        private String sessionID;

        public IBBOpenSidFilter(String sessionID) {
            super(Open.class);
            if (sessionID == null) {
                throw new IllegalArgumentException("StreamID cannot be null");
            }
            this.sessionID = sessionID;
        }

        public boolean accept(Packet packet) {
            if (super.accept(packet)) {
                Open bytestream = (Open)packet;
                return this.sessionID.equals(bytestream.getSessionID()) && IQ.Type.SET.equals(bytestream.getType());
            }
            return false;
        }
    }
}

