/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.mailnotification;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MailThreadInfo {
    public static final String ELEMENT_NAME = "mail-thread-info";
    public static final String SENDERS_ELEMENT_NAME = "senders";
    public static final String LABELS_ELEMENT_NAME = "labels";
    public static final String SUBJECT_ELEMENT_NAME = "subject";
    public static final String SNIPPET_ELEMENT_NAME = "snippet";
    private List<Sender> senders = new LinkedList<Sender>();
    private String formattedDate = null;
    private String tid = null;
    public static final int PARTICIPATION_NONE = 0;
    public static final int PARTICIPATION_ONE_OF_MANY = 1;
    public static final int PARTICIPATION_SOLE_RECIPIENT = 2;
    private int participation = -1;
    private int messages;
    private long date = -1L;
    private String url = null;
    private String labels = null;
    private String subject = null;
    private String snippet = null;

    public int getParticipation() {
        return this.participation;
    }

    protected void setParticipation(int participation) {
        this.participation = participation;
    }

    public Iterator<Sender> senders() {
        return this.senders.iterator();
    }

    public int getSenderCount() {
        return this.senders.size();
    }

    public int getUnreadSenderCount() {
        Iterator<Sender> senders = this.senders();
        int count = 0;
        while (senders.hasNext()) {
            if (!senders.next().unread) continue;
            ++count;
        }
        return count;
    }

    public String findOriginator(boolean firstNameOnly) {
        return null;
    }

    protected void addSender(Sender sender) {
        this.senders.add(sender);
    }

    public int getMessageCount() {
        return this.messages;
    }

    protected void setMessageCount(int messageCount) {
        this.messages = messageCount;
    }

    public long getDate() {
        return this.date;
    }

    private String getFormattedDate() {
        if (this.formattedDate != null) {
            return this.formattedDate;
        }
        StringBuffer dateBuff = new StringBuffer();
        Calendar now = Calendar.getInstance();
        Date threadDate = new Date(this.getDate());
        Calendar threadDateCal = Calendar.getInstance();
        threadDateCal.setTime(new Date(this.getDate()));
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        DateFormat timeFormat = DateFormat.getTimeInstance(3);
        if (now.get(1) != threadDateCal.get(1) || now.get(2) != threadDateCal.get(2) || now.get(5) != threadDateCal.get(5)) {
            dateBuff.append(dateFormat.format(threadDate));
        }
        dateBuff.append(" ").append(timeFormat.format(threadDate));
        return dateBuff.toString();
    }

    protected void setDate(long date) {
        this.date = date;
    }

    public String getURL() {
        return this.url;
    }

    protected void setURL(String url) {
        this.url = url;
    }

    public String getLabels() {
        return this.labels;
    }

    protected void setLabels(String labels) {
        this.labels = labels;
    }

    public String getTid() {
        return this.tid;
    }

    protected void setTid(String tid) {
        this.tid = tid;
    }

    public String getSubject() {
        return this.subject;
    }

    protected void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSnippet() {
        return this.snippet;
    }

    protected void setSnippet(String snippet) {
        this.snippet = snippet;
    }

    public static MailThreadInfo parse(XmlPullParser parser) throws XmlPullParserException, NumberFormatException, IOException {
        String dateStr;
        String messagesStr;
        MailThreadInfo info = new MailThreadInfo();
        info.setTid(parser.getAttributeValue("", "tid"));
        String participationStr = parser.getAttributeValue("", "participation");
        if (participationStr != null) {
            info.setParticipation(Integer.parseInt(participationStr));
        }
        if ((messagesStr = parser.getAttributeValue("", "messages")) != null) {
            info.setMessageCount(Integer.parseInt(messagesStr));
        }
        if ((dateStr = parser.getAttributeValue("", "date")) != null) {
            info.setDate(Long.parseLong(dateStr));
        }
        info.setURL(parser.getAttributeValue("", "url"));
        int eventType = parser.next();
        while (eventType != 3) {
            if (eventType == 2) {
                String name = parser.getName();
                if (SENDERS_ELEMENT_NAME.equals(name)) {
                    info.parseSenders(parser);
                } else if (LABELS_ELEMENT_NAME.equals(name)) {
                    info.setLabels(parser.nextText());
                } else if (SUBJECT_ELEMENT_NAME.equals(name)) {
                    info.setSubject(parser.nextText());
                } else if (SNIPPET_ELEMENT_NAME.equals(name)) {
                    info.setSnippet(parser.nextText());
                }
            }
            eventType = parser.next();
        }
        return info;
    }

    private void parseSenders(XmlPullParser parser) throws XmlPullParserException, NumberFormatException, IOException {
        int eventType = parser.next();
        while (eventType != 3) {
            while (eventType != 3) {
                String name = parser.getName();
                if ("sender".equals(name)) {
                    String unreadStr;
                    Sender sender = new Sender();
                    sender.address = parser.getAttributeValue("", "address");
                    sender.name = parser.getAttributeValue("", "name");
                    String originatorStr = parser.getAttributeValue("", "originator");
                    if (originatorStr != null) {
                        boolean bl = sender.originator = Integer.parseInt(originatorStr) == 1;
                    }
                    if ((unreadStr = parser.getAttributeValue("", "unread")) != null) {
                        sender.unread = Integer.parseInt(unreadStr) == 1;
                    }
                    this.addSender(sender);
                }
                eventType = parser.next();
            }
            eventType = parser.next();
        }
    }

    private String createParticipantNames() {
        int maximumSndrsAllowed;
        StringBuffer participantNames = new StringBuffer();
        boolean firstNamesOnly = this.getSenderCount() > 1;
        int unreadSenderCount = this.getUnreadSenderCount();
        int remainingSndrsAllowed = maximumSndrsAllowed = 3;
        int maximumUnreadAllowed = Math.min(remainingSndrsAllowed, unreadSenderCount);
        int maximumReadAllowed = remainingSndrsAllowed - maximumUnreadAllowed;
        Iterator<Sender> senders = this.senders();
        while (senders.hasNext() && remainingSndrsAllowed != 0) {
            String name;
            Sender sender = senders.next();
            String string = name = firstNamesOnly ? sender.getFirstName() : sender.name;
            if (name == null) {
                if (sender.address != null) {
                    int atIndex = sender.address.indexOf("@");
                    if (atIndex != -1) {
                        return sender.address.substring(0, atIndex);
                    }
                    name = sender.address;
                } else {
                    name = "unknown";
                }
            }
            if (!sender.unread && maximumReadAllowed == 0) continue;
            if (remainingSndrsAllowed < maximumSndrsAllowed) {
                participantNames.append(", ");
            }
            --remainingSndrsAllowed;
            if (sender.unread) {
                participantNames.append("<b>").append(name).append("</b>");
                --maximumUnreadAllowed;
                continue;
            }
            participantNames.append(name);
            --maximumReadAllowed;
        }
        int messageCount = this.getMessageCount();
        if (messageCount > 1) {
            participantNames.append(" (").append(messageCount).append(")");
        }
        return participantNames.toString();
    }

    public String createHtmlDescription() {
        StringBuffer threadBuff = new StringBuffer();
        threadBuff.append("<tr bgcolor=\"#ffffff\">");
        threadBuff.append("<td>");
        threadBuff.append(this.createParticipantNames());
        threadBuff.append("</td>");
        threadBuff.append("<td>");
        threadBuff.append(this.createLabelList()).append("&nbsp;");
        threadBuff.append("<a href=\"");
        threadBuff.append(this.getURL()).append("\"><b>");
        threadBuff.append(this.getSubject()).append("</b></a>");
        threadBuff.append("<font color=#7777CC> - ");
        threadBuff.append("<a href=\"");
        threadBuff.append(this.getURL());
        threadBuff.append("\" style=\"text-decoration:none\">");
        threadBuff.append(this.getSnippet()).append("</a></font>");
        threadBuff.append("</td>");
        threadBuff.append("<td nowrap>");
        threadBuff.append(this.getFormattedDate());
        threadBuff.append("</td></tr>");
        return threadBuff.toString();
    }

    private String createLabelList() {
        String[] labelsArray = this.labels.split("\\|");
        StringBuffer labelsList = new StringBuffer();
        for (int i = 0; i < labelsArray.length; ++i) {
            String label = labelsArray[i];
            if (label.startsWith("^")) continue;
            labelsList.append("<font color=#006633>");
            labelsList.append(label);
            labelsList.append("</font>");
            if (i >= labelsArray.length - 1) continue;
            labelsList.append(", ");
        }
        return labelsList.toString();
    }

    public class Sender {
        public static final String ELEMENT_NAME = "sender";
        public String address = null;
        public String name = null;
        public boolean originator = false;
        public boolean unread = false;

        public String getFirstName() {
            if (this.name == null || this.name.trim().length() == 0) {
                return null;
            }
            String[] names = this.name.split("\\s");
            String result = names[0];
            if (result.length() > 14) {
                result = result.substring(0, 14);
            }
            return result;
        }
    }
}

