/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import net.java.sip.communicator.impl.protocol.jabber.ChatRoomMemberJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetMultiUserChatJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ServerStoredContactListJabberImpl;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import org.jivesoftware.smack.util.StringUtils;

public class VolatileContactJabberImpl
extends ContactJabberImpl {
    private String contactId = null;
    private boolean isPrivateMessagingContact = false;
    protected String displayName = null;

    VolatileContactJabberImpl(String id, ServerStoredContactListJabberImpl ssclCallback) {
        this(id, ssclCallback, false, null);
    }

    VolatileContactJabberImpl(String id, ServerStoredContactListJabberImpl ssclCallback, boolean isPrivateMessagingContact) {
        this(id, ssclCallback, isPrivateMessagingContact, null);
    }

    VolatileContactJabberImpl(String id, ServerStoredContactListJabberImpl ssclCallback, boolean isPrivateMessagingContact, String displayName) {
        super(null, ssclCallback, false, false);
        this.isPrivateMessagingContact = isPrivateMessagingContact;
        if (this.isPrivateMessagingContact) {
            this.displayName = StringUtils.parseResource((String)id) + " from " + StringUtils.parseBareAddress((String)id);
            this.contactId = id;
            this.setJid(id);
        } else {
            this.contactId = StringUtils.parseBareAddress((String)id);
            this.displayName = displayName == null ? this.contactId : displayName;
            String resource = StringUtils.parseResource((String)id);
            if (resource != null) {
                this.setJid(id);
            }
        }
    }

    @Override
    public String getAddress() {
        return this.contactId;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer("VolatileJabberContact[ id=");
        buff.append(this.getAddress()).append("]");
        return buff.toString();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    public boolean isPrivateMessagingContact() {
        return this.isPrivateMessagingContact;
    }

    public String getPersistableAddress() {
        if (!this.isPrivateMessagingContact) {
            return this.getAddress();
        }
        ChatRoomMemberJabberImpl chatRoomMember = null;
        OperationSetMultiUserChatJabberImpl mucOpSet = (OperationSetMultiUserChatJabberImpl)this.getProtocolProvider().getOperationSet(OperationSetMultiUserChat.class);
        if (mucOpSet != null) {
            chatRoomMember = mucOpSet.getChatRoom(StringUtils.parseBareAddress((String)this.contactId)).findMemberForNickName(StringUtils.parseResource((String)this.contactId));
        }
        return chatRoomMember == null ? null : StringUtils.parseBareAddress((String)chatRoomMember.getJabberID());
    }
}

