/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.WhiteboardInvitationJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.WhiteboardParticipantJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.WhiteboardSessionJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectJabberProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectPacketExtension;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetWhiteboarding;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.WhiteboardInvitation;
import net.java.sip.communicator.service.protocol.WhiteboardParticipant;
import net.java.sip.communicator.service.protocol.WhiteboardSession;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.event.WhiteboardInvitationListener;
import net.java.sip.communicator.service.protocol.event.WhiteboardInvitationReceivedEvent;
import net.java.sip.communicator.service.protocol.event.WhiteboardInvitationRejectionListener;
import net.java.sip.communicator.service.protocol.event.WhiteboardSessionPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.WhiteboardSessionPresenceListener;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObject;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;

public class OperationSetWhiteboardingJabberImpl
implements OperationSetWhiteboarding {
    private static final Logger logger = Logger.getLogger(OperationSetWhiteboardingJabberImpl.class);
    private ProtocolProviderServiceJabberImpl jabberProvider = null;
    private Vector<WhiteboardInvitationListener> invitationListeners = new Vector();
    private Vector<WhiteboardInvitationRejectionListener> invitationRejectionListeners = new Vector();
    private Vector<WhiteboardSessionPresenceListener> presenceListeners = new Vector();
    private Vector<WhiteboardSession> whiteboardSessions = new Vector();
    private OperationSetPersistentPresenceJabberImpl presenceOpSet;

    public OperationSetWhiteboardingJabberImpl(ProtocolProviderServiceJabberImpl provider) {
        this.jabberProvider = provider;
        provider.addRegistrationStateChangeListener(new RegistrationStateListener());
        ProviderManager pManager = ProviderManager.getInstance();
        pManager.addExtensionProvider("xObject", "http://jabber.org/protocol/swb", (Object)new WhiteboardObjectJabberProvider());
        pManager.addExtensionProvider("xSession", "http://jabber.org/protocol/swb", (Object)new WhiteboardObjectJabberProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationListener(WhiteboardInvitationListener listener) {
        Vector<WhiteboardInvitationListener> vector = this.invitationListeners;
        synchronized (vector) {
            if (!this.invitationListeners.contains(listener)) {
                this.invitationListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitationListener(WhiteboardInvitationListener listener) {
        Vector<WhiteboardInvitationListener> vector = this.invitationListeners;
        synchronized (vector) {
            this.invitationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationRejectionListener(WhiteboardInvitationRejectionListener listener) {
        Vector<WhiteboardInvitationRejectionListener> vector = this.invitationRejectionListeners;
        synchronized (vector) {
            if (!this.invitationRejectionListeners.contains(listener)) {
                this.invitationRejectionListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitationRejectionListener(WhiteboardInvitationRejectionListener listener) {
        Vector<WhiteboardInvitationRejectionListener> vector = this.invitationRejectionListeners;
        synchronized (vector) {
            this.invitationRejectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPresenceListener(WhiteboardSessionPresenceListener listener) {
        Vector<WhiteboardSessionPresenceListener> vector = this.presenceListeners;
        synchronized (vector) {
            if (!this.presenceListeners.contains(listener)) {
                this.presenceListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePresenceListener(WhiteboardSessionPresenceListener listener) {
        Vector<WhiteboardSessionPresenceListener> vector = this.presenceListeners;
        synchronized (vector) {
            this.presenceListeners.remove(listener);
        }
    }

    public WhiteboardSession createWhiteboardSession(String sessionName, Hashtable<Object, Object> sessionProperties) throws OperationFailedException, OperationNotSupportedException {
        WhiteboardSessionJabberImpl session = new WhiteboardSessionJabberImpl(this.jabberProvider, this);
        this.whiteboardSessions.add(session);
        return session;
    }

    public WhiteboardSession findWhiteboardSession(String sessionName) throws OperationFailedException, OperationNotSupportedException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WhiteboardSession> getCurrentlyJoinedWhiteboards() {
        Vector<WhiteboardSession> vector = this.whiteboardSessions;
        synchronized (vector) {
            LinkedList<WhiteboardSession> joinedWhiteboards = new LinkedList<WhiteboardSession>(this.whiteboardSessions);
            Iterator<WhiteboardSession> joinedWhiteboardsIter = this.whiteboardSessions.iterator();
            while (joinedWhiteboardsIter.hasNext()) {
                if (joinedWhiteboardsIter.next().isJoined()) continue;
                joinedWhiteboardsIter.remove();
            }
            return joinedWhiteboards;
        }
    }

    public List<WhiteboardSession> getCurrentlyJoinedWhiteboards(WhiteboardParticipant participant) throws OperationFailedException, OperationNotSupportedException {
        return null;
    }

    public boolean isWhiteboardingSupportedByContact(Contact contact) {
        return contact.getProtocolProvider().getOperationSet(OperationSetWhiteboarding.class) != null;
    }

    public void rejectInvitation(WhiteboardInvitation invitation, String rejectReason) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInvitationEvent(WhiteboardSession targetWhiteboard, WhiteboardObject whiteboardObject, String inviter, String reason, byte[] password) {
        ArrayList<WhiteboardInvitationListener> listeners;
        WhiteboardInvitationJabberImpl invitation = new WhiteboardInvitationJabberImpl(targetWhiteboard, whiteboardObject, inviter, reason, password);
        WhiteboardInvitationReceivedEvent evt = new WhiteboardInvitationReceivedEvent((OperationSetWhiteboarding)this, (WhiteboardInvitation)invitation, new Date(System.currentTimeMillis()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a WhiteboardInvitation event to " + this.invitationListeners.size() + " listeners. event is: " + evt.toString()));
        }
        Vector<WhiteboardInvitationListener> vector = this.invitationListeners;
        synchronized (vector) {
            listeners = new ArrayList<WhiteboardInvitationListener>(this.invitationListeners);
        }
        for (WhiteboardInvitationListener listener : listeners) {
            listener.invitationReceived(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWhiteboardSessionPresenceEvent(WhiteboardSession session, String eventType, String reason) {
        ArrayList<WhiteboardSessionPresenceListener> listeners;
        WhiteboardSessionPresenceChangeEvent evt = new WhiteboardSessionPresenceChangeEvent((OperationSetWhiteboarding)this, session, eventType, reason);
        Vector<WhiteboardSessionPresenceListener> vector = this.presenceListeners;
        synchronized (vector) {
            listeners = new ArrayList<WhiteboardSessionPresenceListener>(this.presenceListeners);
        }
        for (WhiteboardSessionPresenceListener listener : listeners) {
            listener.whiteboardSessionPresenceChanged(evt);
        }
    }

    private class WhiteboardSmackMessageListener
    implements PacketListener {
        private WhiteboardSmackMessageListener() {
        }

        public void processPacket(Packet packet) {
            WhiteboardSessionJabberImpl session;
            if (!(packet instanceof Message)) {
                return;
            }
            PacketExtension ext = packet.getExtension("xObject", "http://jabber.org/protocol/swb");
            Message msg = (Message)packet;
            if (ext == null) {
                return;
            }
            String fromUserID = StringUtils.parseBareAddress((String)msg.getFrom());
            for (int i = 0; i < OperationSetWhiteboardingJabberImpl.this.whiteboardSessions.size(); ++i) {
                session = (WhiteboardSessionJabberImpl)OperationSetWhiteboardingJabberImpl.this.whiteboardSessions.get(i);
                if (!session.isJoined() || !session.isParticipantContained(fromUserID)) continue;
                return;
            }
            WhiteboardObjectPacketExtension newMessage = (WhiteboardObjectPacketExtension)ext;
            session = new WhiteboardSessionJabberImpl(OperationSetWhiteboardingJabberImpl.this.jabberProvider, OperationSetWhiteboardingJabberImpl.this);
            OperationSetWhiteboardingJabberImpl.this.whiteboardSessions.add(session);
            ContactJabberImpl sourceContact = (ContactJabberImpl)OperationSetWhiteboardingJabberImpl.this.presenceOpSet.findContactByID(fromUserID);
            if (sourceContact == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Received a message from an unknown contact: " + fromUserID));
                }
                sourceContact = OperationSetWhiteboardingJabberImpl.this.presenceOpSet.createVolatileContact(fromUserID);
            }
            session.addWhiteboardParticipant(new WhiteboardParticipantJabberImpl(sourceContact, session));
            OperationSetWhiteboardingJabberImpl.this.fireInvitationEvent(session, newMessage.getWhiteboardObject(), fromUserID, null, null);
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                OperationSetWhiteboardingJabberImpl.this.presenceOpSet = (OperationSetPersistentPresenceJabberImpl)OperationSetWhiteboardingJabberImpl.this.jabberProvider.getOperationSet(OperationSetPresence.class);
                PacketExtensionFilter filterWhiteboard = new PacketExtensionFilter("xObject", "http://jabber.org/protocol/swb");
                OperationSetWhiteboardingJabberImpl.this.jabberProvider.getConnection().addPacketListener((PacketListener)new WhiteboardSmackMessageListener(), (PacketFilter)filterWhiteboard);
            }
        }
    }
}

