/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactResourceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ServerStoredContactListJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.caps.EntityCapsManager;
import net.java.sip.communicator.impl.protocol.jabber.extensions.caps.UserCapsNodeListener;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.ContactResourceEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import org.jivesoftware.smack.util.StringUtils;

public class MobileIndicator
implements RegistrationStateChangeListener,
UserCapsNodeListener {
    private final ProtocolProviderServiceJabberImpl parentProvider;
    private boolean isCapsMobileIndicator = true;
    private final String[] checkStrings;
    private final ServerStoredContactListJabberImpl ssclCallback;
    private static final String MOBILE_INDICATOR_RESOURCE_ACC_PROP = "MOBILE_INDICATOR_RESOURCE";
    private static final String MOBILE_INDICATOR_CAPS_ACC_PROP = "MOBILE_INDICATOR_CAPS";

    public MobileIndicator(ProtocolProviderServiceJabberImpl parentProvider, ServerStoredContactListJabberImpl ssclCallback) {
        this.parentProvider = parentProvider;
        this.ssclCallback = ssclCallback;
        String indicatorResource = (String)parentProvider.getAccountID().getAccountProperties().get(MOBILE_INDICATOR_RESOURCE_ACC_PROP);
        if (indicatorResource != null && indicatorResource.length() > 0) {
            this.isCapsMobileIndicator = false;
            this.checkStrings = indicatorResource.split(",");
        } else {
            String indicatorCaps = (String)parentProvider.getAccountID().getAccountProperties().get(MOBILE_INDICATOR_CAPS_ACC_PROP);
            if (indicatorCaps == null || indicatorCaps.length() == 0) {
                indicatorCaps = "android";
            }
            this.checkStrings = indicatorCaps.split(",");
            this.parentProvider.addRegistrationStateChangeListener(this);
        }
    }

    public void resourcesUpdated(ContactJabberImpl contact) {
        if (this.isCapsMobileIndicator) {
            this.updateMobileIndicatorUsingCaps(contact.getAddress());
            return;
        }
        int highestPriority = Integer.MIN_VALUE;
        ArrayList<ContactResource> highestPriorityResources = new ArrayList<ContactResource>();
        Collection<ContactResource> resources = contact.getResources();
        if (resources == null) {
            return;
        }
        for (ContactResource res : resources) {
            int prio;
            if (!res.getPresenceStatus().isOnline() || (prio = res.getPriority()) < highestPriority) continue;
            if (highestPriority != prio) {
                highestPriorityResources.clear();
            }
            highestPriority = prio;
            highestPriorityResources.add(res);
        }
        boolean allMobile = false;
        for (ContactResource res : highestPriorityResources) {
            if (res.isMobile()) {
                allMobile = true;
                continue;
            }
            allMobile = false;
            break;
        }
        if (highestPriorityResources.size() > 0) {
            contact.setMobile(allMobile);
        } else {
            contact.setMobile(false);
        }
    }

    boolean isMobileResource(String resourceName, String fullJid) {
        if (this.isCapsMobileIndicator) {
            EntityCapsManager capsManager = this.ssclCallback.getParentProvider().getDiscoveryManager().getCapsManager();
            EntityCapsManager.Caps caps = capsManager.getCapsByUser(fullJid);
            return caps != null && MobileIndicator.containsStrings(caps.node, this.checkStrings);
        }
        return MobileIndicator.startsWithStrings(resourceName, this.checkStrings);
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (evt.getNewState() == RegistrationState.REGISTERED) {
            this.parentProvider.getDiscoveryManager().getCapsManager().addUserCapsNodeListener(this);
        }
    }

    @Override
    public void userCapsNodeAdded(String user, String node, boolean online) {
        this.updateMobileIndicatorUsingCaps(user);
    }

    @Override
    public void userCapsNodeRemoved(String user, String node, boolean online) {
        this.updateMobileIndicatorUsingCaps(user);
    }

    private void updateMobileIndicatorUsingCaps(String user) {
        ContactJabberImpl contact = this.ssclCallback.findContactById(StringUtils.parseBareAddress((String)user));
        if (contact == null) {
            return;
        }
        int currentMostConnectedStatus = 0;
        ArrayList<ContactResourceJabberImpl> mostAvailableResources = new ArrayList<ContactResourceJabberImpl>();
        for (Map.Entry<String, ContactResourceJabberImpl> resEntry : contact.getResourcesMap().entrySet()) {
            int status;
            ContactResourceJabberImpl res = resEntry.getValue();
            if (!res.getPresenceStatus().isOnline()) continue;
            boolean oldIndicator = res.isMobile();
            res.setMobile(this.isMobileResource(res.getResourceName(), res.getFullJid()));
            if (oldIndicator != res.isMobile()) {
                contact.fireContactResourceEvent(new ContactResourceEvent((Contact)contact, (ContactResource)res, 2));
            }
            if ((status = res.getPresenceStatus().getStatus()) <= currentMostConnectedStatus) continue;
            if (currentMostConnectedStatus != status) {
                mostAvailableResources.clear();
            }
            currentMostConnectedStatus = status;
            mostAvailableResources.add(res);
        }
        boolean allMobile = false;
        for (ContactResourceJabberImpl res : mostAvailableResources) {
            if (res.isMobile()) {
                allMobile = true;
                continue;
            }
            allMobile = false;
            break;
        }
        if (mostAvailableResources.size() > 0) {
            contact.setMobile(allMobile);
        } else {
            contact.setMobile(false);
        }
    }

    private static boolean startsWithStrings(String value, String[] checkStrs) {
        for (String str : checkStrs) {
            if (str.length() <= 0 || !value.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsStrings(String value, String[] checkStrs) {
        for (String str : checkStrs) {
            if (str.length() <= 0 || !value.contains(str)) continue;
            return true;
        }
        return false;
    }
}

