/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.osgi.framework;

import java.util.HashMap;
import org.jitsi.impl.osgi.framework.BundleContextHolderImpl;
import org.jitsi.impl.osgi.framework.launch.FrameworkFactoryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.BundleStartLevel;

public class OSGiLauncher {
    private final BundleContextHolderImpl bundleContextHolder = new BundleContextHolderImpl();
    private final String[][] bundles;
    private Framework framework;

    public OSGiLauncher(String[][] bundles) {
        this.bundles = bundles;
    }

    private void start() {
        if (this.framework != null) {
            return;
        }
        FrameworkFactoryImpl frameworkFactory = new FrameworkFactoryImpl();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.startlevel.beginning", Integer.toString(this.bundles.length));
        Framework framework = frameworkFactory.newFramework(configuration);
        boolean started = false;
        try {
            framework.init();
            BundleContext bundleContext = framework.getBundleContext();
            for (int startLevelMinus1 = 0; startLevelMinus1 < this.bundles.length; ++startLevelMinus1) {
                int startLevel = startLevelMinus1 + 1;
                for (String location : this.bundles[startLevelMinus1]) {
                    BundleStartLevel bundleStartLevel;
                    Bundle bundle = bundleContext.installBundle(location);
                    if (bundle == null || (bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class)) == null) continue;
                    bundleStartLevel.setStartLevel(startLevel);
                }
            }
            this.framework = framework;
            framework.start();
            started = true;
            this.bundleContextHolder.start(bundleContext);
        }
        catch (Exception be) {
            throw new RuntimeException(be);
        }
        finally {
            if (!started && this.framework == framework) {
                this.framework = null;
            }
        }
    }

    public synchronized void start(BundleActivator bundleActivator) {
        this.start();
        this.bundleContextHolder.addBundleActivator(bundleActivator);
    }

    private void stop() {
        if (this.framework != null) {
            boolean waitForStop = false;
            try {
                this.framework.stop();
                waitForStop = true;
            }
            catch (BundleException be) {
                throw new RuntimeException(be);
            }
            if (waitForStop) {
                this.waitForStop();
            }
            this.framework = null;
            try {
                this.bundleContextHolder.stop(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized void stop(BundleActivator bundleActivator) {
        this.bundleContextHolder.removeBundleActivator(bundleActivator);
        if (this.bundleContextHolder.getBundleActivatorCount() < 1) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForStop() {
        boolean interrupted = false;
        try {
            int state;
            while (this.framework != null && ((state = this.framework.getState()) == 32 || state == 8 || state == 16)) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

