/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.credentialsstorage;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.java.sip.communicator.impl.credentialsstorage.Crypto;
import net.java.sip.communicator.service.credentialsstorage.CryptoException;
import net.java.sip.communicator.util.Base64;

public class AESCrypto
implements Crypto {
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5PADDING";
    private static byte[] SALT = new byte[]{12, 10, 15, 14, 11, 14, 14, 15};
    private static int[] KEY_LENGTHS = new int[]{256, 128};
    private static int ITERATION_COUNT = 1024;
    private Key key;
    private Cipher decryptCipher;
    private Cipher encryptCipher;

    public AESCrypto(String masterPassword) {
        try {
            for (int i = 0; i < KEY_LENGTHS.length; ++i) {
                this.decryptCipher = Cipher.getInstance(CIPHER_ALGORITHM);
                this.encryptCipher = Cipher.getInstance(CIPHER_ALGORITHM);
                try {
                    this.initKey(masterPassword, KEY_LENGTHS[i]);
                    break;
                }
                catch (InvalidKeyException e) {
                    if (i != KEY_LENGTHS.length - 1) continue;
                    throw e;
                }
            }
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Invalid key", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Invalid key specification", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Algorithm not found", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Padding not found", e);
        }
    }

    private void initKey(String masterPassword, int keyLength) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        if (masterPassword == null) {
            masterPassword = " ";
        }
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(masterPassword.toCharArray(), SALT, ITERATION_COUNT, keyLength);
        SecretKey tmp = factory.generateSecret(spec);
        this.key = new SecretKeySpec(tmp.getEncoded(), KEY_ALGORITHM);
        this.encryptCipher.init(1, this.key);
        this.decryptCipher.init(2, this.key);
    }

    @Override
    public String decrypt(String ciphertext) throws CryptoException {
        try {
            this.decryptCipher.init(2, this.key);
            return new String(this.decryptCipher.doFinal(Base64.decode((String)ciphertext)), "UTF-8");
        }
        catch (BadPaddingException e) {
            throw new CryptoException(3, e);
        }
        catch (Exception e) {
            throw new CryptoException(2, e);
        }
    }

    @Override
    public String encrypt(String plaintext) throws CryptoException {
        try {
            this.encryptCipher.init(1, this.key);
            return new String(Base64.encode((byte[])this.encryptCipher.doFinal(plaintext.getBytes("UTF-8"))));
        }
        catch (Exception e) {
            throw new CryptoException(1, e);
        }
    }
}

