/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.cache.CacheException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class MXBeanUtil {
    private static MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    private MXBeanUtil() {
    }

    public static void registerCacheObject(Object mxbean, String cacheManagerName, String name, boolean stats) {
        ObjectName registeredObjectName = MXBeanUtil.calculateObjectName(cacheManagerName, name, stats);
        try {
            if (!MXBeanUtil.isRegistered(cacheManagerName, name, stats)) {
                mBeanServer.registerMBean(mxbean, registeredObjectName);
            }
        }
        catch (Exception e) {
            throw new CacheException("Error registering cache MXBeans for CacheManager " + registeredObjectName + " . Error was " + e.getMessage(), (Throwable)e);
        }
    }

    static boolean isRegistered(String cacheManagerName, String name, boolean stats) {
        Set<ObjectName> registeredObjectNames = null;
        ObjectName objectName = MXBeanUtil.calculateObjectName(cacheManagerName, name, stats);
        registeredObjectNames = mBeanServer.queryNames(objectName, null);
        return !registeredObjectNames.isEmpty();
    }

    public static void unregisterCacheObject(String cacheManagerName, String name, boolean stats) {
        Set<ObjectName> registeredObjectNames = null;
        ObjectName objectName = MXBeanUtil.calculateObjectName(cacheManagerName, name, stats);
        registeredObjectNames = mBeanServer.queryNames(objectName, null);
        for (ObjectName registeredObjectName : registeredObjectNames) {
            try {
                mBeanServer.unregisterMBean(registeredObjectName);
            }
            catch (Exception e) {
                throw new CacheException("Error unregistering object instance " + registeredObjectName + " . Error was " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static ObjectName calculateObjectName(String cacheManagerName, String name, boolean stats) {
        String cacheManagerNameSafe = MXBeanUtil.mbeanSafe(cacheManagerName);
        String cacheName = MXBeanUtil.mbeanSafe(name);
        try {
            String objectNameType = stats ? "Statistics" : "Configuration";
            return new ObjectName("javax.cache:type=Cache" + objectNameType + ",CacheManager=" + cacheManagerNameSafe + ",Cache=" + cacheName);
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Illegal ObjectName for Management Bean. CacheManager=[" + cacheManagerNameSafe + "], Cache=[" + cacheName + "]", (Throwable)e);
        }
    }

    private static String mbeanSafe(String string) {
        return string == null ? "" : string.replaceAll(",|:|=|\n", ".");
    }
}

