/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import LZMA.LzmaInputStream;
import com.install4j.api.DirectoryValidator;
import com.install4j.api.FileOptions;
import com.install4j.api.InitHandler;
import com.install4j.api.InstallAction;
import com.install4j.api.InstallationHandler;
import com.install4j.api.InstallerContext;
import com.install4j.api.InstallerWizardContext;
import com.install4j.api.ProgressInterface;
import com.install4j.api.StartupHandler;
import com.install4j.api.UserCanceledException;
import com.install4j.runtime.installer.Common;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallationProperties;
import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.QuietInstallerFrontend;
import com.install4j.runtime.installer.QuietProgressInterface;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.MenuEntryConfig;
import com.install4j.runtime.installer.config.ServiceConfig;
import com.install4j.runtime.installer.fileinst.FileInstaller;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.InstallerFrontend;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.PasswordDialog;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.platform.PlatformSpecificInstaller;
import com.install4j.runtime.installer.platform.UserInfo;
import com.install4j.runtime.installer.platform.unix.SudoExecution;
import com.install4j.runtime.installer.platform.unix.UnixFileSystem;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.installer.platform.win32.InstallRegistry;
import com.install4j.runtime.installer.platform.win32.Misc;
import com.install4j.runtime.installer.platform.win32.Registry;
import com.install4j.runtime.installer.platform.win32.ShellLink;
import com.install4j.runtime.installer.platform.win32.WinDel;
import com.install4j.runtime.util.FileResourceBundle;
import com.install4j.runtime.util.FileUtil;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class Installer {
    private FileInstaller fileInstaller = FileInstaller.getInstance();
    private InstallerFrontend installerFrontend;
    private File installationDirectory;
    private InstallAction currentAction;
    private boolean abort = false;
    public static final int STATE_NOT_STARTED = 0;
    public static final int STATE_INSTALLING = 1;
    public static final int STATE_CLEANUP = 2;
    public static final int STATE_DONE = 3;
    public static final int STATE_PREPARING = 4;
    public static final int STATE_ROLLING_BACK = 5;
    private int state = 0;
    private long jreSize = -1L;
    private int jreCount = -1;
    private Properties stats;
    private static final String JRE_DIR = "jre";
    private static final String JRE_TAR = "jre.tar";
    private static Installer installer = null;
    private static final String REGKEY_EXE4J = "SOFTWARE\\ej-technologies\\exe4j\\";
    private static final String REGKEY_LOCATED_JVMS = "SOFTWARE\\ej-technologies\\exe4j\\locatedjvms\\";
    private static final String REGVAL_INSTALL_STARTED = "InstallStarted";
    private static final boolean MANUAL_JRE = Boolean.getBoolean("exe4j.manualJre");
    private static final String MAC_SPEC_PROPERTY_NAME = "install4j.mac_origin";
    private boolean quiet = false;
    private File quietInstallDir = null;
    private boolean quietOverwrite = false;
    private File overridingDefaultDirectory;
    private String prefJre = null;
    private InstallationProperties installationProperties;
    private static final boolean DEBUG = Boolean.getBoolean("install4.debug");
    static /* synthetic */ Class class$com$install4j$api$DirectoryValidator;
    static /* synthetic */ Class class$com$install4j$api$InstallationHandler;

    public static Installer getInstance() {
        if (installer == null) {
            installer = new Installer();
        }
        return installer;
    }

    private Installer() {
    }

    public DirectoryValidator getDirectoryValidator() {
        String string = InstallerConfig.getCurrentInstance().getInstallDirValidatorClass();
        if (string == null) {
            return null;
        }
        try {
            DirectoryValidator directoryValidator = (DirectoryValidator)InstallerUtil.instantiateClass(string, "installation directory validator", class$com$install4j$api$DirectoryValidator == null ? (class$com$install4j$api$DirectoryValidator = Installer.class$("com.install4j.api.DirectoryValidator")) : class$com$install4j$api$DirectoryValidator);
            if (directoryValidator != null) {
                directoryValidator.setInstallerContext(this.installerFrontend.getInstallerContext());
            }
            return directoryValidator;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GUIHelper.showMessage(null, exception.getMessage(), 0);
            System.exit(1);
            return null;
        }
    }

    public static boolean validateInstallationDirectory(File file, DirectoryValidator directoryValidator, Component component) {
        FileResourceBundle fileResourceBundle = Messages.getMessages();
        if (directoryValidator != null && directoryValidator.canValidate() && !directoryValidator.validate(file)) {
            return false;
        }
        File file2 = directoryValidator != null ? directoryValidator.getInstallationDirectory(file, Installer.getInstance().getDefaultDirectory().getName()) : file;
        String string = InstallerUtil.getOldApplicationId(file2);
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        String string2 = installerConfig.getTargetApplicationId();
        if (installerConfig.getInstallerType() == 1) {
            boolean bl;
            if (string != null) {
                if (string2.equals(string)) {
                    return true;
                }
                if (string.trim().length() > 0) {
                    GUIHelper.showMessage(component, fileResourceBundle.getString("DifferentApplication"), 1);
                    return false;
                }
            }
            boolean bl2 = bl = directoryValidator != null && directoryValidator.canValidate();
            if (!(bl || !file.exists() || InstallerUtil.isMacOS() && file.getAbsolutePath().equals(InstallerUtil.getStandardApplicationsDirectory()))) {
                if (component != null) {
                    int n = GUIHelper.showOptionDialog(component, MessageFormat.format(fileResourceBundle.getString("DirExists"), file.getAbsolutePath()), new String[]{fileResourceBundle.getString("ButtonYes"), fileResourceBundle.getString("ButtonNo")}, 3);
                    return n == 0;
                }
                return true;
            }
            return true;
        }
        if (string != null && string2.equals(string)) {
            return true;
        }
        GUIHelper.showMessage(component, fileResourceBundle.getString("NoTargetApplication"), 1);
        return false;
    }

    public synchronized void abort(ProgressInterface progressInterface) {
        if (this.state == 1) {
            this.abort = true;
            if (this.currentAction != null) {
                this.currentAction.cancel();
            }
            progressInterface.setStatusMessage(Messages.getMessages().getString("StatusRollback"));
            progressInterface.setDetailMessage("");
            progressInterface.setPercentCompleted(0);
        } else if (this.state == 2) {
            this.abort = true;
        } else {
            System.exit(1);
        }
    }

    public int getInstallationState() {
        return this.state;
    }

    private synchronized void setInstallationState(int n) {
        if (this.abort && n == 3) {
            System.exit(1);
        }
        this.state = n;
    }

    private void rollbackStandardInstallation(ProgressInterface progressInterface) {
        this.fileInstaller.rollback(progressInterface);
    }

    public void install(File file, File file2) {
        this.installationDirectory = file;
        this.installationProperties = new InstallationProperties(file);
        if (Common.checkRunningProcesses(this.installationProperties, this.quiet, "SetupAppRunningError")) {
            this.setInstallationState(4);
            this.stopServices();
            this.uninstallPrevious();
            this.setInstallationState(1);
            this.doInstallation();
            if (InstallerUtil.isWindows()) {
                InstallRegistry.registerApplication(InstallerConfig.getCurrentInstance().getApplicationId(), file2.getAbsolutePath(), this.installerFrontend.getInstallerContext().getProgramGroup());
            }
            this.setInstallationState(3);
        } else {
            if (this.quiet) {
                System.err.println("The application is running. Please close all instances and run this installer again.");
            }
            System.exit(1);
        }
    }

    private void uninstallPrevious() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig.isRunUninstallerOnUpdate() && installerConfig.getApplicationId().equals(InstallerUtil.getOldApplicationId(this.installationDirectory))) {
            ProgressInterface progressInterface = this.installerFrontend.getProgressInterface();
            progressInterface.setStatusMessage(Messages.getMessages().getString("StatusUninstallingPrevious"));
            progressInterface.setIndeterminateProgress(true);
            try {
                if (InstallerUtil.isMacOS()) {
                    this.runJavaUninstaller();
                } else if (InstallerUtil.isWindows()) {
                    File file = new File("i4j_undel.log.tmp");
                    Process process = Runtime.getRuntime().exec(new String[]{new File(this.installationDirectory, "uninstall.exe").getAbsolutePath(), "-q_i4j_internal", "-q", "-Dwindel.logfile=" + file.getAbsolutePath()}, null, new File(this.installationDirectory, ".."));
                    if (process.waitFor() == 83) {
                        this.runJavaUninstaller();
                    } else {
                        Thread.sleep(500L);
                        this.deleteWindowsUndelFiles(file);
                    }
                } else {
                    Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", new File(this.installationDirectory, "uninstall").getAbsolutePath(), "-q"}, null, new File(this.installationDirectory, ".."));
                    if (process.waitFor() == 83) {
                        this.runJavaUninstaller();
                    }
                }
                Thread.sleep(500L);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            progressInterface.setIndeterminateProgress(false);
        }
    }

    private void deleteWindowsUndelFiles(File file) throws IOException {
        if (file.exists()) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            if (bufferedReader.readLine() != null) {
                String string = bufferedReader.readLine();
                while (string != null) {
                    if (!string.equals("") && !new File(string).delete()) {
                        System.out.println("could not delete " + string);
                    }
                    string = bufferedReader.readLine();
                }
            }
            bufferedReader.close();
            file.delete();
        } else {
            System.out.println(file + " doesn't exist");
        }
    }

    private void runJavaUninstaller() throws IOException, InterruptedException {
        File file = new File(this.installationDirectory, ".install4j");
        Process process = Runtime.getRuntime().exec(new String[]{new File(System.getProperty("java.home"), "bin/java").getAbsolutePath(), "-Dinstall4j.mac_origin=" + SudoExecution.getScrambledPassword(), "-cp", new File(file, "i4jruntime.jar").getAbsolutePath() + File.pathSeparator + new File(file, "user.jar").getAbsolutePath(), "com.install4j.runtime.installer.Uninstaller", "-q"}, null, new File(this.installationDirectory, ".."));
        process.waitFor();
    }

    private void stopServices() {
        if (!InstallerUtil.isWindows() || InstallerUtil.isWindows9X()) {
            return;
        }
        List list = this.installationProperties.getPropertyList("service");
        if (list.size() > 0) {
            ProgressInterface progressInterface = this.installerFrontend.getProgressInterface();
            progressInterface.setStatusMessage(Messages.getMessages().getString("StatusStoppingServices"));
            progressInterface.setDetailMessage(" ");
            progressInterface.setIndeterminateProgress(true);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{string, "/stop"});
                    process.waitFor();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            progressInterface.setIndeterminateProgress(false);
        }
    }

    public File getInstallationDirectory() {
        return this.installationDirectory;
    }

    public void setPreferredJRE(String string) {
        this.prefJre = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInstallation() {
        ProgressInterface progressInterface = this.installerFrontend.getProgressInterface();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        InstallAction installAction = null;
        InstallAction installAction2 = null;
        InstallationHandler installationHandler = null;
        try {
            installAction = (InstallAction)InstallerUtil.instantiateAction(installerConfig.getPreActionClass());
            installAction2 = (InstallAction)InstallerUtil.instantiateAction(installerConfig.getPostActionClass());
            installationHandler = (InstallationHandler)InstallerUtil.instantiateClass(installerConfig.getInstallationHandlerClass(), "installation handler", class$com$install4j$api$InstallationHandler == null ? (class$com$install4j$api$InstallationHandler = Installer.class$("com.install4j.api.InstallationHandler")) : class$com$install4j$api$InstallationHandler);
            if (installationHandler != null) {
                installationHandler.setInstallerContext(this.installerFrontend.getInstallerContext());
            }
        }
        catch (Exception exception) {
            GUIHelper.showMessage(null, exception.getMessage(), 0);
            System.exit(1);
        }
        int n = installAction == null ? 0 : installAction.getPercentOfTotalInstallation();
        int n2 = installAction2 == null ? 0 : installAction2.getPercentOfTotalInstallation();
        ProgressAdapter progressAdapter = new ProgressAdapter(progressInterface, 0, n);
        ProgressAdapter progressAdapter2 = new ProgressAdapter(progressInterface, n, 100 - n2);
        ProgressAdapter progressAdapter3 = new ProgressAdapter(progressInterface, 100 - n2, 100);
        boolean bl = false;
        boolean bl2 = false;
        if (InstallerUtil.isWindows()) {
            ShellLink.initialize();
        }
        try {
            this.fileInstaller.setLogDir(Installer.getRuntimeDir(this.installationDirectory));
            this.doAction(installAction, progressAdapter);
            if (this.abort) {
                throw new UserCanceledException();
            }
            bl = true;
            this.doStandardInstallation(this.installationDirectory, progressAdapter2, installationHandler);
            this.writeInstallationProperties();
            if (this.abort) {
                throw new UserCanceledException();
            }
            bl2 = true;
            this.doAction(installAction2, progressAdapter3);
            if (this.abort) {
                throw new UserCanceledException();
            }
            if (this.prefJre != null) {
                this.writeOneLineFile(new File(Installer.getRuntimeDir(this.installationDirectory), "pref_jre.cfg"), this.prefJre);
            }
            this.fileInstaller.writeLog();
            this.setInstallationState(2);
            this.cleanup(progressInterface);
        }
        catch (UserCanceledException userCanceledException) {
            this.stopServices();
            this.setInstallationState(5);
            this.abort = true;
            progressInterface.setStatusMessage(Messages.getMessages().getString("StatusRollback"));
            progressInterface.setPercentCompleted(0);
            progressInterface.setDetailMessage(" ");
            this.rollbackAction(installAction, progressAdapter);
            if (bl) {
                this.rollbackStandardInstallation(progressAdapter2);
            }
            if (bl2) {
                this.rollbackAction(installAction2, progressAdapter3);
            }
        }
        catch (Throwable throwable) {
            this.reportExeption(throwable);
            this.cleanup(progressInterface);
            System.exit(1);
        }
        finally {
            if (InstallerUtil.isWindows()) {
                ShellLink.uninitialize();
            }
        }
    }

    private void writeInstallationProperties() throws IOException {
        Object object;
        if (!InstallerUtil.isWindows()) {
            return;
        }
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        ArrayList arrayList = new ArrayList(installerConfig.getFileOptionsConfig().getLaunchers());
        Iterator iterator = installerConfig.getServices().iterator();
        while (iterator.hasNext()) {
            object = (ServiceConfig)iterator.next();
            arrayList.remove(((MenuEntryConfig)object).getFile());
            this.installationProperties.addFileToSet("service", new File(this.installationDirectory, ((MenuEntryConfig)object).getFile()));
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.installationProperties.addFileToSet("launcher", new File(this.installationDirectory, (String)object));
        }
        this.installationProperties.store();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAction(InstallAction installAction, ProgressInterface progressInterface) throws UserCanceledException {
        if (installAction == null) {
            return;
        }
        Installer installer = this;
        synchronized (installer) {
            this.currentAction = installAction;
        }
        boolean bl = false;
        InstallerContext installerContext = this.installerFrontend.getInstallerContext();
        bl = installerContext instanceof InstallerWizardContext ? installAction.performAction((InstallerWizardContext)installerContext, progressInterface) : installAction.performUnattendedAction(installerContext);
        if (!bl) {
            this.abort = true;
        }
        Installer installer2 = this;
        synchronized (installer2) {
            this.currentAction = null;
        }
    }

    private void rollbackAction(InstallAction installAction, ProgressInterface progressInterface) {
        if (installAction == null) {
            return;
        }
        InstallerContext installerContext = this.installerFrontend.getInstallerContext();
        if (installerContext instanceof InstallerWizardContext) {
            installAction.rollback((InstallerWizardContext)installerContext, progressInterface);
        } else {
            installAction.rollbackUnattended(installerContext);
        }
    }

    public long getMinSize() {
        try {
            return this.getJreSize() + this.getContentSize();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0L;
        }
    }

    private long getJreSize() throws IOException {
        if (this.jreSize == -1L) {
            this.initJreSizeAndCount();
        }
        return this.jreSize;
    }

    private void initJreSizeAndCount() throws IOException {
        if (InstallerUtil.isWindows()) {
            File file = new File(JRE_DIR);
            this.jreSize = Installer.countSize(file);
            this.jreCount = Installer.countFilesAndDirs(file);
        } else {
            this.jreSize = 0L;
            this.jreCount = 0;
            File file = new File(JRE_TAR);
            if (file.exists()) {
                TarInputStream tarInputStream = new TarInputStream(new BufferedInputStream(new FileInputStream(file)));
                TarEntry tarEntry = tarInputStream.getNextEntry();
                while (tarEntry != null) {
                    ++this.jreCount;
                    this.jreSize += tarEntry.getSize();
                    tarEntry = tarInputStream.getNextEntry();
                }
            }
        }
    }

    private int getJreCount() throws IOException {
        if (this.jreCount == -1) {
            this.initJreSizeAndCount();
        }
        return this.jreCount;
    }

    private long getContentSize() throws IOException {
        if (this.stats == null) {
            this.initStats();
        }
        return Long.parseLong(this.stats.getProperty("content.size"));
    }

    private void initStats() throws IOException {
        this.stats = new Properties();
        FileInputStream fileInputStream = new FileInputStream(new File("stats.properties"));
        this.stats.load(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    private int getContentCount() throws IOException {
        if (this.stats == null) {
            this.initStats();
        }
        return Integer.parseInt(this.stats.getProperty("content.count"));
    }

    private long getContentFileSize() throws IOException {
        if (this.stats == null) {
            this.initStats();
        }
        return Long.parseLong(this.stats.getProperty("file.size"));
    }

    private void doStandardInstallation(File file, ProgressInterface progressInterface, InstallationHandler installationHandler) throws IOException, UserCanceledException {
        if (this.abort) {
            return;
        }
        this.fileInstaller.createDirectory(file);
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        long l = this.getContentSize();
        int n = this.getContentCount();
        boolean bl = this.isInstallJre();
        if (bl) {
            l += this.getJreSize();
            n += this.getJreCount();
        }
        if (InstallerConfig.getCurrentInstance().isLzmaCompression()) {
            l += this.getContentFileSize();
            ++n;
        }
        long l2 = l / (long)n;
        l *= 2L;
        File file2 = new File("content.zip").getAbsoluteFile();
        long l3 = 0L;
        if (InstallerConfig.getCurrentInstance().isLzmaCompression()) {
            if (InstallerUtil.isMacOS()) {
                file2 = File.createTempFile("i4jc", ".zip");
            }
            l3 = this.uncompressContentZip(new File("content.zip.lzma").getAbsoluteFile(), file2, progressInterface, l2, l);
        }
        l3 = this.installContent(file2, progressInterface, installationHandler, file, l2, l, l3);
        if (bl) {
            this.installJre(progressInterface, l2, l, l3, file);
        }
        this.writeOneLineFile(new File(Installer.getRuntimeDir(file), "inst_jre.cfg"), System.getProperty("java.home"));
        progressInterface.setDetailMessage("");
        this.createRuntimeDirectory(file);
        PlatformSpecificInstaller.doInstallation(file, this, progressInterface);
        if (InstallerConfig.getCurrentInstance().isLzmaCompression() && InstallerUtil.isMacOS()) {
            file2.delete();
        }
        if (!this.abort) {
            progressInterface.setPercentCompleted(100);
        }
    }

    private long uncompressContentZip(File file, File file2, ProgressInterface progressInterface, long l, long l2) throws IOException {
        LzmaInputStream lzmaInputStream = new LzmaInputStream(new FileInputStream(file));
        ProgressAdapter progressAdapter = new ProgressAdapter(progressInterface, 0, (int)(this.getContentFileSize() * 100L / l2));
        progressAdapter.setMaxCopyProgress(this.getContentFileSize());
        FileUtil.extractFile(lzmaInputStream, file2, progressAdapter);
        return this.getContentFileSize() + l;
    }

    private boolean isInstallJre() {
        Object object;
        if (MANUAL_JRE && this.prefJre == null) {
            object = null;
            try {
                object = new File(System.getProperty("java.home")).getCanonicalPath();
                if (!((String)object).startsWith(new File(System.getProperty("user.dir")).getCanonicalPath())) {
                    this.prefJre = object;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (InstallerUtil.isWindows() && new File(JRE_DIR).exists() || !InstallerUtil.isWindows() && new File(JRE_TAR).exists()) {
            object = InstallerConfig.getCurrentInstance();
            if (((InstallerConfig)object).isJreShared() && (InstallerUtil.isWindows() || UserInfo.isAdminUser())) {
                File file = Installer.getSharedJreDir();
                if (this.prefJre == null) {
                    this.prefJre = file.getAbsolutePath();
                }
                return !file.exists();
            }
            return true;
        }
        return false;
    }

    private void installJre(ProgressInterface progressInterface, long l, long l2, long l3, File file) throws IOException, UserCanceledException {
        File file2;
        boolean bl = InstallerConfig.getCurrentInstance().isJreShared();
        File file3 = null;
        if (InstallerUtil.isWindows()) {
            file2 = new File(JRE_DIR);
            if (file2.exists()) {
                file3 = this.prepareJreDestDir(file);
                this.installDir(file2, file3, progressInterface, l, l2, l3, bl);
            }
        } else {
            file2 = new File(JRE_TAR);
            if (file2.exists()) {
                file3 = this.prepareJreDestDir(file);
                this.installTar(file2, file3, new File(JRE_DIR), progressInterface, l, l2, l3, bl);
            }
        }
        if (!InstallerUtil.isWindows9X() && file3 != null && InstallerConfig.getCurrentInstance().getJreVersion() != null && InstallerConfig.getCurrentInstance().getJreVersion().trim().length() > 2 && InstallerConfig.getCurrentInstance().getJreVersion().trim().substring(0, 3).compareTo("1.5") >= 0 && (file2 = new File(file3, "bin/java" + (InstallerUtil.isWindows() ? "w.exe" : ""))).exists()) {
            Runtime.getRuntime().exec(new String[]{file2.getAbsolutePath(), "-Xshare:dump"});
        }
    }

    private File prepareJreDestDir(File file) throws IOException {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        File file2 = installerConfig.isJreShared() && (InstallerUtil.isWindows() || UserInfo.isAdminUser()) ? Installer.getSharedJreDir() : new File(file, JRE_DIR);
        if (file2.exists()) {
            FileUtil.emptyDirectory(file2);
        }
        FileInstaller.getInstance().createDirectory(file2, installerConfig.isJreShared());
        this.registerPreferredJre(file2, installerConfig.isJreShared());
        return file2;
    }

    private void writeOneLineFile(File file, String string) throws IOException, UserCanceledException {
        this.fileInstaller.createDirectory(file.getParentFile());
        File file2 = File.createTempFile("i4j", null);
        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
        printWriter.println(string);
        printWriter.close();
        FileInstaller.getInstance().install(file2, file, new FileOptions("644", 1, false));
        file2.delete();
    }

    private void registerPreferredJre(File file, boolean bl) {
        String string;
        if (bl && InstallerUtil.isWindows() && !Registry.createKey(3, string = REGKEY_LOCATED_JVMS + file.getAbsolutePath().replace('\\', '/') + "/bin/java.exe")) {
            Registry.createKey(2, string);
        }
    }

    private static File getSharedJreDir() {
        File file = InstallerUtil.isWindows() && !InstallerUtil.isWindows9X() ? FolderInfo.getCommonFilesDirectory() : new File(InstallerUtil.getStandardApplicationsDirectory());
        file = new File(file, "i4j_jres");
        String string = InstallerConfig.getCurrentInstance().getJreVersion().trim();
        if (!string.equals("")) {
            return new File(file, string);
        }
        int n = 1;
        File file2 = new File(file, JRE_DIR + n);
        while (file2.exists()) {
            file2 = new File(file, JRE_DIR + ++n);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long installTar(File file, File file2, File file3, ProgressInterface progressInterface, long l, long l2, long l3, boolean bl) throws IOException, UserCanceledException {
        TarInputStream tarInputStream = new TarInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            TarEntry tarEntry = tarInputStream.getNextEntry();
            while (tarEntry != null) {
                if (this.abort) {
                    throw new UserCanceledException();
                }
                boolean bl2 = false;
                String string = tarEntry.getName();
                if (string.endsWith("jar.pack")) {
                    string = string.substring(0, string.length() - 5);
                    bl2 = true;
                }
                progressInterface.setDetailMessage(this.cleanupName(string));
                File file4 = new File(file2, string);
                if (tarEntry.isSymlink()) {
                    l3 += l;
                    UnixFileSystem.createLink(tarEntry.getLinkName(), file4);
                    if (!bl) {
                        this.fileInstaller.addCreatedFile(file4);
                    }
                } else if (tarEntry.isDirectory()) {
                    l3 += l;
                    this.fileInstaller.createDirectory(file4, bl);
                } else {
                    long l4 = l3 + l + tarEntry.getSize();
                    FileOptions fileOptions = new FileOptions();
                    fileOptions.setMode(tarEntry.getMode());
                    fileOptions.setDontUninstall(bl);
                    fileOptions.setFileTime(tarEntry.getModTime().getTime());
                    if (bl2) {
                        this.fileInstaller.install(new File(file3, string), file4, fileOptions, new ProgressAdapter(progressInterface, (int)(l3 * 100L / l2), (int)(l4 * 100L / l2)));
                    } else {
                        this.fileInstaller.install(tarInputStream, file4, fileOptions, new ProgressAdapter(progressInterface, (int)(l3 * 100L / l2), (int)(l4 * 100L / l2)), tarEntry.getSize());
                    }
                    l3 = l4;
                }
                progressInterface.setPercentCompleted((int)(l3 * 100L / l2));
                tarEntry = tarInputStream.getNextEntry();
            }
        }
        finally {
            tarInputStream.close();
        }
        return l3;
    }

    private long installDir(File file, File file2, ProgressInterface progressInterface, long l, long l2, long l3, boolean bl) throws IOException, UserCanceledException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (this.abort) {
                    throw new UserCanceledException();
                }
                File file3 = fileArray[i];
                progressInterface.setDetailMessage(this.cleanupName(file3.getName()));
                File file4 = new File(file2, file3.getName());
                if (file3.isDirectory()) {
                    this.fileInstaller.createDirectory(file4, bl);
                    l3 = this.installDir(file3, file4, progressInterface, l, l2, l3, bl);
                    l3 += l;
                } else {
                    long l4 = l3 + l + file3.length();
                    FileOptions fileOptions = new FileOptions();
                    fileOptions.setDontUninstall(bl);
                    fileOptions.setFileTime(file3.lastModified());
                    this.fileInstaller.install(file3, file4, fileOptions, new ProgressAdapter(progressInterface, (int)(l3 * 100L / l2), (int)(l4 * 100L / l2)));
                    l3 = l4;
                }
                progressInterface.setPercentCompleted((int)(l3 * 100L / l2));
            }
        }
        return l3;
    }

    private long installContent(File file, ProgressInterface progressInterface, InstallationHandler installationHandler, File file2, long l, long l2, long l3) throws IOException, UserCanceledException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            FileOptions fileOptions;
            File file3;
            if (this.abort) {
                throw new UserCanceledException();
            }
            ZipEntry zipEntry2 = null;
            if (enumeration.hasMoreElements()) {
                zipEntry2 = enumeration.nextElement();
            }
            String string = zipEntry.getName();
            string = InstallerUtil.isWindows() ? string.replace('/', '\\') : string.replace('\\', '/');
            progressInterface.setDetailMessage(this.cleanupName(string));
            boolean bl = ComponentConfig.isIncludedInSelectedComponents(string);
            File file4 = file2;
            if (bl && installationHandler != null && (bl = installationHandler.shouldInstall(file3 = new File(string)))) {
                file4 = installationHandler.getInstallationDirectory(file2, file3);
            }
            file3 = new File(file4, string);
            long l4 = l3 + l;
            if (zipEntry.isDirectory()) {
                if (bl) {
                    this.fileInstaller.createDirectory(file3);
                    file3.setLastModified(zipEntry.getTime());
                    fileOptions = InstallerConfig.getCurrentInstance().getOptions(string);
                    if (fileOptions != null && !InstallerUtil.isWindows()) {
                        UnixFileSystem.setMode(fileOptions.getMode(), file3);
                    }
                }
            } else {
                if (zipEntry2 != null) {
                    l4 += zipEntry2.getSize();
                }
                if ((fileOptions = InstallerConfig.getCurrentInstance().getOptions(string)) == null) {
                    fileOptions = new FileOptions();
                }
                fileOptions.setFileTime(zipEntry.getTime());
                if (bl) {
                    this.fileInstaller.install(zipInputStream, file3, fileOptions, new ProgressAdapter(progressInterface, (int)(l3 * 100L / l2), (int)(l4 * 100L / l2)), zipEntry.getSize());
                }
            }
            l3 = l4;
            progressInterface.setPercentCompleted((int)(l3 * 100L / l2));
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        return l3;
    }

    private String cleanupName(String string) {
        if (string.endsWith("//") || string.endsWith("\\\\")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static int countFilesAndDirs(File file) {
        int n = 0;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                ++n;
                if (!file2.isDirectory()) continue;
                n += Installer.countFilesAndDirs(file2);
            }
        }
        return n;
    }

    private static long countSize(File file) {
        long l = 0L;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    l += Installer.countSize(file2);
                    continue;
                }
                l += file2.length();
            }
        }
        return l;
    }

    private void createRuntimeDirectory(File file) throws IOException, UserCanceledException {
        File file2 = new File(System.getProperty("user.dir"));
        File file3 = InstallerUtil.isMacOS() && !DEBUG ? new File(".install4j") : file2;
        File file4 = new File(file3, "i4jruntime.jar");
        File file5 = Installer.getRuntimeDir(file);
        File file6 = new File(file5, "i4jruntime.jar");
        this.fileInstaller.createDirectory(file5);
        this.fileInstaller.install(file4, file6);
        if (InstallerConfig.getCurrentInstance().getInstallerType() == 1) {
            this.fileInstaller.install(new File(file2, "MessagesDefault"), new File(file5, "MessagesDefault"));
            this.fileInstaller.install(new File(file2, "i4jparams.conf"), new File(file5, "i4jparams.conf"));
            this.installIfExists("user.jar", file2, file5);
            this.installIfExists("Messages", file2, file5);
            this.installIfExists("header.png", file2, file5);
            this.installIfExists("welcome.png", file2, file5);
            this.installIfExists("finished.png", file2, file5);
        }
        File[] fileArray = new File(System.getProperty("user.dir")).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file7 = fileArray[i];
            String string = file7.getName().toLowerCase();
            if (!string.endsWith(".dll") && !string.endsWith(".exe")) continue;
            this.fileInstaller.install(file7, new File(file5, file7.getName()));
        }
    }

    private void installIfExists(String string, File file, File file2) throws UserCanceledException {
        File file3 = new File(file, string);
        if (file3.exists()) {
            this.fileInstaller.install(file3, new File(file2, string));
        }
    }

    public static File getRuntimeDir(File file) {
        File file2 = InstallerUtil.isMacOS() ? new File(new File(file, InstallerConfig.getCurrentInstance().getMacSpecificConfig().getRuntimeDirParent()), ".install4j") : new File(file, ".install4j");
        return file2;
    }

    private void cleanup(ProgressInterface progressInterface) {
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusRunProgram"));
        progressInterface.setPercentCompleted(0);
        progressInterface.setDetailMessage(" ");
        this.fileInstaller.cleanup(progressInterface);
    }

    public void launchApplication() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        try {
            if (!installerConfig.getLaunchExecutable().trim().equals("")) {
                File file = new File(this.installationDirectory, installerConfig.getLaunchExecutable());
                if (InstallerUtil.isWindows() || InstallerUtil.isMacOS()) {
                    String[] stringArray = new String[]{file.getAbsolutePath()};
                    Runtime.getRuntime().exec(stringArray, null, this.installationDirectory);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    public boolean checkJavaVersion() {
        if (InstallerUtil.isMacOS()) {
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            String string = installerConfig.getMinJavaVersion();
            if (string.trim().equals("")) {
                return true;
            }
            if (System.getProperty("java.version").compareTo(string) >= 0) {
                return true;
            }
            String string2 = MessageFormat.format(Messages.getMessages().getString("AppleJavaMinVersionError"), installerConfig.getMinJavaVersion(), installerConfig.getApplicationName());
            GUIHelper.showMessage(null, string2, 0);
            return false;
        }
        return true;
    }

    public InstallerFrontend getInstallerFrontend() {
        return this.installerFrontend;
    }

    public static void main(String[] stringArray) {
        Installer installer = null;
        try {
            installer = Installer.getInstance();
            if (WinDel.SEMAPHORE_NAME != null) {
                WinDel.scheduleRecursive(new File(System.getProperty("user.dir")));
            }
            installer = Installer.getInstance();
            installer.run(stringArray);
            if (installer.quiet) {
                System.exit(0);
            }
        }
        catch (Throwable throwable) {
            Installer.reportExeption(throwable, installer == null ? false : installer.quiet);
            System.exit(1);
        }
    }

    private void registerStarted() {
        if (InstallerUtil.isWindows()) {
            Registry.setValue(2, REGKEY_EXE4J, REGVAL_INSTALL_STARTED, new Integer(0));
        }
    }

    private void run(String[] stringArray) {
        try {
            this.setArgs(stringArray);
            if (this.checkJavaVersion() && Common.checkAdmin()) {
                if (!InstallerConfig.getCurrentInstance().isAllowUnattended()) {
                    this.quiet = false;
                }
                if (this.quiet) {
                    this.registerStarted();
                    GUIHelper.setQuiet(true);
                    if (this.quietInstallDir == null) {
                        this.quietInstallDir = this.getDefaultDirectory();
                    }
                    QuietProgressInterface quietProgressInterface = new QuietProgressInterface(this.quietOverwrite);
                    this.installerFrontend = new QuietInstallerFrontend(quietProgressInterface);
                    if (this.checkStartupHandler()) {
                        DirectoryValidator directoryValidator = this.getDirectoryValidator();
                        if (!Installer.validateInstallationDirectory(this.quietInstallDir, directoryValidator, null)) {
                            System.exit(1);
                        }
                        File file = directoryValidator != null ? directoryValidator.getInstallationDirectory(this.quietInstallDir, this.getDefaultDirectory().getName()) : this.quietInstallDir;
                        if (!InstallerUtil.checkWritable(this.quietInstallDir, null)) {
                            System.exit(1);
                        }
                        this.install(file, this.quietInstallDir);
                        this.checkReboot();
                    }
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GUIHelper.setSystemLaF();
                            boolean bl = Installer.this.initWizard(true);
                            if (!bl) {
                                GUIHelper.setJavaLaF();
                                Installer.this.initWizard(false);
                            }
                        }
                    });
                }
            } else {
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            this.reportExeption(throwable);
            System.exit(1);
        }
    }

    private boolean initWizard(boolean bl) {
        try {
            this.registerStarted();
            InstallerWizard installerWizard = new InstallerWizard(Installer.getInstance());
            this.installerFrontend = installerWizard;
            Installer.checkSudo();
            if (this.checkStartupHandler()) {
                installerWizard.showFrame();
            } else {
                System.exit(1);
            }
        }
        catch (NullPointerException nullPointerException) {
            if (!bl) {
                this.reportExeption(nullPointerException);
                System.exit(1);
            }
            return false;
        }
        catch (Throwable throwable) {
            this.reportExeption(throwable);
            System.exit(1);
        }
        return true;
    }

    public static void checkSudo() {
        if (InstallerUtil.isMacOS() && InstallerConfig.getCurrentInstance().getServices().size() > 0) {
            FileResourceBundle fileResourceBundle;
            String string = System.getProperty(MAC_SPEC_PROPERTY_NAME);
            if (string != null) {
                try {
                    if (SudoExecution.checkScrambledPassword(string)) {
                        return;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (PasswordDialog.getPassword(null, (fileResourceBundle = Messages.getMessages()).getString("EnterPassword"), fileResourceBundle.getString("AdminGroupRequired"), fileResourceBundle.getString("EnterPasswordTitle"), new PasswordDialog.InputTextValidator(){

                public boolean isValidInputText(String string, PasswordDialog passwordDialog) {
                    try {
                        if (!SudoExecution.checkPassword(string)) {
                            GUIHelper.showMessage(passwordDialog, fileResourceBundle.getString("WrongPassword"), 0);
                            return false;
                        }
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                    return true;
                }
            }) == null) {
                System.exit(1);
            }
        }
    }

    private void setArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-q")) {
                this.quiet = true;
                continue;
            }
            if (string.equals("-overwrite")) {
                this.quietOverwrite = true;
                continue;
            }
            if (string.equals("-dir") && i + 1 < stringArray.length) {
                this.quietInstallDir = new File(stringArray[++i]);
                continue;
            }
            InstallerUtil.checkPropertyPassOn(string);
        }
    }

    private boolean checkStartupHandler() {
        try {
            StartupHandler startupHandler = null;
            Object object = InstallerUtil.instantiateClass(InstallerConfig.getCurrentInstance().getInitHandlerClass(), "startup handler", null);
            if (object != null) {
                if (object instanceof InitHandler) {
                    startupHandler = new InitHandlerWrapper((InitHandler)object);
                } else if (object instanceof StartupHandler) {
                    startupHandler = (StartupHandler)object;
                }
            }
            if (startupHandler != null) {
                boolean bl = startupHandler.prepareInstaller(this.installerFrontend.getInstallerContext());
                if (bl) {
                    this.overridingDefaultDirectory = startupHandler.getDefaultInstallationDirectory();
                }
                return bl;
            }
        }
        catch (Exception exception) {
            GUIHelper.showMessage(null, exception.getMessage(), 0);
            System.exit(1);
        }
        return true;
    }

    public void checkReboot() {
        if (this.isRebootAfterFinish()) {
            if (this.quiet) {
                Misc.reboot();
            } else {
                FileResourceBundle fileResourceBundle = Messages.getMessages();
                int n = GUIHelper.showOptionDialog(null, MessageFormat.format(fileResourceBundle.getString("FinishedRestartMessage"), InstallerConfig.getCurrentInstance().getApplicationName()), new String[]{fileResourceBundle.getString("ButtonYes"), fileResourceBundle.getString("ButtonNo")}, 3);
                if (n == 0) {
                    Misc.reboot();
                }
            }
        }
    }

    public File getDefaultDirectory() {
        int n;
        int n2;
        String string;
        if (this.overridingDefaultDirectory != null) {
            return this.overridingDefaultDirectory;
        }
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (InstallerUtil.isWindows() && installerConfig.isSuggestPreviousLocations() && (string = InstallRegistry.getInstallationDir(installerConfig.getTargetApplicationId())) != null && string.trim().length() > 0) {
            return new File(string);
        }
        string = installerConfig.getDefaultInstallationDirectory();
        if (string.startsWith("~")) {
            string = System.getProperty("user.home") + string.substring(1);
        }
        while ((n2 = string.indexOf(123)) > -1 && (n = string.indexOf(125, n2)) >= 0) {
            String string2 = string.substring(n2, n + 1);
            string = string.substring(0, n2) + Installer.getVariableValue(string2) + string.substring(n + 1);
        }
        return new File(string);
    }

    private static String getVariableValue(String string) {
        if (string.equals("{/}")) {
            return File.separator;
        }
        if (string.equals("{appdir}")) {
            return InstallerUtil.getStandardApplicationsDirectory();
        }
        return "";
    }

    public void reportExeption(Throwable throwable) {
        Installer.reportExeption(throwable, this.quiet);
    }

    public boolean isRebootAfterFinish() {
        return InstallerUtil.isWindows() && (InstallerConfig.getCurrentInstance().getWindowsSpecificConfig().isRebootInstaller() || ((ContextImpl)((Object)this.installerFrontend.getInstallerContext())).isRebootAfterFinish());
    }

    public static void reportExeption(Throwable throwable, boolean bl) {
        if (DEBUG) {
            throwable.printStackTrace();
        } else {
            Object object;
            File file = null;
            try {
                file = File.createTempFile("install4jError", "log");
                object = new PrintWriter(new FileOutputStream(file));
                ((PrintWriter)object).println("Exception:");
                ((PrintWriter)object).println();
                throwable.printStackTrace((PrintWriter)object);
                ((PrintWriter)object).println();
                ((PrintWriter)object).println("System properties:");
                ((PrintWriter)object).println();
                Iterator<Map.Entry<Object, Object>> iterator = System.getProperties().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = iterator.next();
                    ((PrintWriter)object).print(entry.getKey());
                    ((PrintWriter)object).print("=");
                    ((PrintWriter)object).println(entry.getValue());
                }
                ((PrintWriter)object).flush();
                ((PrintWriter)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object = "An error occurred:\n" + throwable + "\nError log: " + (file == null ? "" : file.getPath());
            if (bl) {
                System.err.println((String)object);
                throwable.printStackTrace();
            } else if (throwable instanceof InternalError && throwable.getMessage().indexOf("X11") > 0) {
                System.err.println("This installer needs access to an X Server.");
                if (InstallerConfig.getCurrentInstance().isAllowUnattended()) {
                    System.err.println("If this is not possible, you can run the installer in unattended mode");
                    System.err.println("by passing the argument -q to the installer.");
                }
            } else {
                JOptionPane.showMessageDialog(null, object, "install4j", 0);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class InitHandlerWrapper
    extends StartupHandler {
        private InitHandler initHandler;

        public InitHandlerWrapper(InitHandler initHandler) {
            this.initHandler = initHandler;
        }

        public boolean prepareInstaller(InstallerContext installerContext) {
            this.initHandler.setInstallerContext(installerContext);
            return this.initHandler.installerCanRun(installerContext.isUnattended());
        }

        public File getDefaultInstallationDirectory() {
            return this.initHandler.getDefaultInstallationDirectory();
        }
    }
}

