/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.SQLException;
import org.postgresql.core.CachedQuery;
import org.postgresql.core.JdbcCallParseInfo;
import org.postgresql.core.Parser;
import org.postgresql.core.Query;
import org.postgresql.jdbc2.AbstractJdbc2Connection;
import org.postgresql.jdbc2.AbstractJdbc2Statement;
import org.postgresql.jdbc2.CallableQueryKey;
import org.postgresql.util.LruCache;

class CachedQueryCreateAction
implements LruCache.CreateAction<Object, CachedQuery> {
    private final int serverVersionNum;
    private final AbstractJdbc2Connection connection;

    public CachedQueryCreateAction(AbstractJdbc2Connection connection, int serverVersionNum) {
        this.connection = connection;
        this.serverVersionNum = serverVersionNum;
    }

    @Override
    public CachedQuery create(Object key) throws SQLException {
        boolean outParmBeforeFunc;
        boolean isFunction;
        String sql = key == null ? null : key.toString();
        String parsedSql = AbstractJdbc2Statement.replaceProcessing(sql, true, this.connection.getStandardConformingStrings());
        if (key instanceof CallableQueryKey) {
            JdbcCallParseInfo callInfo = Parser.modifyJdbcCall(parsedSql, this.connection.getStandardConformingStrings(), this.serverVersionNum, this.connection.getProtocolVersion());
            parsedSql = callInfo.getSql();
            isFunction = callInfo.isFunction();
            outParmBeforeFunc = callInfo.isOutParmBeforeFunc();
        } else {
            isFunction = false;
            outParmBeforeFunc = false;
        }
        Query query = this.connection.getQueryExecutor().createParameterizedQuery(parsedSql);
        return new CachedQuery(key, query, isFunction, outParmBeforeFunc);
    }
}

