/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.bootstrap;

import java.net.SocketAddress;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineException;

public class ClientBootstrap
extends Bootstrap {
    public ClientBootstrap() {
    }

    public ClientBootstrap(ChannelFactory channelFactory) {
        super(channelFactory);
    }

    public ChannelFuture connect() {
        SocketAddress remoteAddress = (SocketAddress)this.getOption("remoteAddress");
        if (remoteAddress == null) {
            throw new IllegalStateException("remoteAddress option is not set.");
        }
        return this.connect(remoteAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        SocketAddress localAddress = (SocketAddress)this.getOption("localAddress");
        return this.connect(remoteAddress, localAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        ChannelPipeline pipeline;
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        try {
            pipeline = this.getPipelineFactory().getPipeline();
        }
        catch (Exception e) {
            throw new ChannelPipelineException("Failed to initialize a pipeline.", e);
        }
        Channel ch = this.getFactory().newChannel(pipeline);
        boolean success = false;
        try {
            ch.getConfig().setOptions(this.getOptions());
            success = true;
        }
        finally {
            if (!success) {
                ch.close();
            }
        }
        if (localAddress != null) {
            ch.bind(localAddress);
        }
        return ch.connect(remoteAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture bind(SocketAddress localAddress) {
        ChannelPipeline pipeline;
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        try {
            pipeline = this.getPipelineFactory().getPipeline();
        }
        catch (Exception e) {
            throw new ChannelPipelineException("Failed to initialize a pipeline.", e);
        }
        Channel ch = this.getFactory().newChannel(pipeline);
        boolean success = false;
        try {
            ch.getConfig().setOptions(this.getOptions());
            success = true;
        }
        finally {
            if (!success) {
                ch.close();
            }
        }
        return ch.bind(localAddress);
    }
}

