/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.lexicon.Lexicon;
import java.util.ArrayList;

public class Segmenter
implements UtteranceProcessor {
    private static final String STRESS = "1";
    private static final String NO_STRESS = "0";

    @Override
    public void processUtterance(Utterance utterance) throws ProcessException {
        if (utterance.getRelation("Word") == null) {
            throw new IllegalStateException("Word relation has not been set");
        }
        if (utterance.getRelation("Syllable") != null) {
            throw new IllegalStateException("Syllable relation has already been set");
        }
        if (utterance.getRelation("SylStructure") != null) {
            throw new IllegalStateException("SylStructure relation has already been set");
        }
        if (utterance.getRelation("Segment") != null) {
            throw new IllegalStateException("Segment relation has already been set");
        }
        String stress = NO_STRESS;
        Relation syl = utterance.createRelation("Syllable");
        Relation sylstructure = utterance.createRelation("SylStructure");
        Relation seg = utterance.createRelation("Segment");
        Lexicon lex = utterance.getVoice().getLexicon();
        ArrayList<String> syllableList = null;
        for (Item word = utterance.getRelation("Word").getHead(); word != null; word = word.getNext()) {
            Item ssword = sylstructure.appendItem(word);
            Item sylItem = null;
            Item segItem = null;
            Item sssyl = null;
            String[] phones = null;
            Item token = word.getItemAs("Token");
            FeatureSet featureSet = null;
            if (token != null) {
                Item parent = token.getParent();
                featureSet = parent.getFeatures();
            }
            phones = featureSet != null && featureSet.isPresent("phones") ? (String[])featureSet.getObject("phones") : lex.getPhones(word.toString(), null);
            for (int j = 0; j < phones.length; ++j) {
                if (sylItem == null) {
                    sylItem = syl.appendItem();
                    sssyl = ssword.addDaughter(sylItem);
                    stress = NO_STRESS;
                    syllableList = new ArrayList<String>();
                }
                segItem = seg.appendItem();
                if (this.isStressed(phones[j])) {
                    stress = STRESS;
                    phones[j] = this.deStress(phones[j]);
                }
                segItem.getFeatures().setString("name", phones[j]);
                sssyl.addDaughter(segItem);
                syllableList.add(phones[j]);
                if (!lex.isSyllableBoundary(syllableList, phones, j + 1)) continue;
                sylItem = null;
                if (sssyl == null) continue;
                sssyl.getFeatures().setString("stress", stress);
            }
        }
    }

    protected boolean isStressed(String phone) {
        return phone.endsWith(STRESS);
    }

    protected String deStress(String phone) {
        String retPhone = phone;
        if (this.isStressed(phone)) {
            retPhone = phone.substring(0, phone.length() - 1);
        }
        return retPhone;
    }

    public String toString() {
        return "Segmenter";
    }
}

