/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.xml;

import com.voxeo.utils.Closer;
import com.voxeo.xml.StaxReaderCallbackHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxTemplate {
    public <K> K read(File input, StaxReaderCallbackHandler<K> handler) {
        K k;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(input);
            k = this.read(fis, handler);
        }
        catch (FileNotFoundException e) {
            try {
                throw new IllegalStateException("Input file does not exist", e);
            }
            catch (Throwable throwable) {
                Closer.close(fis);
                throw throwable;
            }
        }
        Closer.close(fis);
        return k;
    }

    public <K> K read(InputStream input, StaxReaderCallbackHandler<K> handler) {
        K k;
        XMLStreamReader reader = null;
        try {
            XMLInputFactory xmlif = XMLInputFactory.newInstance();
            xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            reader = xmlif.createXMLStreamReader(input);
            k = handler.processReader(reader);
        }
        catch (XMLStreamException e) {
            try {
                throw new IllegalStateException("Failed to process XML document", e);
            }
            catch (Throwable throwable) {
                Closer.close(reader);
                throw throwable;
            }
        }
        Closer.close(reader);
        return k;
    }

    public <K> K read(Reader input, StaxReaderCallbackHandler<K> handler) {
        K k;
        XMLStreamReader reader = null;
        try {
            XMLInputFactory xmlif = XMLInputFactory.newInstance();
            xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            reader = xmlif.createXMLStreamReader(input);
            k = handler.processReader(reader);
        }
        catch (XMLStreamException e) {
            try {
                throw new IllegalStateException("Failed to process XML document", e);
            }
            catch (Throwable throwable) {
                Closer.close(reader);
                throw throwable;
            }
        }
        Closer.close(reader);
        return k;
    }

    public static void main(String[] args) {
        new StaxTemplate().read(new StringReader(""), new StaxReaderCallbackHandler<String>(){

            @Override
            public String processReader(XMLStreamReader reader) throws XMLStreamException {
                return null;
            }
        });
    }
}

