/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.web.assets;

import com.voxeo.logging.Loggerf;
import com.voxeo.utils.Closer;
import com.voxeo.utils.Enums;
import com.voxeo.utils.HTTP;
import com.voxeo.utils.Objects;
import com.voxeo.utils.Props;
import com.voxeo.web.CacheMode;
import com.voxeo.web.InvalidScriptException;
import com.voxeo.web.ResourceCompressor;
import com.voxeo.web.assets.Asset;
import com.voxeo.web.assets.PatternAsset;
import com.voxeo.web.assets.VirtualAsset;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.joda.time.Duration;

public class AssetFilter
implements Filter {
    private static final Loggerf log = Loggerf.getLogger(AssetFilter.class);
    private static final String CONFIG_PARAM = "configResource";
    private static final String CONFIG_SYSTEM = "com.voxeo.web.assets.configResource";
    private static final String ENABLE_CACHE_PARAM = "cacheEnabled";
    private static final String ENABLE_CACHE_SYSTEM = "com.voxeo.web.assets.cacheEnabled";
    private String version;
    private String versionPrefix;
    private String versionAttribute;
    private String configResource;
    private ResourceCompressor resourceCompressor;
    private List<Asset> assets = new ArrayList<Asset>();
    private boolean cacheEnabled;
    private Map<String, byte[]> resourceCache = new ConcurrentHashMap<String, byte[]>();

    public void init(FilterConfig config) throws ServletException {
        Document document;
        this.resourceCompressor = new ResourceCompressor();
        this.configResource = System.getProperty(CONFIG_SYSTEM, config.getInitParameter(CONFIG_PARAM));
        ServletContext servletContext = config.getServletContext();
        InputStream configStream = servletContext.getResourceAsStream(this.configResource);
        SAXReader reader = new SAXReader();
        try {
            document = reader.read(configStream);
        }
        catch (DocumentException e) {
            throw new IllegalStateException(e);
        }
        Element rootElement = document.getRootElement();
        this.version = rootElement.attributeValue("version");
        this.versionPrefix = "/" + this.version;
        List virtualElements = rootElement.elements("virtual");
        for (Element virtualElement : virtualElements) {
            ArrayList<String> realPaths = new ArrayList<String>();
            List paths = virtualElement.elements("path");
            for (Element pathElement : paths) {
                realPaths.add(pathElement.attributeValue("value"));
            }
            String virtualPath = virtualElement.attributeValue("path");
            VirtualAsset asset = new VirtualAsset(servletContext, virtualPath, realPaths);
            this.configureAsset(asset, virtualElement);
            this.assets.add(asset);
        }
        List patternElements = rootElement.elements("pattern");
        for (Element patternElement : patternElements) {
            String patternValue = patternElement.attributeValue("value");
            PatternAsset asset = new PatternAsset(servletContext, patternValue);
            this.configureAsset(asset, patternElement);
            this.assets.add(asset);
        }
        this.cacheEnabled = Props.getBooleanSystemProperty(ENABLE_CACHE_SYSTEM, config.getInitParameter(ENABLE_CACHE_PARAM));
        this.versionAttribute = Objects.isNull(config.getInitParameter("versionAttribute"), "version");
    }

    private void configureAsset(Asset asset, Element virtualElement) {
        asset.setMinify("true".equals(virtualElement.attributeValue("minify")));
        asset.setRequiresVersion("true".equals(virtualElement.attributeValue("requiresVersion")));
        asset.setCacheMode(Enums.valueOf(CacheMode.class, virtualElement.attributeValue("cacheMode"), CacheMode.FOREVER));
        String expires = virtualElement.attributeValue("expires");
        if (expires != null) {
            asset.setCacheExpiration(new Duration(Long.parseLong(expires) * 60000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        InputStream resourceStream;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        request.setAttribute(this.versionAttribute, (Object)this.version);
        String resourcePath = httpRequest.getServletPath();
        String realPath = resourcePath.replace(this.versionPrefix, "");
        Asset asset = this.findAsset(realPath);
        if (asset == null || !this.shouldProcess(resourcePath, asset)) {
            chain.doFilter(request, response);
            return;
        }
        Duration cacheExpiration = asset.getCacheExpiration();
        this.applyMimeType(httpResponse, realPath);
        if (!httpResponse.containsHeader("Expires")) {
            HTTP.setExpireHeaders(httpResponse, cacheExpiration.getMillis());
        }
        if (this.cacheEnabled && this.resourceCache.containsKey(realPath)) {
            httpResponse.getOutputStream().write(this.resourceCache.get(realPath));
            return;
        }
        boolean responseCommitted = false;
        if (asset.isMinify() && this.resourceCompressor.handles(realPath) && (resourceStream = asset.getInputStream(realPath)) != null) {
            try {
                String compressedResource = this.resourceCompressor.minify(realPath, resourceStream);
                response.setContentLength(compressedResource.length());
                ServletOutputStream outputStream = response.getOutputStream();
                outputStream.print(compressedResource);
                if (this.cacheEnabled) {
                    this.resourceCache.put(realPath, compressedResource.getBytes());
                }
                responseCommitted = true;
            }
            catch (InvalidScriptException e) {
                log.error("Resource is invalid %s", realPath, e);
            }
            finally {
                Closer.close(resourceStream);
            }
        }
        if (!responseCommitted) {
            if (asset.isReal()) {
                RequestDispatcher dispatcher = request.getRequestDispatcher(realPath);
                dispatcher.forward(request, response);
                return;
            }
            ServletOutputStream servletStream = response.getOutputStream();
            InputStream assetStream = null;
            try {
                assetStream = asset.getInputStream(realPath);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)assetStream, (OutputStream)baos);
                byte[] resourceBytes = baos.toByteArray();
                response.setContentLength(resourceBytes.length);
                servletStream.write(resourceBytes);
                if (this.cacheEnabled) {
                    this.resourceCache.put(realPath, resourceBytes);
                }
            }
            finally {
                Closer.close(assetStream);
            }
        }
    }

    private void applyMimeType(HttpServletResponse httpResponse, String realPath) {
        if (realPath.endsWith(".css")) {
            httpResponse.setContentType("text/css");
        } else if (realPath.endsWith(".js")) {
            httpResponse.setContentType("text/javascript");
        }
    }

    private boolean shouldProcess(String resourcePath, Asset asset) {
        return !asset.isRequiresVersion() || asset.isRequiresVersion() && resourcePath.contains(this.versionPrefix);
    }

    private Asset findAsset(String path) {
        for (Asset asset : this.assets) {
            if (!asset.handles(path)) continue;
            return asset;
        }
        return null;
    }

    public void destroy() {
    }
}

