/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.web;

import com.voxeo.logging.Loggerf;
import com.voxeo.utils.EventDispatcher;
import com.voxeo.utils.EventListener;
import com.voxeo.utils.NamingThreadFactory;
import com.voxeo.web.AppStatus;
import com.voxeo.web.AppStatusEvent;
import com.voxeo.web.IAppStatusWatcher;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipmethodAppStatusWatcher
implements IAppStatusWatcher {
    private final Loggerf log = Loggerf.getLogger(SipmethodAppStatusWatcher.class);
    private final AppStatusEvent startedEvent = new AppStatusEvent(this, AppStatus.STARTED);
    private final AppStatusEvent stoppedEvent = new AppStatusEvent(this, AppStatus.STOPPED);
    private long sleepMS = 100L;
    private String applicationName;
    private ScheduledExecutorService executor;
    private EventDispatcher dispatcher = new EventDispatcher();
    private volatile boolean started = false;

    @PostConstruct
    public void init() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor(new NamingThreadFactory("App Status Watcher {%s}", this.applicationName));
        }
        this.executor.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                if (SipmethodAppStatusWatcher.this.started && !SipmethodAppStatusWatcher.this.isAppStarted()) {
                    SipmethodAppStatusWatcher.this.started = false;
                    SipmethodAppStatusWatcher.this.fire();
                } else if (!SipmethodAppStatusWatcher.this.started && SipmethodAppStatusWatcher.this.isAppStarted()) {
                    SipmethodAppStatusWatcher.this.started = true;
                    SipmethodAppStatusWatcher.this.fire();
                }
            }
        }, 0L, this.sleepMS, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Override
    public AppStatus getStatus() {
        return this.started ? AppStatus.STARTED : AppStatus.STOPPED;
    }

    private boolean isAppStarted() {
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("com.micromethod.sipmethod:type=server.module.container.application,name=" + this.applicationName);
            Object attribute = mbeanServer.getAttribute(objectName, "State");
            return attribute != null && "STARTED".equals(attribute.toString());
        }
        catch (Exception e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Error statting web app %s", this.applicationName, e);
            } else {
                this.log.debug("Error statting web app %s", this.applicationName);
            }
            return false;
        }
    }

    private void fire() {
        this.dispatcher.fire(this.started ? this.startedEvent : this.stoppedEvent);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public void addListener(EventListener<AppStatusEvent> listener) {
        this.dispatcher.addListener(AppStatusEvent.class, listener);
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public void setSleepMillseconds(long sleepMS) {
        this.sleepMS = sleepMS;
    }
}

