/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.web;

import com.voxeo.logging.Loggerf;
import com.voxeo.utils.Lists;
import com.voxeo.utils.Maps;
import com.voxeo.utils.Strings;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class FileExtensionHeaderFilter
implements Filter {
    private final Loggerf log = Loggerf.getLogger(FileExtensionHeaderFilter.class);
    static final String ACCEPT = "Accept";
    static final String CONTENT_TYPE = "Content-type";
    private Map<String, String> contentTypes = Maps.make(new String[0]);

    public void init(FilterConfig config) throws ServletException {
        Enumeration extensionEnumerator = config.getInitParameterNames();
        while (extensionEnumerator.hasMoreElements()) {
            String extension = (String)extensionEnumerator.nextElement();
            String contentType = config.getInitParameter(extension);
            this.contentTypes.put("." + extension, contentType);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object request = (HttpServletRequest)servletRequest;
        String path = request.getPathInfo();
        if (!Strings.isEmpty(path)) {
            for (Map.Entry<String, String> entry : this.contentTypes.entrySet()) {
                String extension = entry.getKey();
                String accepts = entry.getValue();
                if (!path.endsWith(extension)) continue;
                this.log.debug("path ends with extension %s, coercing content type to %s", extension, accepts);
                request = new RequestWrapper((HttpServletRequest)request, extension, accepts);
                break;
            }
        }
        chain.doFilter((ServletRequest)request, response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RequestWrapper
    extends HttpServletRequestWrapper {
        private final Map<String, List<String>> headers;
        private final String extension;
        private final String servletPath;

        public RequestWrapper(HttpServletRequest request, String extension, String accepts) {
            super(request);
            this.headers = Maps.make(new String[0]);
            this.extension = extension;
            int contentLength = request.getContentLength();
            this.servletPath = request.getServletPath();
            Enumeration headerEnumerator = request.getHeaderNames();
            while (headerEnumerator.hasMoreElements()) {
                String headerName = (String)headerEnumerator.nextElement();
                if (FileExtensionHeaderFilter.ACCEPT.equals(headerName) || contentLength > 0 && FileExtensionHeaderFilter.CONTENT_TYPE.equals(headerName)) continue;
                List values = Lists.make(new Object[0]);
                this.headers.put(headerName, values);
                Enumeration valueEnumerator = request.getHeaders(headerName);
                while (valueEnumerator.hasMoreElements()) {
                    String headerValue = (String)valueEnumerator.nextElement();
                    values.add(headerValue);
                }
            }
            List list = Lists.make(accepts);
            this.headers.put(FileExtensionHeaderFilter.ACCEPT, list);
            if (contentLength > 0) {
                this.headers.put(FileExtensionHeaderFilter.CONTENT_TYPE, list);
            }
        }

        public String getHeader(String name) {
            String result = null;
            Enumeration<?> enumeration = this.getHeaders(name);
            if (enumeration.hasMoreElements()) {
                result = (String)enumeration.nextElement();
            }
            return result;
        }

        public Enumeration<?> getHeaderNames() {
            return Collections.enumeration(this.headers.keySet());
        }

        public Enumeration<?> getHeaders(String name) {
            List<String> list = this.headers.get(name);
            if (list == null) {
                list = Lists.make(new Object[0]);
            }
            return Collections.enumeration(list);
        }

        public String getPathInfo() {
            return this.stripExtension(super.getPathInfo());
        }

        public String getPathTranslated() {
            return this.stripExtension(super.getPathTranslated());
        }

        public String getRequestURI() {
            return this.stripExtension(super.getRequestURI());
        }

        public StringBuffer getRequestURL() {
            return new StringBuffer(this.stripExtension(super.getRequestURL()));
        }

        public String getServletPath() {
            return this.stripExtension(this.servletPath);
        }

        private String stripExtension(CharSequence path) {
            String result = ((Object)path).toString();
            if (!Strings.isEmpty(result) && result.endsWith(this.extension)) {
                result = result.substring(0, result.length() - this.extension.length());
            }
            return result;
        }
    }
}

