/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.jms;

import java.io.IOException;
import java.io.InputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;

public class BytesMessageInputStream
extends InputStream {
    private final BytesMessage message;

    public BytesMessageInputStream(BytesMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("BytesMessage is required!");
        }
        this.message = message;
    }

    public int read(byte[] b) throws IOException {
        try {
            return this.message.readBytes(b);
        }
        catch (JMSException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (off == 0) {
            try {
                return this.message.readBytes(b, len);
            }
            catch (JMSException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return super.read(b, off, len);
    }

    public int read() throws IOException {
        try {
            return this.message.readByte();
        }
        catch (MessageEOFException ex) {
            return -1;
        }
        catch (JMSException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

