/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.data;

import com.voxeo.data.Schema;
import com.voxeo.data.Script;
import com.voxeo.logging.Loggerf;
import com.voxeo.utils.Exceptions;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaSetBuilder {
    private static final Loggerf log = Loggerf.getLogger(SchemaSetBuilder.class);

    public static Set<Schema> buildSchemaSet(File scriptDirectory) {
        if (!scriptDirectory.exists() || !scriptDirectory.isDirectory()) {
            SchemaSetBuilder.handleMissingScriptDirectory();
        }
        if (!scriptDirectory.canRead()) {
            SchemaSetBuilder.handleLimitedScriptDirectoryAccess();
        }
        File[] files = scriptDirectory.listFiles();
        HashMap<String, Schema> schemas = new HashMap<String, Schema>();
        for (File file : files) {
            if (!file.isHidden()) {
                Script script = new Script(file);
                Schema schema = (Schema)schemas.get(script.getSchemaName());
                if (schema == null) {
                    schema = new Schema(script.getSchemaName());
                    schemas.put(script.getSchemaName(), schema);
                }
                schema.addScript(script);
                continue;
            }
            log.debug("Skipping hidden file [name=%s]", file.getAbsolutePath());
        }
        for (Schema s : schemas.values()) {
            if (s.isValid()) continue;
            Exceptions.fling(IllegalStateException.class, "Scripts are out of sequence for schema [%s]", s.getName());
        }
        return new HashSet<Schema>(schemas.values());
    }

    public static Schema buildSchema(File scriptDirectory, String name) {
        if (!scriptDirectory.exists() || !scriptDirectory.isDirectory()) {
            SchemaSetBuilder.handleMissingScriptDirectory();
        }
        if (!scriptDirectory.canRead()) {
            SchemaSetBuilder.handleLimitedScriptDirectoryAccess();
        }
        File[] files = scriptDirectory.listFiles();
        Schema schema = null;
        for (File file : files) {
            Script script;
            String schemaName;
            if (file.isHidden() || !name.equalsIgnoreCase(schemaName = (script = new Script(file)).getSchemaName())) continue;
            if (schema == null) {
                schema = new Schema(schemaName);
            }
            schema.addScript(script);
        }
        if (schema != null) {
            if (!schema.isValid()) {
                Exceptions.fling(IllegalStateException.class, "Scripts are out of sequence for schema [%s]", name);
            }
        } else {
            Exceptions.fling(IllegalArgumentException.class, "Could not find schema [name=%s, path=%w]", name, scriptDirectory);
        }
        return schema;
    }

    private static void handleMissingScriptDirectory() {
        throw new IllegalStateException("Script directory does not exist or is not a directory");
    }

    private static void handleLimitedScriptDirectoryAccess() {
        throw new SecurityException("No read access to script directory");
    }

    public static void main(String[] args) {
        for (File file : new File("/Users/jdecastro/Work/Projects/ManagementConsole/1.0/installer/base/data/sql/scripts/").listFiles()) {
            if (!file.isHidden()) continue;
            System.out.println(file.getAbsolutePath());
        }
    }
}

