/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.engine.groups.Group;
import org.hibernate.validator.internal.engine.groups.Sequence;
import org.hibernate.validator.internal.engine.groups.ValidationOrder;
import org.hibernate.validator.internal.engine.groups.ValidationOrderGenerator;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.engine.resolver.SingleThreadCachedTraversableResolver;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ExecutableMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ParameterMetaData;
import org.hibernate.validator.internal.metadata.aggregated.PropertyMetaData;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.facets.Validatable;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;

public class ValidatorImpl
implements Validator,
ExecutableValidator {
    private static final Log log = LoggerFactory.make();
    private static final Class<?>[] DEFAULT_GROUP_ARRAY = new Class[]{Default.class};
    private final transient ValidationOrderGenerator validationOrderGenerator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final BeanMetaDataManager beanMetaDataManager;
    private final ConstraintValidatorManager constraintValidatorManager;
    private final ParameterNameProvider parameterNameProvider;
    private final boolean failFast;

    public ValidatorImpl(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, BeanMetaDataManager beanMetaDataManager, ParameterNameProvider parameterNameProvider, ConstraintValidatorManager constraintValidatorManager, boolean failFast) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.messageInterpolator = messageInterpolator;
        this.traversableResolver = traversableResolver;
        this.beanMetaDataManager = beanMetaDataManager;
        this.parameterNameProvider = parameterNameProvider;
        this.constraintValidatorManager = constraintValidatorManager;
        this.failFast = failFast;
        this.validationOrderGenerator = new ValidationOrderGenerator();
    }

    public final <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> validationContext = this.getValidationContext().forValidate(object);
        ValueContext valueContext = ValueContext.getLocalExecutionContext(object, this.beanMetaDataManager.getBeanMetaData(object.getClass()), PathImpl.createRootPath());
        return this.validateInContext(valueContext, validationContext, validationOrder);
    }

    public final <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        this.sanityCheckPropertyPath(propertyName);
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> context = this.getValidationContext().forValidateProperty(object);
        return this.validatePropertyInContext(context, PathImpl.createPathFromString(propertyName), validationOrder);
    }

    public final <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        Contracts.assertNotNull(beanType, Messages.MESSAGES.beanTypeCannotBeNull());
        this.sanityCheckPropertyPath(propertyName);
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> context = this.getValidationContext().forValidateValue(beanType);
        return this.validateValueInContext(context, value, PathImpl.createPathFromString(propertyName), validationOrder);
    }

    public <T> Set<ConstraintViolation<T>> validateParameters(T object, Method method, Object[] parameterValues, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        Contracts.assertNotNull(method, Messages.MESSAGES.validatedMethodMustNotBeNull());
        Contracts.assertNotNull(parameterValues, Messages.MESSAGES.validatedParameterArrayMustNotBeNull());
        return this.validateParameters(object, ExecutableElement.forMethod(method), parameterValues, groups);
    }

    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(Constructor<? extends T> constructor, Object[] parameterValues, Class<?> ... groups) {
        Contracts.assertNotNull(constructor, Messages.MESSAGES.validatedConstructorMustNotBeNull());
        Contracts.assertNotNull(parameterValues, Messages.MESSAGES.validatedParameterArrayMustNotBeNull());
        return this.validateParameters(null, ExecutableElement.forConstructor(constructor), parameterValues, groups);
    }

    public <T> Set<ConstraintViolation<T>> validateConstructorReturnValue(Constructor<? extends T> constructor, T createdObject, Class<?> ... groups) {
        Contracts.assertNotNull(constructor, Messages.MESSAGES.validatedConstructorMustNotBeNull());
        Contracts.assertNotNull(createdObject, Messages.MESSAGES.validatedConstructorCreatedInstanceMustNotBeNull());
        return this.validateReturnValue(null, ExecutableElement.forConstructor(constructor), createdObject, groups);
    }

    public <T> Set<ConstraintViolation<T>> validateReturnValue(T object, Method method, Object returnValue, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        Contracts.assertNotNull(method, Messages.MESSAGES.validatedMethodMustNotBeNull());
        return this.validateReturnValue(object, ExecutableElement.forMethod(method), returnValue, groups);
    }

    private <T> Set<ConstraintViolation<T>> validateParameters(T object, ExecutableElement executable, Object[] parameterValues, Class<?> ... groups) {
        if (parameterValues == null) {
            return Collections.emptySet();
        }
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> context = this.getValidationContext().forValidateParameters(this.parameterNameProvider, object, executable, parameterValues);
        this.validateParametersInContext(context, parameterValues, validationOrder);
        return context.getFailingConstraints();
    }

    private <T> Set<ConstraintViolation<T>> validateReturnValue(T object, ExecutableElement executable, Object returnValue, Class<?> ... groups) {
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> context = this.getValidationContext().forValidateReturnValue(object, executable, returnValue);
        this.validateReturnValueInContext(context, object, returnValue, validationOrder);
        return context.getFailingConstraints();
    }

    public final BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.beanMetaDataManager.getBeanMetaData(clazz).getBeanDescriptor();
    }

    public final <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(Validator.class)) {
            return type.cast(this);
        }
        throw log.getTypeNotSupportedForUnwrappingException(type);
    }

    public ExecutableValidator forExecutables() {
        return this;
    }

    private ValidationContext.ValidationContextBuilder getValidationContext() {
        return ValidationContext.getValidationContext(this.beanMetaDataManager, this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.failFast);
    }

    private void sanityCheckPropertyPath(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw log.getInvalidPropertyPathException();
        }
    }

    private ValidationOrder determineGroupValidationOrder(Class<?>[] groups) {
        Contracts.assertNotNull(groups, Messages.MESSAGES.groupMustNotBeNull());
        for (Class<?> clazz : groups) {
            if (clazz != null) continue;
            throw new IllegalArgumentException(Messages.MESSAGES.groupMustNotBeNull());
        }
        Class<?>[] tmpGroups = groups;
        if (tmpGroups.length == 0) {
            tmpGroups = DEFAULT_GROUP_ARRAY;
        }
        return this.validationOrderGenerator.getValidationOrder(Arrays.asList(tmpGroups));
    }

    private <T, U> Set<ConstraintViolation<T>> validateInContext(ValueContext<U, Object> valueContext, ValidationContext<T> context, ValidationOrder validationOrder) {
        Group group;
        if (valueContext.getCurrentBean() == null) {
            return Collections.emptySet();
        }
        BeanMetaData<U> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean()));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            group = groupIterator.next();
            valueContext.setCurrentGroup(group.getDefiningClass());
            this.validateConstraintsForCurrentGroup(context, valueContext);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            group = groupIterator.next();
            valueContext.setCurrentGroup(group.getDefiningClass());
            this.validateCascadedConstraints(context, valueContext);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block2: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (Group group2 : sequence.getComposingGroups()) {
                int numberOfViolations = context.getFailingConstraints().size();
                valueContext.setCurrentGroup(group2.getDefiningClass());
                this.validateConstraintsForCurrentGroup(context, valueContext);
                if (this.shouldFailFast(context)) {
                    return context.getFailingConstraints();
                }
                this.validateCascadedConstraints(context, valueContext);
                if (this.shouldFailFast(context)) {
                    return context.getFailingConstraints();
                }
                if (context.getFailingConstraints().size() <= numberOfViolations) continue;
                continue block2;
            }
        }
        return context.getFailingConstraints();
    }

    private void validateConstraintsForCurrentGroup(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext) {
        if (!valueContext.validatingDefault()) {
            this.validateConstraintsForNonDefaultGroup(validationContext, valueContext);
        } else {
            this.validateConstraintsForDefaultGroup(validationContext, valueContext);
        }
    }

    private <U> void validateConstraintsForDefaultGroup(ValidationContext<?> validationContext, ValueContext<U, Object> valueContext) {
        BeanMetaData<U> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        HashMap<Class<?>, Class<U>> validatedInterfaces = CollectionHelper.newHashMap();
        for (Class<U> clazz : beanMetaData.getClassHierarchy()) {
            BeanMetaData<U> hostingBeanMetaData = this.beanMetaDataManager.getBeanMetaData(clazz);
            boolean defaultGroupSequenceIsRedefined = hostingBeanMetaData.defaultGroupSequenceIsRedefined();
            List<Class<?>> defaultGroupSequence = hostingBeanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean());
            Set<MetaConstraint<?>> metaConstraints = hostingBeanMetaData.getDirectMetaConstraints();
            if (defaultGroupSequenceIsRedefined) {
                metaConstraints = hostingBeanMetaData.getMetaConstraints();
            }
            PathImpl currentPath = valueContext.getPropertyPath();
            for (Class<?> defaultSequenceMember : defaultGroupSequence) {
                valueContext.setCurrentGroup(defaultSequenceMember);
                boolean validationSuccessful = true;
                for (MetaConstraint<?> metaConstraint : metaConstraints) {
                    Class<?> declaringClass = metaConstraint.getLocation().getBeanClass();
                    if (declaringClass.isInterface()) {
                        Class validatedForClass = (Class)validatedInterfaces.get(declaringClass);
                        if (validatedForClass != null && !validatedForClass.equals(clazz)) continue;
                        validatedInterfaces.put(declaringClass, clazz);
                    }
                    boolean tmp = this.validateConstraint(validationContext, valueContext, metaConstraint);
                    if (this.shouldFailFast(validationContext)) {
                        return;
                    }
                    validationSuccessful = validationSuccessful && tmp;
                    valueContext.setPropertyPath(currentPath);
                }
                if (validationSuccessful) continue;
                break;
            }
            validationContext.markCurrentBeanAsProcessed(valueContext);
            if (!defaultGroupSequenceIsRedefined) continue;
            break;
        }
    }

    private void validateConstraintsForNonDefaultGroup(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext) {
        BeanMetaData<?> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        PathImpl currentPath = valueContext.getPropertyPath();
        for (MetaConstraint<?> metaConstraint : beanMetaData.getMetaConstraints()) {
            this.validateConstraint(validationContext, valueContext, metaConstraint);
            if (this.shouldFailFast(validationContext)) {
                return;
            }
            valueContext.setPropertyPath(currentPath);
        }
        validationContext.markCurrentBeanAsProcessed(valueContext);
    }

    private boolean validateConstraint(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext, MetaConstraint<?> metaConstraint) {
        boolean validationSuccessful = true;
        if (metaConstraint.getElementType() != ElementType.TYPE) {
            valueContext.appendNode(this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType()).getMetaDataFor(ReflectionHelper.getPropertyName(metaConstraint.getLocation().getMember())));
        } else {
            valueContext.appendBeanNode();
        }
        if (this.isValidationRequired(validationContext, valueContext, metaConstraint)) {
            Object valueToValidate = metaConstraint.getValue(valueContext.getCurrentBean());
            valueContext.setCurrentValidatedValue(valueToValidate);
            validationSuccessful = metaConstraint.validateConstraint(validationContext, valueContext);
        }
        return validationSuccessful;
    }

    private void validateCascadedConstraints(ValidationContext<?> validationContext, ValueContext<?, ?> valueContext) {
        Validatable validatable = valueContext.getCurrentValidatable();
        PathImpl originalPath = valueContext.getPropertyPath();
        Class<?> originalGroup = valueContext.getCurrentGroup();
        for (Cascadable cascadable : validatable.getCascadables()) {
            Object value;
            valueContext.appendNode(cascadable);
            Class<?> group = cascadable.convertGroup(originalGroup);
            valueContext.setCurrentGroup(group);
            ElementType elementType = cascadable.getElementType();
            if (this.isCascadeRequired(validationContext, valueContext.getCurrentBean(), valueContext.getPropertyPath(), elementType) && (value = cascadable.getValue(valueContext.getCurrentBean())) != null) {
                Class<?> type = value.getClass();
                Iterator<?> iter = this.createIteratorForCascadedValue(type, value, valueContext);
                boolean isIndexable = this.isIndexable(type);
                ValidationOrder validationOrder = this.validationOrderGenerator.getValidationOrder(group, group != originalGroup);
                this.validateCascadedConstraint(validationContext, iter, isIndexable, valueContext, validationOrder);
                if (this.shouldFailFast(validationContext)) {
                    return;
                }
            }
            valueContext.setPropertyPath(originalPath);
            valueContext.setCurrentGroup(originalGroup);
        }
    }

    private Iterator<?> createIteratorForCascadedValue(Type type, Object value, ValueContext<?, ?> valueContext) {
        Iterator<Object> iter;
        if (ReflectionHelper.isIterable(type)) {
            iter = ((Iterable)value).iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else if (ReflectionHelper.isMap(type)) {
            Map map = (Map)value;
            iter = map.entrySet().iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else if (TypeHelper.isArray(type)) {
            List<Object> arrayList = Arrays.asList((Object[])value);
            iter = arrayList.iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else {
            ArrayList list = CollectionHelper.newArrayList();
            list.add(value);
            iter = list.iterator();
        }
        return iter;
    }

    private boolean isIndexable(Type type) {
        boolean isIndexable = false;
        if (ReflectionHelper.isList(type)) {
            isIndexable = true;
        } else if (ReflectionHelper.isMap(type)) {
            isIndexable = true;
        } else if (TypeHelper.isArray(type)) {
            isIndexable = true;
        }
        return isIndexable;
    }

    private void validateCascadedConstraint(ValidationContext<?> context, Iterator<?> iter, boolean isIndexable, ValueContext<?, ?> valueContext, ValidationOrder validationOrder) {
        int i = 0;
        while (iter.hasNext()) {
            Object value = iter.next();
            if (value instanceof Map.Entry) {
                Object mapKey = ((Map.Entry)value).getKey();
                valueContext.setKey(mapKey);
                value = ((Map.Entry)value).getValue();
            } else if (isIndexable) {
                valueContext.setIndex(i);
            }
            if (!context.isBeanAlreadyValidated(value, valueContext.getCurrentGroup(), valueContext.getPropertyPath())) {
                ValueContext newValueContext = value != null ? ValueContext.getLocalExecutionContext(value, this.beanMetaDataManager.getBeanMetaData(value.getClass()), valueContext.getPropertyPath()) : ValueContext.getLocalExecutionContext(valueContext.getCurrentBeanType(), this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType()), valueContext.getPropertyPath());
                this.validateInContext(newValueContext, context, validationOrder);
                if (this.shouldFailFast(context)) {
                    return;
                }
            }
            ++i;
        }
    }

    private <T> Set<ConstraintViolation<T>> validatePropertyInContext(ValidationContext<T> context, PathImpl propertyPath, ValidationOrder validationOrder) {
        ArrayList<MetaConstraint<?>> metaConstraints = CollectionHelper.newArrayList();
        Iterator<Path.Node> propertyIter = propertyPath.iterator();
        ValueContext valueContext = this.collectMetaConstraintsForPath(context.getRootBeanClass(), context.getRootBean(), propertyIter, propertyPath, metaConstraints);
        if (valueContext.getCurrentBean() == null) {
            throw log.getInvalidPropertyPathException();
        }
        if (metaConstraints.size() == 0) {
            return context.getFailingConstraints();
        }
        this.assertDefaultGroupSequenceIsExpandable(valueContext, validationOrder);
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            valueContext.setCurrentGroup(group.getDefiningClass());
            this.validatePropertyForCurrentGroup(valueContext, context, metaConstraints);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (Group group : sequence.getComposingGroups()) {
                valueContext.setCurrentGroup(group.getDefiningClass());
                int numberOfConstraintViolations = this.validatePropertyForCurrentGroup(valueContext, context, metaConstraints);
                if (this.shouldFailFast(context)) {
                    return context.getFailingConstraints();
                }
                if (numberOfConstraintViolations <= 0) continue;
                continue block1;
            }
        }
        return context.getFailingConstraints();
    }

    private <T> void assertDefaultGroupSequenceIsExpandable(ValueContext<T, ?> valueContext, ValidationOrder validationOrder) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean()));
        }
    }

    private <T> Set<ConstraintViolation<T>> validateValueInContext(ValidationContext<T> context, Object value, PathImpl propertyPath, ValidationOrder validationOrder) {
        ArrayList<MetaConstraint<?>> metaConstraints = CollectionHelper.newArrayList();
        ValueContext<T, Object> valueContext = this.collectMetaConstraintsForPath(context.getRootBeanClass(), null, propertyPath.iterator(), propertyPath, metaConstraints);
        valueContext.setCurrentValidatedValue(value);
        if (metaConstraints.size() == 0) {
            return context.getFailingConstraints();
        }
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(null));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            valueContext.setCurrentGroup(group.getDefiningClass());
            this.validatePropertyForCurrentGroup(valueContext, context, metaConstraints);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (Group group : sequence.getComposingGroups()) {
                valueContext.setCurrentGroup(group.getDefiningClass());
                int numberOfConstraintViolations = this.validatePropertyForCurrentGroup(valueContext, context, metaConstraints);
                if (this.shouldFailFast(context)) {
                    return context.getFailingConstraints();
                }
                if (numberOfConstraintViolations <= 0) continue;
                continue block1;
            }
        }
        return context.getFailingConstraints();
    }

    private int validatePropertyForCurrentGroup(ValueContext<?, Object> valueContext, ValidationContext<?> validationContext, List<MetaConstraint<?>> metaConstraints) {
        if (!valueContext.validatingDefault()) {
            return this.validatePropertyForNonDefaultGroup(valueContext, validationContext, metaConstraints);
        }
        return this.validatePropertyForDefaultGroup(valueContext, validationContext, metaConstraints);
    }

    private int validatePropertyForNonDefaultGroup(ValueContext<?, Object> valueContext, ValidationContext<?> validationContext, List<MetaConstraint<?>> metaConstraints) {
        int numberOfConstraintViolationsBefore = validationContext.getFailingConstraints().size();
        for (MetaConstraint<Object> metaConstraint : metaConstraints) {
            if (!this.isValidationRequired(validationContext, valueContext, metaConstraint)) continue;
            if (valueContext.getCurrentBean() != null) {
                Object valueToValidate = metaConstraint.getValue(valueContext.getCurrentBean());
                valueContext.setCurrentValidatedValue(valueToValidate);
            }
            metaConstraint.validateConstraint(validationContext, valueContext);
            if (!this.shouldFailFast(validationContext)) continue;
            return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
        }
        return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
    }

    private <U> int validatePropertyForDefaultGroup(ValueContext<U, Object> valueContext, ValidationContext<?> validationContext, List<MetaConstraint<?>> constraintList) {
        int numberOfConstraintViolationsBefore = validationContext.getFailingConstraints().size();
        BeanMetaData<U> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        HashMap<Class<?>, Class<U>> validatedInterfaces = CollectionHelper.newHashMap();
        for (Class<U> clazz : beanMetaData.getClassHierarchy()) {
            BeanMetaData<U> hostingBeanMetaData = this.beanMetaDataManager.getBeanMetaData(clazz);
            boolean defaultGroupSequenceIsRedefined = hostingBeanMetaData.defaultGroupSequenceIsRedefined();
            Set<MetaConstraint<?>> metaConstraints = hostingBeanMetaData.getDirectMetaConstraints();
            List<Class<?>> defaultGroupSequence = hostingBeanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean());
            if (defaultGroupSequenceIsRedefined) {
                metaConstraints = hostingBeanMetaData.getMetaConstraints();
            }
            for (Class<?> groupClass : defaultGroupSequence) {
                boolean validationSuccessful = true;
                valueContext.setCurrentGroup(groupClass);
                for (MetaConstraint<Object> metaConstraint : metaConstraints) {
                    Class<?> declaringClass = metaConstraint.getLocation().getBeanClass();
                    if (declaringClass.isInterface()) {
                        Class validatedForClass = (Class)validatedInterfaces.get(declaringClass);
                        if (validatedForClass != null && !validatedForClass.equals(clazz)) continue;
                        validatedInterfaces.put(declaringClass, clazz);
                    }
                    if (!constraintList.contains(metaConstraint) || !this.isValidationRequired(validationContext, valueContext, metaConstraint)) continue;
                    if (valueContext.getCurrentBean() != null) {
                        Object valueToValidate = metaConstraint.getValue(valueContext.getCurrentBean());
                        valueContext.setCurrentValidatedValue(valueToValidate);
                    }
                    boolean tmp = metaConstraint.validateConstraint(validationContext, valueContext);
                    boolean bl = validationSuccessful = validationSuccessful && tmp;
                    if (!this.shouldFailFast(validationContext)) continue;
                    return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
                }
                if (validationSuccessful) continue;
                break;
            }
            if (!defaultGroupSequenceIsRedefined) continue;
            break;
        }
        return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
    }

    private <T> void validateParametersInContext(ValidationContext<T> validationContext, Object[] parameterValues, ValidationOrder validationOrder) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(validationContext.getRootBeanClass());
        ExecutableMetaData executableMetaData = beanMetaData.getMetaDataFor(validationContext.getExecutable());
        if (executableMetaData == null) {
            throw log.getMethodOrConstructorNotDefinedByValidatedTypeException(beanMetaData.getBeanClass().getName(), validationContext.getExecutable().getMember());
        }
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(validationContext.getRootBean()));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            this.validateParametersForGroup(validationContext, parameterValues, groupIterator.next());
            if (!this.shouldFailFast(validationContext)) continue;
            return;
        }
        ValueContext cascadingValueContext = ValueContext.getLocalExecutionContext(parameterValues, (Validatable)executableMetaData.getValidatableParametersMetaData(), PathImpl.createPathForExecutable(executableMetaData));
        groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            cascadingValueContext.setCurrentGroup(group.getDefiningClass());
            this.validateCascadedConstraints(validationContext, cascadingValueContext);
            if (!this.shouldFailFast(validationContext)) continue;
            return;
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block2: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (Group group : sequence.getComposingGroups()) {
                int numberOfFailingConstraint = this.validateParametersForGroup(validationContext, parameterValues, group);
                if (this.shouldFailFast(validationContext)) {
                    return;
                }
                cascadingValueContext.setCurrentGroup(group.getDefiningClass());
                this.validateCascadedConstraints(validationContext, cascadingValueContext);
                if (this.shouldFailFast(validationContext)) {
                    return;
                }
                if (numberOfFailingConstraint <= 0) continue;
                continue block2;
            }
        }
    }

    private <T> int validateParametersForGroup(ValidationContext<T> validationContext, Object[] parameterValues, Group group) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(validationContext.getRootBeanClass());
        ExecutableMetaData executableMetaData = beanMetaData.getMetaDataFor(validationContext.getExecutable());
        List<Class<Object>> groupList = group.isDefaultGroup() ? beanMetaData.getDefaultGroupSequence(validationContext.getRootBean()) : Arrays.asList(group.getDefiningClass());
        for (Class<?> currentValidatedGroup : groupList) {
            int numberOfViolationsOfCurrentGroup = 0;
            ValueContext<T, Object> valueContext = this.getExecutableValueContext(validationContext.getRootBean(), executableMetaData, currentValidatedGroup);
            valueContext.appendCrossParameterNode();
            valueContext.setCurrentValidatedValue(parameterValues);
            numberOfViolationsOfCurrentGroup += this.validateConstraintsForGroup(validationContext, valueContext, executableMetaData.getCrossParameterConstraints());
            if (this.shouldFailFast(validationContext)) {
                return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
            }
            valueContext = this.getExecutableValueContext(validationContext.getRootBean(), executableMetaData, currentValidatedGroup);
            valueContext.setCurrentValidatedValue(parameterValues);
            for (int i = 0; i < parameterValues.length; ++i) {
                PathImpl originalPath = valueContext.getPropertyPath();
                ParameterMetaData parameterMetaData = executableMetaData.getParameterMetaData(i);
                Object value = parameterValues[i];
                if (value != null) {
                    Class<?> valueType = value.getClass();
                    if (parameterMetaData.getType() instanceof Class && ((Class)parameterMetaData.getType()).isPrimitive()) {
                        valueType = ReflectionHelper.unBoxedType(valueType);
                    }
                    if (!TypeHelper.isAssignable(parameterMetaData.getType(), valueType)) {
                        throw log.getParameterTypesDoNotMatchException(valueType.getName(), parameterMetaData.getType().toString(), i, validationContext.getExecutable().getMember());
                    }
                }
                valueContext.appendNode(executableMetaData.getParameterMetaData(i));
                valueContext.setCurrentValidatedValue(value);
                numberOfViolationsOfCurrentGroup += this.validateConstraintsForGroup(validationContext, valueContext, parameterMetaData);
                if (this.shouldFailFast(validationContext)) {
                    return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
                }
                valueContext.setPropertyPath(originalPath);
            }
            if (numberOfViolationsOfCurrentGroup <= 0) continue;
            break;
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private <T> ValueContext<T, Object> getExecutableValueContext(T object, ExecutableMetaData executableMetaData, Class<?> group) {
        ValueContext valueContext = object != null ? ValueContext.getLocalExecutionContext(object, null, PathImpl.createPathForExecutable(executableMetaData)) : ValueContext.getLocalExecutionContext((Class)null, null, PathImpl.createPathForExecutable(executableMetaData));
        valueContext.setCurrentGroup(group);
        return valueContext;
    }

    private <V, T> void validateReturnValueInContext(ValidationContext<T> context, T bean, V value, ValidationOrder validationOrder) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(context.getRootBeanClass());
        ExecutableMetaData executableMetaData = beanMetaData.getMetaDataFor(context.getExecutable());
        if (executableMetaData == null) {
            return;
        }
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(bean));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            this.validateReturnValueForGroup(context, bean, value, groupIterator.next());
            if (!this.shouldFailFast(context)) continue;
            return;
        }
        ValueContext cascadingValueContext = null;
        if (value != null) {
            cascadingValueContext = ValueContext.getLocalExecutionContext(value, (Validatable)executableMetaData.getReturnValueMetaData(), PathImpl.createPathForExecutable(executableMetaData));
            groupIterator = validationOrder.getGroupIterator();
            while (groupIterator.hasNext()) {
                Group group = groupIterator.next();
                cascadingValueContext.setCurrentGroup(group.getDefiningClass());
                this.validateCascadedConstraints(context, cascadingValueContext);
                if (!this.shouldFailFast(context)) continue;
                return;
            }
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block2: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (Group group : sequence.getComposingGroups()) {
                int numberOfFailingConstraint = this.validateReturnValueForGroup(context, bean, value, group);
                if (this.shouldFailFast(context)) {
                    return;
                }
                if (value != null) {
                    cascadingValueContext.setCurrentGroup(group.getDefiningClass());
                    this.validateCascadedConstraints(context, cascadingValueContext);
                    if (this.shouldFailFast(context)) {
                        return;
                    }
                }
                if (numberOfFailingConstraint <= 0) continue;
                continue block2;
            }
        }
    }

    private <T> int validateReturnValueForGroup(ValidationContext<T> validationContext, T bean, Object value, Group group) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(validationContext.getRootBeanClass());
        ExecutableMetaData executableMetaData = beanMetaData.getMetaDataFor(validationContext.getExecutable());
        if (executableMetaData == null) {
            return 0;
        }
        List<Class<Object>> groupList = group.isDefaultGroup() ? beanMetaData.getDefaultGroupSequence(bean) : Arrays.asList(group.getDefiningClass());
        for (Class<?> oneGroup : groupList) {
            int numberOfViolationsOfCurrentGroup = 0;
            ValueContext<Object, Object> valueContext = this.getExecutableValueContext(executableMetaData.getKind() == ElementKind.CONSTRUCTOR ? value : bean, executableMetaData, oneGroup);
            valueContext.setCurrentValidatedValue(value);
            valueContext.appendNode(executableMetaData.getReturnValueMetaData());
            numberOfViolationsOfCurrentGroup += this.validateConstraintsForGroup(validationContext, valueContext, executableMetaData);
            if (this.shouldFailFast(validationContext)) {
                return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
            }
            if (numberOfViolationsOfCurrentGroup <= 0) continue;
            break;
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private int validateConstraintsForGroup(ValidationContext<?> validationContext, ValueContext<?, ?> valueContext, Iterable<MetaConstraint<?>> constraints) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        for (MetaConstraint<?> metaConstraint : constraints) {
            if (!this.isValidationRequired(validationContext, valueContext, metaConstraint)) continue;
            metaConstraint.validateConstraint(validationContext, valueContext);
            if (!this.shouldFailFast(validationContext)) continue;
            break;
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private <V> ValueContext<?, V> collectMetaConstraintsForPath(Class<?> clazz, Object value, Iterator<Path.Node> propertyIter, PathImpl propertyPath, List<MetaConstraint<?>> metaConstraintsList) {
        Path.Node elem = propertyIter.next();
        Object newValue = value;
        BeanMetaData<?> metaData = this.beanMetaDataManager.getBeanMetaData(clazz);
        PropertyMetaData property = metaData.getMetaDataFor(elem.getName());
        if (property == null) {
            throw log.getInvalidPropertyPathException(elem.getName(), metaData.getBeanClass().getName());
        }
        if (!propertyIter.hasNext()) {
            metaConstraintsList.addAll(property.getConstraints());
        } else if (property.isCascading()) {
            Type type = property.getType();
            Object object = newValue = newValue == null ? null : property.getValue(newValue);
            if (elem.isInIterable()) {
                if (newValue != null && elem.getIndex() != null) {
                    newValue = ReflectionHelper.getIndexedValue(newValue, elem.getIndex());
                } else if (newValue != null && elem.getKey() != null) {
                    newValue = ReflectionHelper.getMappedValue(newValue, elem.getKey());
                } else if (newValue != null) {
                    throw log.getPropertyPathMustProvideIndexOrMapKeyException();
                }
                type = ReflectionHelper.getIndexedType(type);
            }
            Class<?> castedValueClass = newValue == null ? (Class<?>)type : newValue.getClass();
            return this.collectMetaConstraintsForPath(castedValueClass, newValue, propertyIter, propertyPath, metaConstraintsList);
        }
        if (newValue == null) {
            return ValueContext.getLocalExecutionContext(clazz, null, propertyPath);
        }
        return ValueContext.getLocalExecutionContext(value, null, propertyPath);
    }

    private TraversableResolver getCachingTraversableResolver() {
        return new SingleThreadCachedTraversableResolver(this.traversableResolver);
    }

    private boolean isValidationRequired(ValidationContext<?> validationContext, ValueContext<?, ?> valueContext, MetaConstraint<?> metaConstraint) {
        if (validationContext.hasMetaConstraintBeenProcessed(valueContext.getCurrentBean(), valueContext.getPropertyPath(), metaConstraint)) {
            return false;
        }
        if (!metaConstraint.getGroupList().contains(valueContext.getCurrentGroup())) {
            return false;
        }
        return this.isReachable(validationContext, valueContext.getCurrentBean(), valueContext.getPropertyPath(), metaConstraint.getElementType());
    }

    private boolean isReachable(ValidationContext<?> validationContext, Object traversableObject, PathImpl path, ElementType type) {
        if (this.needToCallTraversableResolver(path, type)) {
            return true;
        }
        PathImpl pathToObject = path.getPathWithoutLeafNode();
        try {
            return validationContext.getTraversableResolver().isReachable(traversableObject, (Path.Node)path.getLeafNode(), validationContext.getRootBeanClass(), (Path)pathToObject, type);
        }
        catch (RuntimeException e) {
            throw log.getErrorDuringCallOfTraversableResolverIsReachableException(e);
        }
    }

    private boolean needToCallTraversableResolver(PathImpl path, ElementType type) {
        return this.isClassLevelConstraint(type) || this.isCrossParameterValidation(path) || this.isParameterValidation(path) || this.isReturnValueValidation(path);
    }

    private boolean isCascadeRequired(ValidationContext<?> validationContext, Object traversableObject, PathImpl path, ElementType type) {
        if (this.needToCallTraversableResolver(path, type)) {
            return true;
        }
        boolean isReachable = this.isReachable(validationContext, traversableObject, path, type);
        if (!isReachable) {
            return false;
        }
        PathImpl pathToObject = path.getPathWithoutLeafNode();
        try {
            return validationContext.getTraversableResolver().isCascadable(traversableObject, (Path.Node)path.getLeafNode(), validationContext.getRootBeanClass(), (Path)pathToObject, type);
        }
        catch (RuntimeException e) {
            throw log.getErrorDuringCallOfTraversableResolverIsCascadableException(e);
        }
    }

    private boolean isClassLevelConstraint(ElementType type) {
        return ElementType.TYPE.equals((Object)type);
    }

    private boolean isCrossParameterValidation(PathImpl path) {
        return path.getLeafNode().getKind() == ElementKind.CROSS_PARAMETER;
    }

    private boolean isParameterValidation(PathImpl path) {
        return path.getLeafNode().getKind() == ElementKind.PARAMETER;
    }

    private boolean isReturnValueValidation(PathImpl path) {
        return path.getLeafNode().getKind() == ElementKind.RETURN_VALUE;
    }

    private boolean shouldFailFast(ValidationContext<?> context) {
        return context.isFailFastModeEnabled() && !context.getFailingConstraints().isEmpty();
    }
}

