/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

public class Filters {
    private int last_pitch;
    private float[] last_pitch_gain = new float[3];
    private float smooth_gain;
    private float[] xx = new float[1024];

    public void init() {
        this.last_pitch = 0;
        this.last_pitch_gain[2] = 0.0f;
        this.last_pitch_gain[1] = 0.0f;
        this.last_pitch_gain[0] = 0.0f;
        this.smooth_gain = 1.0f;
    }

    public static final void bw_lpc(float gamma, float[] lpc_in, float[] lpc_out, int order) {
        float tmp = 1.0f;
        for (int i = 0; i < order + 1; ++i) {
            lpc_out[i] = tmp * lpc_in[i];
            tmp *= gamma;
        }
    }

    public static final void filter_mem2(float[] x, int xs, float[] num, float[] den, int N, int ord, float[] mem, int ms) {
        for (int i = 0; i < N; ++i) {
            float xi = x[xs + i];
            x[xs + i] = num[0] * xi + mem[ms + 0];
            float yi = x[xs + i];
            for (int j = 0; j < ord - 1; ++j) {
                mem[ms + j] = mem[ms + j + 1] + num[j + 1] * xi - den[j + 1] * yi;
            }
            mem[ms + ord - 1] = num[ord] * xi - den[ord] * yi;
        }
    }

    public static final void filter_mem2(float[] x, int xs, float[] num, float[] den, float[] y, int ys, int N, int ord, float[] mem, int ms) {
        for (int i = 0; i < N; ++i) {
            float xi = x[xs + i];
            y[ys + i] = num[0] * xi + mem[0];
            float yi = y[ys + i];
            for (int j = 0; j < ord - 1; ++j) {
                mem[ms + j] = mem[ms + j + 1] + num[j + 1] * xi - den[j + 1] * yi;
            }
            mem[ms + ord - 1] = num[ord] * xi - den[ord] * yi;
        }
    }

    public static final void iir_mem2(float[] x, int xs, float[] den, float[] y, int ys, int N, int ord, float[] mem) {
        for (int i = 0; i < N; ++i) {
            y[ys + i] = x[xs + i] + mem[0];
            for (int j = 0; j < ord - 1; ++j) {
                mem[j] = mem[j + 1] - den[j + 1] * y[ys + i];
            }
            mem[ord - 1] = -den[ord] * y[ys + i];
        }
    }

    public static final void fir_mem2(float[] x, int xs, float[] num, float[] y, int ys, int N, int ord, float[] mem) {
        for (int i = 0; i < N; ++i) {
            float xi = x[xs + i];
            y[ys + i] = num[0] * xi + mem[0];
            for (int j = 0; j < ord - 1; ++j) {
                mem[j] = mem[j + 1] + num[j + 1] * xi;
            }
            mem[ord - 1] = num[ord] * xi;
        }
    }

    public static final void syn_percep_zero(float[] xx, int xxs, float[] ak, float[] awk1, float[] awk2, float[] y, int N, int ord) {
        float[] mem = new float[ord];
        Filters.filter_mem2(xx, xxs, awk1, ak, y, 0, N, ord, mem, 0);
        for (int i = 0; i < ord; ++i) {
            mem[i] = 0.0f;
        }
        Filters.iir_mem2(y, 0, awk2, y, 0, N, ord, mem);
    }

    public static final void residue_percep_zero(float[] xx, int xxs, float[] ak, float[] awk1, float[] awk2, float[] y, int N, int ord) {
        float[] mem = new float[ord];
        Filters.filter_mem2(xx, xxs, ak, awk1, y, 0, N, ord, mem, 0);
        for (int i = 0; i < ord; ++i) {
            mem[i] = 0.0f;
        }
        Filters.fir_mem2(y, 0, awk2, y, 0, N, ord, mem);
    }

    public void fir_mem_up(float[] x, float[] a, float[] y, int N, int M, float[] mem) {
        int i;
        for (i = 0; i < N / 2; ++i) {
            this.xx[2 * i] = x[N / 2 - 1 - i];
        }
        for (i = 0; i < M - 1; i += 2) {
            this.xx[N + i] = mem[i + 1];
        }
        for (i = 0; i < N; i += 4) {
            float y3 = 0.0f;
            float y2 = 0.0f;
            float y1 = 0.0f;
            float y0 = 0.0f;
            float x0 = this.xx[N - 4 - i];
            for (int j = 0; j < M; j += 4) {
                float a0 = a[j];
                float a1 = a[j + 1];
                float x1 = this.xx[N - 2 + j - i];
                y0 += a0 * x1;
                y1 += a1 * x1;
                y2 += a0 * x0;
                y3 += a1 * x0;
                a0 = a[j + 2];
                a1 = a[j + 3];
                x0 = this.xx[N + j - i];
                y0 += a0 * x0;
                y1 += a1 * x0;
                y2 += a0 * x1;
                y3 += a1 * x1;
            }
            y[i] = y0;
            y[i + 1] = y1;
            y[i + 2] = y2;
            y[i + 3] = y3;
        }
        for (i = 0; i < M - 1; i += 2) {
            mem[i + 1] = this.xx[i];
        }
    }

    public void comb_filter(float[] exc, int esi, float[] new_exc, int nsi, int nsf, int pitch, float[] pitch_gain, float comb_gain) {
        int i;
        float exc_energy = 0.0f;
        float new_exc_energy = 0.0f;
        float g = 0.0f;
        for (i = esi; i < esi + nsf; ++i) {
            exc_energy += exc[i] * exc[i];
        }
        g = 0.5f * Math.abs(pitch_gain[0] + pitch_gain[1] + pitch_gain[2] + this.last_pitch_gain[0] + this.last_pitch_gain[1] + this.last_pitch_gain[2]);
        if (g > 1.3f) {
            comb_gain *= 1.3f / g;
        }
        if (g < 0.5f) {
            comb_gain *= 2.0f * g;
        }
        float step = 1.0f / (float)nsf;
        float fact = 0.0f;
        i = 0;
        int j = esi;
        while (i < nsf) {
            new_exc[nsi + i] = exc[j] + comb_gain * (fact += step) * (pitch_gain[0] * exc[j - pitch + 1] + pitch_gain[1] * exc[j - pitch] + pitch_gain[2] * exc[j - pitch - 1]) + comb_gain * (1.0f - fact) * (this.last_pitch_gain[0] * exc[j - this.last_pitch + 1] + this.last_pitch_gain[1] * exc[j - this.last_pitch] + this.last_pitch_gain[2] * exc[j - this.last_pitch - 1]);
            ++i;
            ++j;
        }
        this.last_pitch_gain[0] = pitch_gain[0];
        this.last_pitch_gain[1] = pitch_gain[1];
        this.last_pitch_gain[2] = pitch_gain[2];
        this.last_pitch = pitch;
        for (i = nsi; i < nsi + nsf; ++i) {
            new_exc_energy += new_exc[i] * new_exc[i];
        }
        float gain = (float)Math.sqrt(exc_energy / (0.1f + new_exc_energy));
        if (gain < 0.5f) {
            gain = 0.5f;
        }
        if (gain > 1.0f) {
            gain = 1.0f;
        }
        i = nsi;
        while (i < nsi + nsf) {
            this.smooth_gain = 0.96f * this.smooth_gain + 0.04f * gain;
            int n = i++;
            new_exc[n] = new_exc[n] * this.smooth_gain;
        }
    }

    public static final void qmf_decomp(float[] xx, float[] aa, float[] y1, float[] y2, int N, int M, float[] mem) {
        int i;
        float[] a = new float[M];
        float[] x = new float[N + M - 1];
        int x2 = M - 1;
        int M2 = M >> 1;
        for (i = 0; i < M; ++i) {
            a[M - i - 1] = aa[i];
        }
        for (i = 0; i < M - 1; ++i) {
            x[i] = mem[M - i - 2];
        }
        for (i = 0; i < N; ++i) {
            x[i + M - 1] = xx[i];
        }
        i = 0;
        int k = 0;
        while (i < N) {
            y1[k] = 0.0f;
            y2[k] = 0.0f;
            for (int j = 0; j < M2; ++j) {
                int n = k;
                y1[n] = y1[n] + a[j] * (x[i + j] + x[x2 + i - j]);
                int n2 = k;
                y2[n2] = y2[n2] - a[j] * (x[i + j] - x[x2 + i - j]);
                int n3 = k;
                y1[n3] = y1[n3] + a[++j] * (x[i + j] + x[x2 + i - j]);
                int n4 = k;
                y2[n4] = y2[n4] + a[j] * (x[i + j] - x[x2 + i - j]);
            }
            i += 2;
            ++k;
        }
        for (i = 0; i < M - 1; ++i) {
            mem[i] = xx[N - i - 1];
        }
    }
}

