/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.ContactList;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.ContentType;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.MaxForwards;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.ProxyAuthorization;
import gov.nist.javax.sip.header.ProxyRequireList;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.RequireList;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.TimeStamp;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPDuplicateHeaderException;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPResponse;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import javax.sip.InvalidArgumentException;
import javax.sip.address.URI;
import javax.sip.message.Request;

public final class SIPRequest
extends SIPMessage
implements Request {
    private static final String DEFAULT_USER = "ip";
    private static final String DEFAULT_TRANSPORT = "udp";
    private Object transactionPointer;
    private RequestLine requestLine;
    private Object messageChannel;
    private Object inviteTransaction;
    private static final Set targetRefreshMethods = new HashSet();
    private static final Hashtable nameTable = new Hashtable();

    private static void putName(String string) {
        nameTable.put(string, string);
    }

    public static boolean isTargetRefresh(String string) {
        return targetRefreshMethods.contains(string);
    }

    public static String getCannonicalName(String string) {
        if (nameTable.containsKey(string)) {
            return (String)nameTable.get(string);
        }
        return string;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public void setRequestLine(RequestLine requestLine) {
        this.requestLine = requestLine;
    }

    public String debugDump() {
        String string = super.debugDump();
        this.stringRepresentation = "";
        this.sprint(SIPRequest.class.getName());
        this.sprint("{");
        if (this.requestLine != null) {
            this.sprint(this.requestLine.debugDump());
        }
        this.sprint(string);
        this.sprint("}");
        return this.stringRepresentation;
    }

    public void checkHeaders() throws ParseException {
        String string = "Missing a required header : ";
        if (this.getCSeq() == null) {
            throw new ParseException(string + "CSeq", 0);
        }
        if (this.getTo() == null) {
            throw new ParseException(string + "To", 0);
        }
        if (this.callIdHeader == null || this.callIdHeader.getCallId() == null || this.callIdHeader.getCallId().equals("")) {
            throw new ParseException(string + "Call-ID", 0);
        }
        if (this.getFrom() == null) {
            throw new ParseException(string + "From", 0);
        }
        if (this.getViaHeaders() == null) {
            throw new ParseException(string + "Via", 0);
        }
        if (this.getMaxForwards() == null) {
            throw new ParseException(string + "Max-Forwards", 0);
        }
        if (this.getTopmostVia() == null) {
            throw new ParseException("No via header in request! ", 0);
        }
        if (this.getMethod().equals("NOTIFY")) {
            if (this.getHeader("Subscription-State") == null) {
                throw new ParseException(string + "Subscription-State", 0);
            }
            if (this.getHeader("Event") == null) {
                throw new ParseException(string + "Event", 0);
            }
        } else if (this.getMethod().equals("PUBLISH") && this.getHeader("Event") == null) {
            throw new ParseException(string + "Event", 0);
        }
        if (this.requestLine.getMethod().equals("INVITE") || this.requestLine.getMethod().equals("SUBSCRIBE") || this.requestLine.getMethod().equals("REFER")) {
            SipUri sipUri;
            String string2;
            if (this.getContactHeader() == null && this.getToTag() == null) {
                throw new ParseException(string + "Contact", 0);
            }
            if (this.requestLine.getUri() instanceof SipUri && "sips".equalsIgnoreCase(string2 = ((SipUri)this.requestLine.getUri()).getScheme()) && !(sipUri = (SipUri)this.getContactHeader().getAddress().getURI()).getScheme().equals("sips")) {
                throw new ParseException("Scheme for contact should be sips:" + sipUri, 0);
            }
        }
        if (this.getContactHeader() == null && (this.getMethod().equals("INVITE") || this.getMethod().equals("REFER") || this.getMethod().equals("SUBSCRIBE"))) {
            throw new ParseException("Contact Header is Mandatory for a SIP INVITE", 0);
        }
        if (this.requestLine != null && this.requestLine.getMethod() != null && this.getCSeq().getMethod() != null && this.requestLine.getMethod().compareTo(this.getCSeq().getMethod()) != 0) {
            throw new ParseException("CSEQ method mismatch with  Request-Line ", 0);
        }
    }

    protected void setDefaults() {
        if (this.requestLine == null) {
            return;
        }
        String string = this.requestLine.getMethod();
        if (string == null) {
            return;
        }
        GenericURI genericURI = this.requestLine.getUri();
        if (genericURI == null) {
            return;
        }
        if ((string.compareTo("REGISTER") == 0 || string.compareTo("INVITE") == 0) && genericURI instanceof SipUri) {
            SipUri sipUri = (SipUri)genericURI;
            sipUri.setUserParam(DEFAULT_USER);
            try {
                sipUri.setTransportParam(DEFAULT_TRANSPORT);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    protected void setRequestLineDefaults() {
        CSeq cSeq;
        String string = this.requestLine.getMethod();
        if (string == null && (cSeq = (CSeq)this.getCSeq()) != null) {
            string = SIPRequest.getCannonicalName(cSeq.getMethod());
            this.requestLine.setMethod(string);
        }
    }

    public URI getRequestURI() {
        if (this.requestLine == null) {
            return null;
        }
        return this.requestLine.getUri();
    }

    public void setRequestURI(URI uRI) {
        if (this.requestLine == null) {
            this.requestLine = new RequestLine();
        }
        this.requestLine.setUri((GenericURI)uRI);
    }

    public void setMethod(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null method");
        }
        if (this.requestLine == null) {
            this.requestLine = new RequestLine();
        }
        String string2 = SIPRequest.getCannonicalName(string);
        this.requestLine.setMethod(string2);
        if (this.cSeqHeader != null) {
            try {
                this.cSeqHeader.setMethod(string2);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public String getMethod() {
        if (this.requestLine == null) {
            return null;
        }
        return this.requestLine.getMethod();
    }

    public String encode() {
        String string;
        if (this.requestLine != null) {
            this.setRequestLineDefaults();
            string = this.requestLine.encode() + super.encode();
        } else {
            string = super.encode();
        }
        return string;
    }

    public String encodeMessage() {
        String string;
        if (this.requestLine != null) {
            this.setRequestLineDefaults();
            string = this.requestLine.encode() + super.encodeSIPHeaders();
        } else {
            string = super.encodeSIPHeaders();
        }
        return string;
    }

    public String toString() {
        return this.encode();
    }

    public Object clone() {
        SIPRequest sIPRequest = (SIPRequest)super.clone();
        sIPRequest.transactionPointer = null;
        if (this.requestLine != null) {
            sIPRequest.requestLine = (RequestLine)this.requestLine.clone();
        }
        return sIPRequest;
    }

    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        SIPRequest sIPRequest = (SIPRequest)object;
        return this.requestLine.equals(sIPRequest.requestLine) && super.equals(object);
    }

    public LinkedList getMessageAsEncodedStrings() {
        LinkedList linkedList = super.getMessageAsEncodedStrings();
        if (this.requestLine != null) {
            this.setRequestLineDefaults();
            linkedList.addFirst(this.requestLine.encode());
        }
        return linkedList;
    }

    public boolean match(Object object) {
        if (object == null) {
            return true;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        if (object == this) {
            return true;
        }
        SIPRequest sIPRequest = (SIPRequest)object;
        RequestLine requestLine = sIPRequest.requestLine;
        if (this.requestLine == null && requestLine != null) {
            return false;
        }
        if (this.requestLine == requestLine) {
            return super.match(object);
        }
        return this.requestLine.match(sIPRequest.requestLine) && super.match(object);
    }

    public String getDialogId(boolean bl) {
        CallID callID = (CallID)this.getCallId();
        StringBuffer stringBuffer = new StringBuffer(callID.getCallId());
        From from = (From)this.getFrom();
        To to = (To)this.getTo();
        if (!bl) {
            if (from.getTag() != null) {
                stringBuffer.append(":");
                stringBuffer.append(from.getTag());
            }
            if (to.getTag() != null) {
                stringBuffer.append(":");
                stringBuffer.append(to.getTag());
            }
        } else {
            if (to.getTag() != null) {
                stringBuffer.append(":");
                stringBuffer.append(to.getTag());
            }
            if (from.getTag() != null) {
                stringBuffer.append(":");
                stringBuffer.append(from.getTag());
            }
        }
        return stringBuffer.toString().toLowerCase();
    }

    public String getDialogId(boolean bl, String string) {
        From from = (From)this.getFrom();
        CallID callID = (CallID)this.getCallId();
        StringBuffer stringBuffer = new StringBuffer(callID.getCallId());
        if (!bl) {
            if (from.getTag() != null) {
                stringBuffer.append(":");
                stringBuffer.append(from.getTag());
            }
            if (string != null) {
                stringBuffer.append(":");
                stringBuffer.append(string);
            }
        } else {
            if (string != null) {
                stringBuffer.append(":");
                stringBuffer.append(string);
            }
            if (from.getTag() != null) {
                stringBuffer.append(":");
                stringBuffer.append(from.getTag());
            }
        }
        return stringBuffer.toString().toLowerCase();
    }

    public byte[] encodeAsBytes() {
        if (this.requestLine == null) {
            return new byte[0];
        }
        byte[] byArray = null;
        if (this.requestLine != null) {
            try {
                byArray = this.requestLine.encode().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                InternalErrorHandler.handleException(unsupportedEncodingException);
            }
        }
        byte[] byArray2 = super.encodeAsBytes();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public SIPResponse createResponse(int n) {
        String string = SIPResponse.getReasonPhrase(n);
        return this.createResponse(n, string);
    }

    public SIPResponse createResponse(int n, String string) {
        SIPResponse sIPResponse = new SIPResponse();
        try {
            sIPResponse.setStatusCode(n);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Bad code " + n);
        }
        if (string != null) {
            sIPResponse.setReasonPhrase(string);
        } else {
            sIPResponse.setReasonPhrase(SIPResponse.getReasonPhrase(n));
        }
        ListIterator listIterator = this.getHeaders();
        while (listIterator.hasNext()) {
            SIPHeader sIPHeader = (SIPHeader)listIterator.next();
            if (!(sIPHeader instanceof From) && !(sIPHeader instanceof To) && !(sIPHeader instanceof ViaList) && !(sIPHeader instanceof CallID) && (n / 100 > 2 || n / 100 <= 1 || !(sIPHeader instanceof RecordRouteList)) && !(sIPHeader instanceof CSeq) && !(sIPHeader instanceof TimeStamp)) continue;
            try {
                sIPResponse.attachHeader((SIPHeader)sIPHeader.clone(), false);
            }
            catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {
                sIPDuplicateHeaderException.printStackTrace();
            }
        }
        if (sIPResponse.getStatusCode() == 100) {
            sIPResponse.getTo().removeParameter("tag");
        }
        return sIPResponse;
    }

    public SIPRequest createCancelRequest() {
        SIPRequest sIPRequest = new SIPRequest();
        sIPRequest.setRequestLine((RequestLine)this.requestLine.clone());
        sIPRequest.setMethod("CANCEL");
        ListIterator listIterator = this.getHeaders();
        while (listIterator.hasNext()) {
            SIPHeader sIPHeader = (SIPHeader)listIterator.next();
            if (sIPHeader instanceof RequireList || sIPHeader instanceof ProxyRequireList || sIPHeader instanceof ContentLength || sIPHeader instanceof ContentType || sIPHeader instanceof ContactList) continue;
            if (sIPHeader instanceof CSeq) {
                CSeq cSeq = (CSeq)sIPHeader.clone();
                try {
                    cSeq.setMethod("CANCEL");
                }
                catch (ParseException parseException) {
                    InternalErrorHandler.handleException(parseException);
                }
                sIPHeader = cSeq;
            } else {
                sIPHeader = sIPHeader instanceof ViaList ? (SIPHeader)((ViaList)sIPHeader).getFirst().clone() : (SIPHeader)sIPHeader.clone();
            }
            try {
                sIPRequest.attachHeader(sIPHeader, false);
            }
            catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {
                sIPDuplicateHeaderException.printStackTrace();
                InternalErrorHandler.handleException(sIPDuplicateHeaderException);
            }
        }
        return sIPRequest;
    }

    public SIPRequest createAckRequest(To to) {
        SIPRequest sIPRequest = new SIPRequest();
        sIPRequest.setRequestLine((RequestLine)this.requestLine.clone());
        sIPRequest.setMethod("ACK");
        ListIterator listIterator = this.getHeaders();
        while (listIterator.hasNext()) {
            SIPHeader sIPHeader = (SIPHeader)listIterator.next();
            if (sIPHeader instanceof RouteList || sIPHeader instanceof ProxyAuthorization) continue;
            if (sIPHeader instanceof ContentLength) {
                sIPHeader = (SIPHeader)sIPHeader.clone();
                try {
                    ((ContentLength)sIPHeader).setContentLength(0);
                }
                catch (InvalidArgumentException invalidArgumentException) {}
            } else {
                if (sIPHeader instanceof ContentType) continue;
                if (sIPHeader instanceof CSeq) {
                    CSeq cSeq = (CSeq)sIPHeader.clone();
                    try {
                        cSeq.setMethod("ACK");
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    sIPHeader = cSeq;
                } else if (sIPHeader instanceof To) {
                    sIPHeader = to != null ? to : (SIPHeader)sIPHeader.clone();
                } else {
                    if (sIPHeader instanceof ContactList) continue;
                    sIPHeader = sIPHeader instanceof ViaList ? (SIPHeader)((ViaList)sIPHeader).getFirst().clone() : (SIPHeader)sIPHeader.clone();
                }
            }
            try {
                sIPRequest.attachHeader(sIPHeader, false);
            }
            catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {
                sIPDuplicateHeaderException.printStackTrace();
            }
        }
        return sIPRequest;
    }

    public SIPRequest createSIPRequest(RequestLine requestLine, boolean bl) {
        SIPRequest sIPRequest = new SIPRequest();
        sIPRequest.requestLine = requestLine;
        ListIterator listIterator = this.getHeaders();
        while (listIterator.hasNext()) {
            SIPHeader sIPHeader;
            SIPHeader sIPHeader2 = (SIPHeader)listIterator.next();
            if (sIPHeader2 instanceof CSeq) {
                sIPHeader2 = sIPHeader = (CSeq)sIPHeader2.clone();
                try {
                    ((CSeq)sIPHeader).setMethod(requestLine.getMethod());
                }
                catch (ParseException parseException) {}
            } else if (sIPHeader2 instanceof ViaList) {
                sIPHeader = (Via)((ViaList)sIPHeader2).getFirst().clone();
                ((ParametersHeader)sIPHeader).removeParameter("branch");
                sIPHeader2 = sIPHeader;
            } else if (sIPHeader2 instanceof To) {
                sIPHeader = (To)sIPHeader2;
                if (bl) {
                    sIPHeader2 = new From((To)sIPHeader);
                    ((From)sIPHeader2).removeTag();
                } else {
                    sIPHeader2 = (SIPHeader)((AddressParametersHeader)sIPHeader).clone();
                    ((To)sIPHeader2).removeTag();
                }
            } else if (sIPHeader2 instanceof From) {
                sIPHeader = (From)sIPHeader2;
                if (bl) {
                    sIPHeader2 = new To((From)sIPHeader);
                    ((To)sIPHeader2).removeTag();
                } else {
                    sIPHeader2 = (SIPHeader)((AddressParametersHeader)sIPHeader).clone();
                    ((From)sIPHeader2).removeTag();
                }
            } else if (sIPHeader2 instanceof ContentLength) {
                sIPHeader = (ContentLength)sIPHeader2.clone();
                try {
                    ((ContentLength)sIPHeader).setContentLength(0);
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    // empty catch block
                }
                sIPHeader2 = sIPHeader;
            } else if (!(sIPHeader2 instanceof CallID) && !(sIPHeader2 instanceof MaxForwards)) continue;
            try {
                sIPRequest.attachHeader(sIPHeader2, false);
            }
            catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {
                sIPDuplicateHeaderException.printStackTrace();
            }
        }
        return sIPRequest;
    }

    public SIPRequest createBYERequest(boolean bl) {
        RequestLine requestLine = (RequestLine)this.requestLine.clone();
        requestLine.setMethod("BYE");
        return this.createSIPRequest(requestLine, bl);
    }

    public SIPRequest createACKRequest() {
        RequestLine requestLine = (RequestLine)this.requestLine.clone();
        requestLine.setMethod("ACK");
        return this.createSIPRequest(requestLine, false);
    }

    public String getViaHost() {
        Via via = (Via)this.getViaHeaders().getFirst();
        return via.getHost();
    }

    public int getViaPort() {
        Via via = (Via)this.getViaHeaders().getFirst();
        if (via.hasPort()) {
            return via.getPort();
        }
        return 5060;
    }

    public String getFirstLine() {
        if (this.requestLine == null) {
            return null;
        }
        return this.requestLine.encode();
    }

    public void setSIPVersion(String string) throws ParseException {
        if (string == null || !string.equalsIgnoreCase("SIP/2.0")) {
            throw new ParseException("sipVersion", 0);
        }
        this.requestLine.setSIPVersion(string);
    }

    public String getSIPVersion() {
        return this.requestLine.getSipVersion();
    }

    public Object getTransaction() {
        return this.transactionPointer;
    }

    public void setTransaction(Object object) {
        this.transactionPointer = object;
    }

    public Object getMessageChannel() {
        return this.messageChannel;
    }

    public void setMessageChannel(Object object) {
        this.messageChannel = object;
    }

    public String getMergeId() {
        String string = this.getFromTag();
        String string2 = this.cSeqHeader.toString();
        String string3 = this.callIdHeader.getCallId();
        if (string != null) {
            return string + ":" + string2 + ":" + string3;
        }
        return null;
    }

    public void setInviteTransaction(Object object) {
        this.inviteTransaction = object;
    }

    public Object getInviteTransaction() {
        return this.inviteTransaction;
    }

    public boolean isNullRequest() {
        return this.requestLine == null;
    }

    static {
        targetRefreshMethods.add("INVITE");
        targetRefreshMethods.add("UPDATE");
        targetRefreshMethods.add("SUBSCRIBE");
        targetRefreshMethods.add("NOTIFY");
        targetRefreshMethods.add("REFER");
        SIPRequest.putName("INVITE");
        SIPRequest.putName("BYE");
        SIPRequest.putName("CANCEL");
        SIPRequest.putName("ACK");
        SIPRequest.putName("PRACK");
        SIPRequest.putName("INFO");
        SIPRequest.putName("MESSAGE");
        SIPRequest.putName("NOTIFY");
        SIPRequest.putName("OPTIONS");
        SIPRequest.putName("PRACK");
        SIPRequest.putName("PUBLISH");
        SIPRequest.putName("REFER");
        SIPRequest.putName("REGISTER");
        SIPRequest.putName("SUBSCRIBE");
        SIPRequest.putName("UPDATE");
    }
}

