/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.List;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.DelegatingDatagramSocket;
import org.ice4j.socket.MultiplexingDatagramSocket;

public class MultiplexedDatagramSocket
extends DelegatingDatagramSocket {
    private final DatagramPacketFilter filter;
    private final MultiplexingDatagramSocket multiplexing;
    final List<DatagramPacket> received = new LinkedList<DatagramPacket>();

    MultiplexedDatagramSocket(MultiplexingDatagramSocket multiplexing, DatagramPacketFilter filter) throws SocketException {
        super(multiplexing);
        if (multiplexing == null) {
            throw new NullPointerException("multiplexing");
        }
        this.multiplexing = multiplexing;
        this.filter = filter;
    }

    public void close() {
        this.multiplexing.close(this);
    }

    public DatagramPacketFilter getFilter() {
        return this.filter;
    }

    public void receive(DatagramPacket p) throws IOException {
        this.multiplexing.receive(this, p);
    }
}

