/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RawUdpTransportPacketExtension;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.videobridge.Channel;

public abstract class TransportManager {
    private static long nextCandidateID = 1L;
    private final Channel channel;
    private final PropertyChangeListener channelPropertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            TransportManager.this.channelPropertyChange(ev);
        }
    };

    protected TransportManager(Channel channel) {
        this.channel = channel;
        if (this.channel != null) {
            this.channel.addPropertyChangeListener(this.channelPropertyChangeListener);
        }
    }

    protected void channelPropertyChange(PropertyChangeEvent ev) {
    }

    public void close() {
        Channel channel = this.getChannel();
        if (channel != null) {
            channel.removePropertyChangeListener(this.channelPropertyChangeListener);
        }
    }

    public void describe(ColibriConferenceIQ.Channel iq) {
        Object pe = iq.getTransport();
        String namespace = this.getXmlNamespace();
        if (pe == null || !namespace.equals(pe.getNamespace())) {
            pe = "urn:xmpp:jingle:transports:ice-udp:1".equals(namespace) ? new IceUdpTransportPacketExtension() : ("urn:xmpp:jingle:transports:raw-udp:1".equals(namespace) ? new RawUdpTransportPacketExtension() : null);
            iq.setTransport(pe);
        }
        if (pe != null) {
            this.describe((IceUdpTransportPacketExtension)pe);
        }
    }

    protected abstract void describe(IceUdpTransportPacketExtension var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateCandidateID() {
        Class<TransportManager> clazz = TransportManager.class;
        synchronized (TransportManager.class) {
            long candidateID = nextCandidateID++;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            return Long.toHexString(candidateID);
        }
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public abstract StreamConnector getStreamConnector();

    public abstract MediaStreamTarget getStreamTarget();

    public abstract String getXmlNamespace();

    public abstract boolean startConnectivityEstablishment(IceUdpTransportPacketExtension var1);

    public abstract void wrapupConnectivityEstablishment() throws OperationFailedException;
}

