/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.audiolevel;

import javax.media.Buffer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.audiolevel.AudioLevelEventDispatcher;
import org.jitsi.impl.neomedia.control.ControlsAdapter;
import org.jitsi.service.neomedia.event.SimpleAudioLevelListener;

public class AudioLevelEffect
extends ControlsAdapter
implements Effect {
    private static final boolean COPY_DATA_FROM_INPUT_TO_OUTPUT = true;
    private SimpleAudioLevelListener audioLevelListener = null;
    private final AudioLevelEventDispatcher eventDispatcher = new AudioLevelEventDispatcher("AudioLevelEffect Dispatcher");
    private boolean open = false;
    private Format[] supportedAudioFormats = new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, 16, -1.0, Format.byteArray)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAudioLevelListener(SimpleAudioLevelListener listener) {
        AudioLevelEventDispatcher audioLevelEventDispatcher = this.eventDispatcher;
        synchronized (audioLevelEventDispatcher) {
            this.audioLevelListener = listener;
            if (this.open) {
                this.eventDispatcher.setAudioLevelListener(this.audioLevelListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleAudioLevelListener getAudioLevelListener() {
        AudioLevelEventDispatcher audioLevelEventDispatcher = this.eventDispatcher;
        synchronized (audioLevelEventDispatcher) {
            return this.audioLevelListener;
        }
    }

    @Override
    public Format[] getSupportedInputFormats() {
        return this.supportedAudioFormats;
    }

    @Override
    public Format[] getSupportedOutputFormats(Format input) {
        return new Format[]{new AudioFormat("LINEAR", ((AudioFormat)input).getSampleRate(), 16, 1, 0, 1, 16, -1.0, Format.byteArray)};
    }

    @Override
    public Format setInputFormat(Format format) {
        return format instanceof AudioFormat ? (AudioFormat)format : null;
    }

    @Override
    public Format setOutputFormat(Format format) {
        return format instanceof AudioFormat ? (AudioFormat)format : null;
    }

    @Override
    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        byte[] bufferData;
        Object data = outputBuffer.getData();
        int inputBufferLength = inputBuffer.getLength();
        if (data instanceof byte[] && ((byte[])data).length >= inputBufferLength) {
            bufferData = (byte[])data;
        } else {
            bufferData = new byte[inputBufferLength];
            outputBuffer.setData(bufferData);
        }
        outputBuffer.setLength(inputBufferLength);
        outputBuffer.setOffset(0);
        System.arraycopy(inputBuffer.getData(), inputBuffer.getOffset(), bufferData, 0, inputBufferLength);
        outputBuffer.setFormat(inputBuffer.getFormat());
        outputBuffer.setHeader(inputBuffer.getHeader());
        outputBuffer.setSequenceNumber(inputBuffer.getSequenceNumber());
        outputBuffer.setTimeStamp(inputBuffer.getTimeStamp());
        outputBuffer.setFlags(inputBuffer.getFlags());
        outputBuffer.setDiscard(inputBuffer.isDiscard());
        outputBuffer.setEOM(inputBuffer.isEOM());
        outputBuffer.setDuration(inputBuffer.getDuration());
        this.eventDispatcher.addData(outputBuffer);
        return 0;
    }

    @Override
    public String getName() {
        return "Audio Level Effect";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws ResourceUnavailableException {
        AudioLevelEventDispatcher audioLevelEventDispatcher = this.eventDispatcher;
        synchronized (audioLevelEventDispatcher) {
            if (!this.open) {
                this.open = true;
                this.eventDispatcher.setAudioLevelListener(this.audioLevelListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AudioLevelEventDispatcher audioLevelEventDispatcher = this.eventDispatcher;
        synchronized (audioLevelEventDispatcher) {
            if (this.open) {
                this.open = false;
                this.eventDispatcher.setAudioLevelListener(null);
            }
        }
    }

    @Override
    public void reset() {
    }
}

