/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.client;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.queue.RemoveOperation;
import com.hazelcast.queue.client.QueueRequest;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class RemoveRequest
extends QueueRequest {
    Data data;

    public RemoveRequest() {
    }

    public RemoveRequest(String name, Data data) {
        super(name);
        this.data = data;
    }

    @Override
    protected Operation prepareOperation() {
        return new RemoveOperation(this.name, this.data);
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        super.writePortable(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.data.writeData(out);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        super.readPortable(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.data = new Data();
        this.data.readData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        return new QueuePermission(this.name, "remove");
    }
}

