/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.txn;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.multimap.MultiMapContainer;
import com.hazelcast.multimap.MultiMapRecord;
import com.hazelcast.multimap.MultiMapService;
import com.hazelcast.multimap.MultiMapWrapper;
import com.hazelcast.multimap.operations.MultiMapKeyBasedOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.Collection;

public class TxnPutOperation
extends MultiMapKeyBasedOperation {
    long recordId;
    Data value;
    transient long begin = -1L;

    public TxnPutOperation() {
    }

    public TxnPutOperation(String name, Data dataKey, Data value, long recordId) {
        super(name, dataKey);
        this.recordId = recordId;
        this.value = value;
    }

    @Override
    public void run() throws Exception {
        this.begin = Clock.currentTimeMillis();
        MultiMapContainer container = this.getOrCreateContainer();
        MultiMapWrapper wrapper = container.getOrCreateMultiMapWrapper(this.dataKey);
        this.response = true;
        if (wrapper.containsRecordId(this.recordId)) {
            this.response = false;
            return;
        }
        Collection<MultiMapRecord> coll = wrapper.getCollection(false);
        MultiMapRecord record = new MultiMapRecord(this.recordId, this.isBinary() ? this.value : this.toObject(this.value));
        coll.add(record);
    }

    @Override
    public void afterRun() throws Exception {
        long elapsed = Math.max(0L, Clock.currentTimeMillis() - this.begin);
        MultiMapService service = (MultiMapService)this.getService();
        service.getLocalMultiMapStatsImpl(this.name).incrementPuts(elapsed);
        if (Boolean.TRUE.equals(this.response)) {
            this.publishEvent(EntryEventType.ADDED, this.dataKey, this.value);
        }
    }

    public long getRecordId() {
        return this.recordId;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.recordId);
        this.value.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.recordId = in.readLong();
        this.value = new Data();
        this.value.readData(in);
    }

    @Override
    public int getId() {
        return 33;
    }
}

