/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class MultiMapEvent
implements DataSerializable {
    private String name;
    private Data key;
    private Data value;
    private EntryEventType eventType;
    private Address caller;

    public MultiMapEvent() {
    }

    public MultiMapEvent(String name, Data key, Data value, EntryEventType eventType, Address caller) {
        this.name = name;
        this.key = key;
        this.value = value;
        this.eventType = eventType;
        this.caller = caller;
    }

    public String getName() {
        return this.name;
    }

    public Data getValue() {
        return this.value;
    }

    public EntryEventType getEventType() {
        return this.eventType;
    }

    public Address getCaller() {
        return this.caller;
    }

    public Data getKey() {
        return this.key;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        this.key.writeData(out);
        IOUtil.writeNullableData(out, this.value);
        out.writeInt(this.eventType.getType());
        this.caller.writeData(out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.key = IOUtil.readData(in);
        this.value = IOUtil.readNullableData(in);
        this.eventType = EntryEventType.getByType(in.readInt());
        this.caller = new Address();
        this.caller.readData(in);
    }
}

