/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import java.io.IOException;
import java.util.Arrays;

public class PostJoinOperation
extends AbstractOperation {
    private transient Operation[] operations;

    public PostJoinOperation() {
    }

    public PostJoinOperation(Operation ... ops) {
        for (Operation op : ops) {
            if (op == null) {
                throw new NullPointerException();
            }
            if (!(op instanceof PartitionAwareOperation)) continue;
            throw new IllegalArgumentException("Post join operation can not be a PartitionAwareOperation!");
        }
        this.operations = ops;
    }

    @Override
    public void beforeRun() throws Exception {
        if (this.operations != null && this.operations.length > 0) {
            NodeEngine nodeEngine = this.getNodeEngine();
            for (Operation op : this.operations) {
                op.setNodeEngine(nodeEngine).setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
                OperationAccessor.setCallerAddress(op, this.getCallerAddress());
                OperationAccessor.setConnection(op, this.getConnection());
                this.operations[i] = op;
            }
        }
    }

    @Override
    public void run() throws Exception {
        if (this.operations != null && this.operations.length > 0) {
            OperationService operationService = this.getNodeEngine().getOperationService();
            for (Operation op : this.operations) {
                operationService.runOperation(op);
            }
        }
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        int len = this.operations != null ? this.operations.length : 0;
        out.writeInt(len);
        if (len > 0) {
            for (Operation op : this.operations) {
                out.writeObject(op);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int len = in.readInt();
        this.operations = new Operation[len];
        for (int i = 0; i < len; ++i) {
            this.operations[i] = (Operation)in.readObject();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PostJoinOperation{");
        sb.append("operations=").append(Arrays.toString(this.operations));
        sb.append('}');
        return sb.toString();
    }
}

