/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.spring;

import com.voxeo.utils.Objects;
import com.voxeo.utils.Strings;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildContextFactoryBean
implements FactoryBean<Object>,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    private ApplicationContext parentContext;
    private AbstractApplicationContext childContext;
    private String[] locations;
    private String beanName;
    private Class<?> beanClass;
    private Type type = Type.CLASSPATH;
    private Object targetBean;

    public void afterPropertiesSet() throws Exception {
        Objects.assertion(this.parentContext != null, "null parent context", new Object[0]);
        this.childContext = this.parentContext instanceof FileSystemXmlApplicationContext ? new FileSystemXmlApplicationContext(this.locations, this.parentContext) : new ClassPathXmlApplicationContext(this.locations, this.parentContext);
        if (!Strings.isEmpty(this.beanName)) {
            this.targetBean = this.childContext.getBean(this.beanName);
            if (this.beanClass == null) {
                this.beanClass = this.childContext.getType(this.beanName);
            }
        }
        if (this.beanClass != null) {
            if (this.targetBean != null) {
                Objects.assertion(this.beanClass.isAssignableFrom(this.targetBean.getClass()), "bean %s is of unexpected type %s (expected %s)", this.beanName, this.targetBean.getClass(), this.beanClass);
            } else {
                Map.Entry<String, Object> beanEntry = this.getBeanByType();
                this.beanName = beanEntry.getKey();
                this.targetBean = beanEntry.getValue();
            }
        }
    }

    private Map.Entry<String, Object> getBeanByType() {
        Map beans = this.childContext.getBeansOfType(this.beanClass);
        Objects.assertion(beans.size() == 1, "found %d beans of type %s, expected one", beans.size(), this.beanClass);
        Map.Entry<String, Object> result = beans.entrySet().iterator().next();
        return result;
    }

    public void destroy() throws Exception {
        if (this.childContext != null) {
            this.childContext.close();
        }
    }

    public Object getObject() throws Exception {
        return this.targetBean;
    }

    public Class<?> getObjectType() {
        return this.beanClass;
    }

    public boolean isSingleton() {
        return this.childContext.isSingleton(this.beanName);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContext = applicationContext;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String targetBeanName) {
        this.beanName = targetBeanName;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> targetBeanClass) {
        this.beanClass = targetBeanClass;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public void setLocations(String[] locations) {
        this.locations = locations;
    }

    public String getLocation() {
        return !Objects.isEmpty(this.locations) ? this.locations[0] : null;
    }

    public void setLocation(String location) {
        this.locations = new String[]{location};
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        FILESYSTEM,
        CLASSPATH;

    }
}

