/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.sentinel.protocols;

import com.voxeo.sentinel.local.LocalSentinelThread;
import com.voxeo.sentinel.protocols.SentinelDecoder;
import com.voxeo.sentinel.protocols.SentinelEncoder;
import com.voxeo.versioning.Module;
import java.io.BufferedReader;
import java.io.PrintWriter;
import org.apache.log4j.Logger;

public class LocalSentinelProtocol {
    private static final Logger Log = Logger.getLogger(LocalSentinelProtocol.class);
    private static final int ACK = 0;
    private static final int REQOBJ = 2;
    private static final int DONE = 3;
    private int state = 0;
    private SentinelEncoder out = null;
    private SentinelDecoder in = null;
    private LocalSentinelThread localThread = null;
    private final Object notify = new Object();

    public LocalSentinelProtocol(BufferedReader in, PrintWriter out, LocalSentinelThread localThread) {
        this.in = new SentinelDecoder(in, true);
        this.out = new SentinelEncoder(out, true);
        this.localThread = localThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rcvModule() {
        boolean returnValue = false;
        this.state = 0;
        try {
            this.out.sendMsg(this.state);
            while (this.in.getMsg(this.state)) {
                ++this.state;
                Log.debug((Object)("SERVER IS IN STATE " + this.state));
                if (this.state == 2) {
                    this.out.sendMsg(this.state);
                    Log.debug((Object)"Server ready for XML");
                    String xmlIn = this.in.getCustomMsg();
                    Module tmpMod = Module.parseXML(xmlIn);
                    this.localThread.registerModule(tmpMod, this);
                    Object object = this.notify;
                    synchronized (object) {
                        this.notify.notifyAll();
                    }
                    returnValue = true;
                    ++this.state;
                }
                this.out.sendMsg(this.state);
                if (this.state < 3) continue;
                returnValue = true;
                this.state = 0;
            }
            Log.debug((Object)"\n\nSERVER OUT OF THE LOOP\n\n");
        }
        catch (Exception e) {
            Log.error((Object)"LocalSentinelProtocol::rcvModule() - Exception: ", (Throwable)e);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRefresh() {
        Object object = this.notify;
        synchronized (object) {
            this.out.sendMsg(this.state);
            try {
                this.notify.wait();
            }
            catch (InterruptedException e) {
                Log.warn((Object)"waitForRefresh got interrupted.");
            }
        }
    }
}

