/*
 * Decompiled with CFR 0.152.
 */
package com.rayo.core.xml.providers;

import com.rayo.core.validation.ValidationException;
import com.rayo.core.verb.MediaType;
import com.rayo.core.verb.Transfer;
import com.rayo.core.verb.TransferCompleteEvent;
import com.rayo.core.xml.providers.BaseProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class TransferProvider
extends BaseProvider {
    private static final Namespace NAMESPACE = new Namespace("", "urn:xmpp:tropo:transfer:1");
    private static final Namespace COMPLETE_NAMESPACE = new Namespace("", "urn:xmpp:tropo:transfer:complete:1");

    @Override
    protected Object processElement(Element element) throws Exception {
        if (element.getName().equals("transfer")) {
            return this.buildTransfer(element);
        }
        if (element.getNamespace().equals((Object)RAYO_COMPONENT_NAMESPACE)) {
            return this.buildCompleteCommand(element);
        }
        return null;
    }

    private Object buildTransfer(Element element) throws URISyntaxException {
        Element root = element;
        Transfer transfer = new Transfer();
        if (root.attributeValue("terminator") != null) {
            transfer.setTerminator(this.toTerminator(root.attributeValue("terminator")));
        }
        if (root.attributeValue("timeout") != null) {
            transfer.setTimeout(this.toTimeout(root.attributeValue("timeout")));
        }
        if (root.attributeValue("answer-on-media") != null) {
            transfer.setAnswerOnMedia(this.toBoolean("answer-on-media", element));
        }
        if (root.attributeValue("media") != null) {
            try {
                transfer.setMedia(MediaType.getFromString(root.attributeValue("media")));
            }
            catch (Exception e) {
                throw new ValidationException("Invalid media.");
            }
        }
        if (root.element("ringback") != null) {
            transfer.setRingbackTone(this.extractSsml(root.element("ringback")));
        }
        if (root.attributeValue("from") != null) {
            transfer.setFrom(this.toURI(root.attributeValue("from")));
        }
        if (root.element("to") != null || root.attributeValue("to") != null) {
            ArrayList<URI> uriList = new ArrayList<URI>();
            String to = root.attributeValue("to");
            if (to != null && !to.trim().equals("")) {
                uriList.add(this.toURI(to));
            }
            List elements = root.elements("to");
            for (Element e : elements) {
                if (e.getText().equals("")) continue;
                uriList.add(this.toURI(e.getText()));
            }
            transfer.setTo(uriList);
        }
        transfer.setHeaders(this.grabHeaders(root));
        return transfer;
    }

    private Object buildCompleteCommand(Element element) {
        Element reasonElement = (Element)element.elements().get(0);
        String reasonValue = reasonElement.getName().toUpperCase();
        TransferCompleteEvent.Reason reason = TransferCompleteEvent.Reason.valueOf(reasonValue);
        TransferCompleteEvent complete = new TransferCompleteEvent();
        complete.setReason(reason);
        if (element.element("error") != null) {
            complete.setErrorText(element.elementText("error"));
        }
        return complete;
    }

    @Override
    protected void generateDocument(Object object, Document document) throws Exception {
        if (object instanceof Transfer) {
            this.createTransfer(object, document);
        } else if (object instanceof TransferCompleteEvent) {
            this.createTransferCompleteEvent((TransferCompleteEvent)object, document);
        }
    }

    private void createTransfer(Object object, Document document) throws Exception {
        Transfer transfer = (Transfer)object;
        Element root = document.addElement(new QName("transfer", NAMESPACE));
        this.addHeaders(transfer.getHeaders(), document.getRootElement());
        if (transfer.getRingbackTone() != null) {
            Element ringback = root.addElement("ringback");
            this.addSsml(transfer.getRingbackTone(), ringback);
        }
        if (transfer.getTerminator() != null) {
            root.addAttribute("terminator", transfer.getTerminator().toString());
        }
        if (transfer.getTimeout() != null) {
            root.addAttribute("timeout", Long.toString(transfer.getTimeout().getMillis()));
        }
        if (transfer.getMedia() != null) {
            root.addAttribute("media", transfer.getMedia().toString());
        }
        if (transfer.getFrom() != null) {
            root.addAttribute("from", transfer.getFrom().toString());
        }
        if (transfer.getTo() != null) {
            if (transfer.getTo().size() == 1) {
                root.addAttribute("to", transfer.getTo().get(0).toString());
            } else {
                for (URI uri : transfer.getTo()) {
                    root.addElement("to").setText(uri.toString());
                }
            }
        }
        root.addAttribute("answer-on-media", String.valueOf(transfer.isAnswerOnMedia()));
    }

    private void createTransferCompleteEvent(TransferCompleteEvent event, Document document) throws Exception {
        this.addCompleteElement(document, event, COMPLETE_NAMESPACE);
    }
}

