/*
 * Decompiled with CFR 0.152.
 */
package com.rayo.core.verb;

import com.rayo.core.verb.AbstractVerbEvent;
import com.rayo.core.verb.Verb;
import com.rayo.core.verb.VerbCompleteReason;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class VerbCompleteEvent
extends AbstractVerbEvent {
    private String errorText;
    @NotNull(message="Complete event with no reason!")
    protected VerbCompleteReason reason;

    public VerbCompleteEvent() {
    }

    public VerbCompleteEvent(Verb verb) {
        super(verb);
    }

    public VerbCompleteEvent(VerbCompleteReason reason) {
        this.reason = reason;
    }

    public VerbCompleteEvent(Verb verb, VerbCompleteReason reason) {
        super(verb);
        this.reason = reason;
    }

    public VerbCompleteEvent(Verb verb, VerbCompleteReason reason, String errorText) {
        super(verb);
        this.reason = reason;
        this.errorText = errorText;
    }

    public VerbCompleteEvent(Verb verb, String errorText) {
        this(verb, Reason.ERROR, errorText);
    }

    public VerbCompleteReason getReason() {
        return this.reason;
    }

    public void setReason(VerbCompleteReason reason) {
        this.reason = reason;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public void setErrorText(String errorText) {
        this.errorText = errorText;
    }

    public boolean isSuccess() {
        return this.reason != Reason.ERROR;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("callId", (Object)this.getCallId()).append("verbId", (Object)this.getVerbId()).append("reason", (Object)this.reason).append("errorText", (Object)this.getErrorText()).toString();
    }

    public static enum Reason implements VerbCompleteReason
    {
        STOP,
        ERROR,
        HANGUP;

    }
}

