/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmyspaceiml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.jmyspaceiml.LoginResponse;
import net.sf.jmyspaceiml.MSIMException;
import net.sf.jmyspaceiml.MSIMParser;
import net.sf.jmyspaceiml.MessageListener;
import net.sf.jmyspaceiml.contact.ContactManager;
import net.sf.jmyspaceiml.log.Log;
import net.sf.jmyspaceiml.packet.ActionMessage;
import net.sf.jmyspaceiml.packet.ErrorMessage;
import net.sf.jmyspaceiml.packet.InstantMessage;
import net.sf.jmyspaceiml.packet.MediaMessage;
import net.sf.jmyspaceiml.packet.Packet;
import net.sf.jmyspaceiml.packet.PacketType;
import net.sf.jmyspaceiml.packet.ProfileMessage;
import net.sf.jmyspaceiml.packet.StatusMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSIMConnection {
    public static final String DEFAULT_HOST = "im.myspace.akadns.net";
    public static final int DEFAULT_PORT = 1863;
    public static final int CLIENT_VERSION = 697;
    public static final int CLIENT_AUTH_ALG = 196610;
    public static final int CLIENT_LANG_ID = 1033;
    public static final String CLIENT_LANG_NAME = "ENGLISH";
    private Socket socket;
    private String host;
    private int port;
    private int userid;
    private int sessionKey;
    private static boolean isConnected = false;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Thread readerThread;
    private Thread senderThread;
    private ContactManager contactManager = null;
    private List<MessageListener> messageListeners = new CopyOnWriteArrayList<MessageListener>();

    public MSIMConnection() {
        this.host = DEFAULT_HOST;
        this.port = 1863;
    }

    public MSIMConnection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void connect() throws MSIMException {
        try {
            this.socket = new Socket(this.host, this.port);
            this.socket.setSoTimeout(5000);
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
        }
        catch (IOException e) {
            throw new MSIMException();
        }
    }

    public void login(String username, String password) throws MSIMException {
        Log.debug("MSIMConnection.login()");
        try {
            String response0 = this.readWithTimeout();
            Log.debug("\nresponse0 = " + response0);
            int ncStart = response0.indexOf("nc\\") + 3;
            int ncEnd = response0.indexOf("==") + 2;
            String nc = response0.substring(ncStart, ncEnd);
            Log.debug("nc = " + nc);
            StringBuffer sb = new StringBuffer();
            LoginResponse lr = new LoginResponse();
            byte[] challengeResponse = lr.compute(lr.decode64(nc), username, password);
            sb.append("\\login2\\");
            sb.append(196610);
            sb.append("\\username\\");
            sb.append(username);
            sb.append("\\response\\");
            sb.append(lr.encode64(challengeResponse));
            sb.append("\\clientver\\");
            sb.append(697);
            sb.append("\\langid\\");
            sb.append(1033);
            sb.append("\\imlang\\");
            sb.append(CLIENT_LANG_NAME);
            sb.append("\\reconn\\");
            sb.append(0);
            sb.append("\\status\\");
            sb.append(100);
            sb.append("\\id\\");
            sb.append(1);
            sb.append("\\final\\");
            Log.debug("output = " + sb.toString());
            this.outputStream.write(sb.toString().getBytes());
            String response1 = this.readWithTimeout();
            Log.debug("\nresponse1 = " + response1);
            HashMap<String, Object> hash = MSIMParser.parse(response1);
            if (hash.containsKey("err")) {
                throw new MSIMException((String)hash.get("err"));
            }
            this.sessionKey = new Integer((String)hash.get("sesskey"));
            this.userid = new Integer((String)hash.get("userid"));
            Log.debug("userid = " + this.userid);
            Log.debug("sessionKey = " + this.sessionKey);
            isConnected = true;
            if (this.contactManager == null) {
                this.contactManager = new ContactManager(this);
            }
            this.readerThread = new Thread(){

                public void run() {
                    while (isConnected) {
                        MSIMConnection.this.readPackets();
                    }
                }
            };
            this.readerThread.start();
        }
        catch (Exception e) {
            throw new MSIMException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Log.debug("MSIMConnection.disconnect()");
        this.send("\\logout\\true\\sesskey\\" + this.sessionKey + "\\final\\");
        isConnected = false;
        this.readerThread = null;
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
        }
        finally {
            this.inputStream = null;
        }
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
        }
        finally {
            this.outputStream = null;
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.socket = null;
        }
        this.userid = -1;
        this.sessionKey = -1;
        this.contactManager = null;
    }

    public void send(String s) {
        try {
            if (this.outputStream != null) {
                this.outputStream.write(s.getBytes());
            }
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    public void sendPacket(Packet packet) {
        Log.debug("MSIMConnection.sendPacket(): " + packet.toString(this.sessionKey));
        if (packet == null) {
            return;
        }
        this.send(packet.toString(this.sessionKey));
    }

    private String readWithTimeout() throws IOException {
        Log.debug("MSIMConnection.readWithTimeout()");
        StringBuffer buffer = new StringBuffer();
        try {
            int c;
            while ((c = this.inputStream.read()) != -1) {
                buffer.append((char)c);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        return buffer.toString();
    }

    private void readPackets() {
        StringBuffer buffer = new StringBuffer();
        try {
            int c;
            while (!buffer.toString().endsWith("final\\") && (c = this.inputStream.read()) != -1) {
                buffer.append((char)c);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (buffer.toString().equals("")) {
            return;
        }
        Log.debug("Parsing a packet : " + buffer.toString());
        HashMap<String, Object> rawPacket = MSIMParser.parse(buffer.toString());
        if (rawPacket.containsKey("bm")) {
            PacketType type = PacketType.eval((String)rawPacket.get("bm"));
            if (type.equals((Object)PacketType.INSTANT_MESSAGE)) {
                InstantMessage message = new InstantMessage();
                message.setFrom((String)rawPacket.get("f"));
                message.setBody((String)rawPacket.get("msg"));
                this.invokeMessageListener(message);
            } else if (type.equals((Object)PacketType.STATUS_MESSAGE)) {
                String[] statusPcs = rawPacket.get("msg").toString().split("\\|");
                int statusType = Integer.valueOf(statusPcs[2]);
                String statusMsg = statusPcs[4];
                StatusMessage message = new StatusMessage();
                message.setFrom((String)rawPacket.get("f"));
                message.setStatusMessage(statusMsg);
                message.setStatusCode(statusType);
                this.invokeMessageListener(message);
            } else if (type.equals((Object)PacketType.ACTION_MESSAGE)) {
                ActionMessage message = new ActionMessage();
                message.setFrom((String)rawPacket.get("f"));
                message.setAction((String)rawPacket.get("msg"));
                this.invokeMessageListener(message);
            } else {
                Log.debug("Unsupported buddy message type: " + (Object)((Object)type));
            }
        } else if (rawPacket.containsKey("ka")) {
            Log.debug("Received keepalive packet.");
        } else if (rawPacket.containsKey("persistr")) {
            this.contactManager.parseContactListPacket(rawPacket);
        } else if (rawPacket.containsKey("error")) {
            ErrorMessage message = new ErrorMessage();
            message.setErrorMessage((String)rawPacket.get("errmsg"));
            message.setIsFatal(rawPacket.containsKey("fatal"));
            this.invokeMessageListener(message);
        } else {
            Log.debug("Unsupported packet type: " + rawPacket);
        }
    }

    public ContactManager getContactManager() {
        return this.contactManager;
    }

    public void addMessageListener(MessageListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.messageListeners.contains(listener)) {
            this.messageListeners.add(listener);
        }
    }

    public void removeMessageListener(MessageListener listener) {
        if (listener == null) {
            return;
        }
        this.messageListeners.remove(listener);
    }

    public List<MessageListener> getMessageListeners() {
        return this.messageListeners;
    }

    public void invokeMessageListener(InstantMessage message) {
        for (MessageListener listener : this.messageListeners) {
            listener.processIncomingMessage(message);
        }
    }

    public void invokeMessageListener(StatusMessage message) {
        for (MessageListener listener : this.messageListeners) {
            listener.processIncomingMessage(message);
        }
    }

    public void invokeMessageListener(ActionMessage message) {
        for (MessageListener listener : this.messageListeners) {
            listener.processIncomingMessage(message);
        }
    }

    public void invokeMessageListener(MediaMessage message) {
        for (MessageListener listener : this.messageListeners) {
            listener.processIncomingMessage(message);
        }
    }

    public void invokeMessageListener(ProfileMessage message) {
        for (MessageListener listener : this.messageListeners) {
            listener.processIncomingMessage(message);
        }
    }

    public void invokeMessageListener(ErrorMessage message) {
        for (MessageListener listener : this.messageListeners) {
            listener.processIncomingMessage(message);
        }
    }

    public boolean isConnected() {
        return isConnected;
    }

    public int getUserID() {
        return this.userid;
    }

    public int getSessionKey() {
        return this.sessionKey;
    }
}

