/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipOutputStream;

public class War
extends Jar {
    private static final FileUtils fu = FileUtils.newFileUtils();
    private File deploymentDescriptor;
    private boolean descriptorAdded;

    public void setWarfile(File file) {
        this.setDestFile(file);
    }

    public void setWebxml(File file) {
        this.deploymentDescriptor = file;
        if (!this.deploymentDescriptor.exists()) {
            throw new BuildException("Deployment descriptor: " + this.deploymentDescriptor + " does not exist.");
        }
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setFile(this.deploymentDescriptor);
        zipFileSet.setFullpath("WEB-INF/web.xml");
        super.addFileset(zipFileSet);
    }

    public void addLib(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("WEB-INF/lib/");
        super.addFileset(zipFileSet);
    }

    public void addClasses(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("WEB-INF/classes/");
        super.addFileset(zipFileSet);
    }

    public void addWebinf(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("WEB-INF/");
        super.addFileset(zipFileSet);
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        if (this.deploymentDescriptor == null && !this.isInUpdateMode()) {
            throw new BuildException("webxml attribute is required", this.getLocation());
        }
        super.initZipOutputStream(zipOutputStream);
    }

    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string, int n) throws IOException {
        if (string.equalsIgnoreCase("WEB-INF/web.xml")) {
            if (this.deploymentDescriptor == null || !fu.fileNameEquals(this.deploymentDescriptor, file) || this.descriptorAdded) {
                this.log("Warning: selected " + this.archiveType + " files include a WEB-INF/web.xml which will be ignored (please use webxml attribute to " + this.archiveType + " task)", 1);
            } else {
                super.zipFile(file, zipOutputStream, string, n);
                this.descriptorAdded = true;
            }
        } else {
            super.zipFile(file, zipOutputStream, string, n);
        }
    }

    protected void cleanUp() {
        this.descriptorAdded = false;
        super.cleanUp();
    }

    public War() {
        this.archiveType = "war";
        this.emptyBehavior = "create";
    }
}

