/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import weblogic.xml.babel.dtd.DTDException;
import weblogic.xml.babel.dtd.EntityTable;
import weblogic.xml.babel.scanner.Name;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;

final class PEReference {
    private ScannerState state;
    private Name name;
    private boolean returnToken = false;

    public void setReturnToken(boolean bl) {
        this.returnToken = bl;
    }

    public boolean getReturnToken() {
        return this.returnToken;
    }

    PEReference(ScannerState scannerState) {
        this.state = scannerState;
        this.name = new Name(scannerState);
    }

    void read() throws IOException, ScannerException {
        this.state.markInsert();
        this.state.expect('%');
        String string = this.name.stringRead();
        this.state.expect(';');
        if (this.returnToken) {
            this.state.pushToken(this.state.tokenFactory.createToken(27, string));
        }
        this.state.deleteFromLastInsertionPoint();
        try {
            EntityTable entityTable = this.state.getParameterEntityTable();
            this.state.insertData(entityTable.get(string).toCharArray());
        }
        catch (DTDException dTDException) {
            throw new ScannerException(string + " is an undefined parameter entity", this.state);
        }
    }

    void checkedRead() throws IOException, ScannerException {
        if (this.state.currentChar == '%') {
            this.read();
        }
    }
}

