/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.helpers;

import java.io.IOException;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import weblogic.xml.babel.helpers.Outputter;

class TestCase
implements ErrorHandler {
    public final String id;
    public final String inputURI;
    public final String sections;
    public String description;
    public final String type;
    public final String nvOutputURI;
    public final String valOutputURI;
    public final String entities;
    public boolean skipped;
    public String diagnostic;
    private Exception exception;
    public int diagnosticLevel;
    public String outputDiagnostic;
    public boolean pass;

    public TestCase(Attributes attributes, URL uRL) throws IOException {
        this.id = attributes.getValue("ID");
        this.inputURI = new URL(uRL, attributes.getValue("URI")).toString();
        this.type = attributes.getValue("TYPE");
        this.sections = attributes.getValue("SECTIONS");
        this.description = null;
        String string = attributes.getValue("OUTPUT");
        this.nvOutputURI = string != null ? new URL(uRL, string).toString() : null;
        string = attributes.getValue("OUTPUT3");
        this.valOutputURI = string != null ? new URL(uRL, string).toString() : null;
        this.entities = attributes.getValue("ENTITIES");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{XML Test");
        stringBuffer.append(", id=");
        stringBuffer.append(this.id);
        stringBuffer.append(", type=");
        stringBuffer.append(this.type);
        stringBuffer.append(", input=");
        stringBuffer.append(this.inputURI);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void run(XMLReader xMLReader, boolean bl) {
        try {
            InputSource inputSource = new InputSource(this.inputURI);
            Outputter outputter = null;
            this.pass = !"valid".equals(this.type) && !"invalid".equals(this.type);
            this.diagnosticLevel = -1;
            this.exception = null;
            xMLReader.setErrorHandler(this);
            if ("valid".equals(this.type)) {
                if (bl && this.valOutputURI != null) {
                    outputter = new Outputter(true, this.valOutputURI);
                } else if (this.nvOutputURI != null) {
                    outputter = new Outputter(false, this.nvOutputURI);
                }
            }
            if (outputter != null) {
                xMLReader.setContentHandler(outputter);
                xMLReader.setDTDHandler(outputter);
            } else {
                DefaultHandler defaultHandler = new DefaultHandler();
                xMLReader.setContentHandler(defaultHandler);
                xMLReader.setDTDHandler(defaultHandler);
            }
            xMLReader.parse(inputSource);
            if ("error".equals(this.type)) {
                this.pass = true;
            } else if ("not-wf".equals(this.type)) {
                this.pass = false;
                if (this.diagnostic == null) {
                    this.diagnostic = "[Document not WF; no error reported]";
                }
            } else if ("valid".equals(this.type) || "invalid".equals(this.type) && !bl) {
                if (this.diagnosticLevel == -1) {
                    this.pass = true;
                } else {
                    this.pass = false;
                    if (this.diagnostic == null) {
                        this.diagnostic = "[no diagnostic]";
                    }
                }
            } else if ("invalid".equals(this.type) && bl) {
                boolean bl2 = this.pass = this.diagnosticLevel == 0;
                if (!this.pass && this.diagnostic == null) {
                    this.diagnostic = "[Document invalid; no error reported]";
                }
            } else {
                this.diagnostic = "[ ?? ]";
            }
            if (outputter != null) {
                this.outputDiagnostic = outputter.getDiagnostic(false);
            }
        }
        catch (SAXParseException sAXParseException) {
            if (this.exception == null || this.diagnosticLevel == -1) {
                this.diagnostic = "(thrown SAXParseException) ";
                this.diagnostic = sAXParseException.getMessage() != null ? this.diagnostic + sAXParseException.getMessage() : this.diagnostic + "[no exception message]";
                this.diagnosticLevel = 2;
            } else if (sAXParseException != this.exception) {
                this.diagnostic = "(odd SAXParseException) " + this.diagnostic;
            } else if (this.diagnostic == null) {
                this.diagnostic = "(odd SAXParseException) [null]";
            }
        }
        catch (SAXException sAXException) {
            if (this.exception == null || this.diagnosticLevel == -1) {
                this.diagnostic = "(thrown SAXException) ";
                this.diagnostic = sAXException.getMessage() != null ? this.diagnostic + sAXException.getMessage() : this.diagnostic + "[no exception message]";
                this.diagnosticLevel = 2;
            } else {
                this.diagnostic = "(odd SAXException) " + this.diagnostic;
            }
        }
        catch (IOException iOException) {
            if (this.exception == null || this.diagnosticLevel == -1) {
                this.diagnostic = "(thrown IOException) ";
                this.diagnostic = iOException.getMessage() != null ? this.diagnostic + iOException.getMessage() : this.diagnostic + "[no exception message]";
                this.diagnosticLevel = 2;
            } else {
                this.diagnostic = "(odd IOException) " + this.diagnostic;
            }
        }
        catch (Exception exception) {
            String string = exception.getClass().getName();
            if (this.exception == null || this.diagnosticLevel == -1) {
                this.diagnostic = "(thrown " + string + ") ";
                this.diagnostic = exception.getMessage() != null ? this.diagnostic + exception.getMessage() : this.diagnostic + "[no exception message]";
                this.diagnosticLevel = 2;
            }
            this.diagnostic = "(odd " + string + ") " + this.diagnostic;
        }
        this.exception = null;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.exception != null) {
            return;
        }
        this.diagnostic = "(warning) ";
        this.diagnostic = sAXParseException.getMessage() != null ? this.diagnostic + sAXParseException.getMessage() : this.diagnostic + "[no exception message]";
        this.diagnosticLevel = -1;
        this.exception = sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.exception != null && this.diagnosticLevel != -1) {
            return;
        }
        this.diagnostic = "(error) ";
        this.diagnostic = sAXParseException.getMessage() != null ? this.diagnostic + sAXParseException.getMessage() : this.diagnostic + "[no exception message]";
        this.diagnosticLevel = 0;
        this.exception = sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.diagnostic = "(fatal) ";
        this.diagnostic = sAXParseException.getMessage() != null ? this.diagnostic + sAXParseException.getMessage() : this.diagnostic + "[no exception message]";
        this.diagnosticLevel = 1;
        this.exception = sAXParseException;
        throw sAXParseException;
    }
}

