/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractCollection;
import java.util.EmptyStackException;
import java.util.Iterator;
import weblogic.utils.collections.ArrayIterator;

public final class Stack
extends AbstractCollection {
    private Object[] values;
    private int pointer;

    public Stack() {
        this(15);
    }

    public Stack(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.values = new Object[n];
        this.pointer = 0;
    }

    private Stack(Object[] objectArray, int n) {
        this.values = objectArray;
        this.pointer = n;
    }

    private void resize() {
        if (this.pointer == 0) {
            this.values = new Object[1];
            return;
        }
        Object[] objectArray = new Object[this.pointer * 2];
        System.arraycopy(this.values, 0, objectArray, 0, this.pointer);
        this.values = objectArray;
    }

    public boolean add(Object object) {
        this.push(object);
        return true;
    }

    public void clear() {
        Object[] objectArray = this.values;
        while (this.pointer > 0) {
            objectArray[--this.pointer] = null;
        }
    }

    public boolean isEmpty() {
        return this.pointer == 0;
    }

    public Iterator iterator() {
        Object[] objectArray = new Object[this.pointer];
        System.arraycopy(this.values, 0, objectArray, 0, this.pointer);
        return new ArrayIterator(objectArray);
    }

    public Object clone() {
        Object[] objectArray = new Object[this.pointer];
        System.arraycopy(this.values, 0, objectArray, 0, this.pointer);
        return new Stack(objectArray, this.pointer);
    }

    public int size() {
        return this.pointer;
    }

    public void push(Object object) {
        if (this.pointer == this.values.length) {
            this.resize();
        }
        this.values[this.pointer++] = object;
    }

    public Object pop() {
        try {
            Object object = this.values[--this.pointer];
            this.values[this.pointer] = null;
            return object;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.pointer < 0) {
                this.pointer = 0;
            }
            throw new EmptyStackException();
        }
    }

    public Object peek() {
        try {
            return this.values[this.pointer - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EmptyStackException();
        }
    }
}

