/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.dtd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.baseparser.Space;
import weblogic.xml.babel.dtd.AttributeDefinition;
import weblogic.xml.babel.dtd.Declaration;
import weblogic.xml.babel.dtd.Name;
import weblogic.xml.babel.scanner.ScannerException;

public class AttributeListDeclaration
extends Declaration {
    private Name name;
    private List attributeDefinitions;
    private Space space;

    public AttributeListDeclaration() {
        this.init();
    }

    public void init() {
        super.init();
        this.name = new Name();
        this.space = new Space();
        this.attributeDefinitions = new ArrayList();
    }

    public void parse(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        baseParser.accept(40);
        this.init();
        this.name.parse(baseParser);
        this.space.parse(baseParser);
        while (Name.checkStarters(baseParser.getCurrentToken().tokenType)) {
            AttributeDefinition attributeDefinition = new AttributeDefinition();
            attributeDefinition.parse(baseParser);
            this.addDefinition(attributeDefinition);
            this.space.parse(baseParser);
        }
        baseParser.accept(39);
        this.type = 11;
    }

    public void addDefinition(AttributeDefinition attributeDefinition) {
        this.attributeDefinitions.add(attributeDefinition);
    }

    public List getDefinitions() {
        return this.attributeDefinitions;
    }

    public String toString() {
        String string = "<!ATTLIST " + this.name;
        Iterator iterator = this.attributeDefinitions.iterator();
        while (iterator.hasNext()) {
            string = string + " \n\t" + (AttributeDefinition)iterator.next();
        }
        string = string + " " + ">";
        return string;
    }

    public String getRawName() {
        return this.name.getRawName();
    }
}

