/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.Selector;
import net.sf.cindy.impl.StreamChannelSession;

public class PipeSession
extends StreamChannelSession {
    private Pipe pipe;

    public void setPipe(Pipe pipe) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set pipe after session started");
        }
        this.pipe = pipe;
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    public synchronized void start(boolean bl) throws IllegalStateException {
        if (this.isStarted()) {
            return;
        }
        if (this.pipe == null) {
            try {
                this.pipe = Pipe.open();
            }
            catch (IOException iOException) {
                this.dispatchException(iOException);
                this.dispatchSessionClosed();
                return;
            }
        }
        this.startSession(this.pipe.source(), this.pipe.sink(), bl);
    }

    protected void onRegister(Selector selector) {
        try {
            this.pipe.sink().register(selector, 0, this);
            this.pipe.source().register(selector, 1, this);
            super.onRegister(selector);
            this.dispatchSessionEstablished();
        }
        catch (ClosedChannelException closedChannelException) {
            this.close();
        }
    }

    protected void onUnregister() {
        this.pipe = null;
        super.onUnregister();
    }
}

