/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.info;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.info.InfoResponseListener;
import net.kano.joustsim.oscar.oscar.service.info.InfoService;
import net.kano.joustsim.oscar.oscar.service.info.MutableInfoService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InfoRequestManager {
    private final MutableInfoService service;
    private final Map<Screenname, Set<InfoResponseListener>> listenerMap = new HashMap<Screenname, Set<InfoResponseListener>>();

    protected InfoRequestManager(MutableInfoService service) {
        this.service = service;
    }

    public void request(Screenname sn) {
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        this.request(sn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(Screenname sn, InfoResponseListener listener) {
        boolean shouldRequest;
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        InfoRequestManager infoRequestManager = this;
        synchronized (infoRequestManager) {
            shouldRequest = this.storeListener(sn, listener);
        }
        if (shouldRequest) {
            this.sendRequest(sn);
        }
    }

    protected abstract void sendRequest(Screenname var1);

    private synchronized boolean storeListener(Screenname sn, InfoResponseListener listener) {
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        boolean shouldRequest = !this.listenerMap.containsKey(sn);
        Set<InfoResponseListener> listeners = this.getListeners(sn);
        if (listener != null) {
            listeners.add(listener);
        }
        return shouldRequest;
    }

    protected final synchronized Set<InfoResponseListener> getListeners(Screenname sn) {
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        Set<InfoResponseListener> set = this.listenerMap.get(sn);
        if (set == null) {
            set = new LinkedHashSet<InfoResponseListener>();
            set.add(this.service.getInfoRequestListener());
            this.listenerMap.put(sn, set);
        }
        return set;
    }

    protected final synchronized Set<InfoResponseListener> clearListeners(Screenname sn) {
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        Set<InfoResponseListener> set = this.listenerMap.remove(sn);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public InfoService getService() {
        return this.service;
    }
}

